# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# These are the default window titles everywhere except macOS.
# .data-title-default and .data-title-private are used when the web content
# opened has no title:
#
# default - "Mozilla Firefox"
# private - "Mozilla Firefox (Private Browsing)"
#
# .data-content-title-default and .data-content-title-private are for use when
# there *is* a content title.
# Variables:
#  $content-title (String): the title of the web content.
browser-main-window-window-titles =
    .data-title-default = { -brand-full-name }
    .data-title-private = Shfletim Privat { -brand-full-name }
    .data-content-title-default = { $content-title } — { -brand-full-name }
    .data-content-title-private = { $content-title } — Shfletim Privat { -brand-full-name }
# These are the default window titles on macOS.
# .data-title-default and .data-title-private are used when the web content
# opened has no title:
#
#
# "default" - "Mozilla Firefox"
# "private" - "Mozilla Firefox — (Private Browsing)"
#
# .data-content-title-default and .data-content-title-private are for use when
# there *is* a content title.
# Do not use the brand name in these, as we do on non-macOS.
#
# Also note the other subtle difference here: we use a `-` to separate the
# brand name from `(Private Browsing)`, which does not happen on other OSes.
#
# Variables:
#  $content-title (String): the title of the web content.
browser-main-window-mac-window-titles =
    .data-title-default = { -brand-full-name }
    .data-title-private = { -brand-full-name } — Shfletim Privat
    .data-content-title-default = { $content-title }
    .data-content-title-private = { $content-title } — Shfletim Privat
# This gets set as the initial title, and is overridden as soon as we start
# updating the titlebar based on loaded tabs or private browsing state.
# This should match the `data-title-default` attribute in both
# `browser-main-window` and `browser-main-window-mac`.
browser-main-window-title = { -brand-full-name }
# The non-variable portion of this MUST match the translation of
# "PRIVATE_BROWSING_SHORTCUT_TITLE" in custom.properties
private-browsing-shortcut-text-2 = Shfletim Privat { -brand-shortcut-name }
# These are the default window titles everywhere except macOS.
# .data-title-default and .data-title-private are used when the web content
# opened has no title:
#
# default - "Mozilla Firefox"
# private - "Mozilla Firefox (Private Browsing)"
#
# .data-content-title-default and .data-content-title-private are for use when
# there *is* a content title.
#
# .data-title-default-with-profile, .data-title-private-with-profile,
# .data-content-title-default-with-profile,
# .data-content-title-private-with-profile are used when there a
# SelectableProfileService.current profile exists.
#
# Variables:
#  $content-title (String): the title of the web content.
#  $profile-name (String): the name of the current profile.
browser-main-window-titles =
    .data-title-default = { -brand-full-name }
    .data-title-private = Shfletim Privat { -brand-full-name }
    .data-title-default-with-profile = { $profile-name } — { -brand-full-name }
    .data-title-private-with-profile = { $profile-name } — Shfletim Privat { -brand-full-name }
    .data-content-title-default = { $content-title } — { -brand-full-name }
    .data-content-title-private = { $content-title } — Shfletim Privat { -brand-full-name }
    .data-content-title-default-with-profile = { $content-title } — { $profile-name } — { -brand-full-name }
    .data-content-title-private-with-profile = { $content-title } — { $profile-name } — Shfletim Privat { -brand-full-name }
# These are the default window titles on macOS.
# .data-title-default and .data-title-private are used when the web content
# opened has no title:
#
#
# "default" - "Mozilla Firefox"
# "private" - "Mozilla Firefox — (Private Browsing)"
#
# .data-content-title-default and .data-content-title-private are for use when
# there *is* a content title.
# Do not use the brand name in these, as we do on non-macOS.
#
# .data-title-default-with-profile, .data-title-private-with-profile,
# .data-content-title-default-with-profile,
# .data-content-title-private-with-profile are used when there a
# SelectableProfileService.current profile exists.
#
# Also note the other subtle difference here: we use a `-` to separate the
# brand name from `(Private Browsing)`, which does not happen on other OSes.
#
# Variables:
#  $content-title (String): the title of the web content.
#  $profile-name (String): the name of the current profile.
browser-main-window-titles-mac =
    .data-title-default = { -brand-full-name }
    .data-title-private = { -brand-full-name } — Shfletim Privat
    .data-title-default-with-profile = { $profile-name } — { -brand-full-name }
    .data-title-private-with-profile = { $profile-name } — Shfletim Privat { -brand-full-name }
    .data-content-title-default = { $content-title }
    .data-content-title-private = { $content-title } — Shfletim Privat
    .data-content-title-default-with-profile = { $content-title } — { $profile-name }
    .data-content-title-private-with-profile = { $content-title } — { $profile-name } — Shfletim Privat
# This is the initial default title for the browser window.
# It gets updated based on loaded tabs or private browsing state.
browser-main-window-default-title = { -brand-full-name }
# Note: only on macOS do we use a `-` separator between the brand name and the
# "Private Browsing" suffix.
browser-main-private-window-title =
    { PLATFORM() ->
        [macos] { -brand-full-name } — Shfletim Privat
       *[other] Shfletim Privat { -brand-full-name }
    }
# This is only used on macOS; on other OSes we use the full private window
# title (so including the brand name) as a suffix
browser-main-private-suffix-for-content = Shfletim Privat
popups-infobar-dont-show-message2 =
    .label = Mos e shfaq këtë mesazh, kur bllokohen flluska, ose ridrejtime nga palë të treta
    .accesskey = M
edit-popup-settings2 =
    .label = Administroni rregullime për flluska dhe ridrejtime nga palë të treta…
    .accesskey = A

##

urlbar-identity-button =
    .aria-label = Shihni hollësi sajti

## Tooltips for images appearing in the address bar

urlbar-services-notification-anchor =
    .tooltiptext = Hapni panelin e mesazheve të instalimit
urlbar-web-notification-anchor =
    .tooltiptext = Ndryshoni zgjedhjen për nëse mund të merrni njoftime nga sajti apo jo
urlbar-midi-notification-anchor =
    .tooltiptext = Hapni panel MIDI
urlbar-eme-notification-anchor =
    .tooltiptext = Administroni përdorim software-i DRM
urlbar-web-authn-anchor =
    .tooltiptext = Hap panel Mirëfilltësimesh Web
urlbar-canvas-notification-anchor =
    .tooltiptext = Administroni leje përftimesh nga kanavaca
urlbar-web-rtc-share-microphone-notification-anchor =
    .tooltiptext = Administroni ndarjen me sajtin të mikrofonit tuaj
urlbar-default-notification-anchor =
    .tooltiptext = Hapni panelin e mesazheve
urlbar-geolocation-notification-anchor =
    .tooltiptext = Hapni panel kërkesash vendndodhjesh
urlbar-localhost-notification-anchor =
    .tooltiptext = Administroni hyrje pajisjesh vendore për këtë sajt
urlbar-local-network-notification-anchor =
    .tooltiptext = Administroni dhënie përdorimi të rrjetit tuaj vendor këtij sajti
urlbar-xr-notification-anchor =
    .tooltiptext = Hapni panel lejesh për realitet virtual
urlbar-storage-access-anchor =
    .tooltiptext = Hapni panelin e lejeve mbi veprimtari shfletimi
urlbar-web-rtc-share-screen-notification-anchor =
    .tooltiptext = Administroni ndarjen me sajtin të dritares ose ekranit tuaj
urlbar-indexed-db-notification-anchor =
    .tooltiptext = Hapni panelin për depozitim jashtë linje
urlbar-password-notification-anchor =
    .tooltiptext = Hapni panel mesazhi ruajtje fjalëkalimi
urlbar-plugins-notification-anchor =
    .tooltiptext = Administroni përdorim shtojcash
urlbar-web-rtc-share-devices-notification-anchor =
    .tooltiptext = Administroni ndarjen me sajtin të kamerës dhe/ose mikrofonit tuaj
# "Speakers" is used in a general sense that might include headphones or
# another audio output connection.
urlbar-web-rtc-share-speaker-notification-anchor =
    .tooltiptext = Administroni ndarje altoparlantësh të tjerë me sajtin
urlbar-autoplay-notification-anchor =
    .tooltiptext = Hap panel vetëluajtje
urlbar-persistent-storage-notification-anchor =
    .tooltiptext = Depozitoni të dhëna në Depozitë të Qëndrueshme
urlbar-addons-notification-anchor =
    .tooltiptext = Hapni kuadratin e mesazhit të instalimit të shtesës
urlbar-tip-help-icon =
    .title = Merrni ndihmë
urlbar-search-tips-confirm = OK, E mora vesh
urlbar-search-tips-confirm-short = E mora vesh
# Read out before Urlbar Tip text content so screenreader users know the
# subsequent text is a tip offered by the browser. It should end in a colon or
# localized equivalent.
urlbar-tip-icon-description =
    .alt = Ndihmëz:
urlbar-result-menu-button =
    .title = Hape menunë
urlbar-result-menu-button-feedback = Përshtypje
    .title = Hap menunë
urlbar-result-menu-learn-more =
    .label = Mësoni më tepër
    .accesskey = M
urlbar-result-menu-remove-from-history =
    .label = Hiqe prej historiku
    .accesskey = H
urlbar-result-menu-tip-get-help =
    .label = Merrni ndihmë
    .accesskey = d
urlbar-result-menu-dismiss-suggestion =
    .label = Hidhe tej këtë sugjerim
    .accesskey = H
urlbar-result-menu-learn-more-about-firefox-suggest =
    .label = Mësoni më tepër rreth { -firefox-suggest-brand-name }
    .accesskey = M
urlbar-result-menu-manage-firefox-suggest =
    .label = Administroni { -firefox-suggest-brand-name }
    .accesskey = A
# Some urlbar suggestions show the user's approximate location as automatically
# detected by Firefox (e.g., weather suggestions), and this menu item lets the
# user tell Firefox that the location is not accurate. Typically the location
# will be a city name, or a city name combined with the name of its parent
# administrative division (e.g., a province, prefecture, or state).
urlbar-result-menu-report-inaccurate-location =
    .label = Njoftoni për vendndodhje të pasaktë
urlbar-result-menu-show-less-frequently =
    .label = Shfaqi më rrallë
urlbar-result-menu-dont-show-weather-suggestions =
    .label = Mos shfaq sugjerime moti
# Used for Split Button.
urlbar-splitbutton-dropmarker =
    .title = Hape menunë
# A message shown in the urlbar when the user submits feedback on a suggestion
# (e.g., it shows an inaccurate location, it's shown too often, etc.).
urlbar-feedback-acknowledgment = Faleminderit për përshtypjet tuaja
# A message shown in the urlbar when the user dismisses weather suggestions.
# Weather suggestions won't be shown at all anymore.
urlbar-dismissal-acknowledgment-weather = Faleminderit për përshtypjet. S’do të shihni më sugjerime moti.

## Prompts users to use the Urlbar when they open a new tab or visit the
## homepage of their default search engine.
## Variables:
##  $engineName (String): The name of the user's default search engine. e.g. "Google" or "DuckDuckGo".

urlbar-search-tips-onboard = Shtypni më pak, gjeni më shumë: Kërkoni me { $engineName } drejt e nga shtylla juaj e adresave.
urlbar-search-tips-redirect-2 = Filloni kërkimin tuaj te shtylla e adresave që të shihni sugjerime nga { $engineName } dhe nga historiku juaj i shfletimit.
# Make sure to match the name of the Search panel in settings.
urlbar-search-tips-persist = Kërkimi sapo u bë më i thjeshtë. Provoni ta bëni kërkimin tuaj më specifik, këtu te shtylla e adresave. Që të shfaqet URL, vizitoni Kërkim, te rregullimet.
# Prompts users to use the Urlbar when they are typing in the domain of a
# search engine, e.g. google.com or amazon.com.
urlbar-tabtosearch-onboard = Përzgjidhni këtë shkurtore, që të gjeni më shpejt ç’ju duhet.

## Local search mode indicator labels in the urlbar

urlbar-search-mode-bookmarks = Faqerojtës
urlbar-search-mode-tabs = Skeda
urlbar-search-mode-history = Historik
urlbar-search-mode-actions = Veprime

##

urlbar-geolocation-blocked =
    .tooltiptext = Ia keni bllokuar këtij sajti të dhënat mbi vendndodhjen tuaj.
urlbar-localhost-blocked =
    .tooltiptext = Keni bllokuar lidhje pajisjesh vendore për këtë sajt.
urlbar-local-network-blocked =
    .tooltiptext = Keni bllokuar lidhje rrjetesh vendorë për këtë sajt.
urlbar-xr-blocked =
    .tooltiptext = E keni bllokuar hyrjen në pajisje realiteti virtual për këtë sajt.
urlbar-web-notifications-blocked =
    .tooltiptext = Ia keni bllokuar këtij sajti njoftimet.
urlbar-camera-blocked =
    .tooltiptext = E keni bllokuar kamerën tuaj për këtë sajt.
urlbar-microphone-blocked =
    .tooltiptext = E keni bllokuar kamerën tuaj për këtë sajt.
urlbar-screen-blocked =
    .tooltiptext = Ia keni bllokuar këtij sajti përdorimin e ekranit tuaj.
urlbar-persistent-storage-blocked =
    .tooltiptext = E keni bllokuar depozitimin e qëndrueshëm për këtë sajt.
urlbar-popup-blocked2 =
    .tooltiptext = Keni bllokuar flluska dhe ridrejtime palësh të treta për këtë sajt.
urlbar-popup-blocked =
    .tooltiptext = I keni bllokuar flluskat për këtë sajt.
urlbar-autoplay-media-blocked =
    .tooltiptext = Keni bllokuar vetëluajtje mediash me tinguj për këtë sajt.
urlbar-canvas-blocked =
    .tooltiptext = Për këtë sajt e keni bllokuar përftimin e të dhënave të kanavacës.
urlbar-midi-blocked =
    .tooltiptext = E keni bllokuar hyrjen MIDI për këtë sajt.
urlbar-install-blocked =
    .tooltiptext = Ia keni bllokuar këtij sajti instalimin e shtesave.
# Variables
#   $shortcut (String) - A keyboard shortcut for the edit bookmark command.
urlbar-star-edit-bookmark =
    .tooltiptext = Përpunoni këtë faqerojtës ({ $shortcut })
# Variables
#   $shortcut (String) - A keyboard shortcut for the add bookmark command.
urlbar-star-add-bookmark =
    .tooltiptext = Faqeruani këtë faqe ({ $shortcut })

## Page Action Context Menu

page-action-manage-extension2 =
    .label = Administroni Zgjerime…
    .accesskey = A
page-action-remove-extension2 =
    .label = Hiqe Zgjerimin
    .accesskey = H

## Auto-hide Context Menu

full-screen-autohide =
    .label = Fshihi Panelet
    .accesskey = F
full-screen-exit =
    .label = Dilni nga Sa Krejt Ekrani
    .accesskey = D

## Search Engine selection buttons (one-offs)

# This string prompts the user to use the list of search shortcuts in
# the Urlbar and searchbar.
search-one-offs-with-title = Këtë herë kërko me:
search-one-offs-change-settings-compact-button =
    .tooltiptext = Ndryshoni rregullime kërkimi
search-one-offs-context-open-new-tab =
    .label = Kërkoni në Skedë të Re
    .accesskey = S
search-one-offs-context-set-as-default =
    .label = Caktojeni Si Motor Parazgjedhje Kërkimesh
    .accesskey = P
search-one-offs-context-set-as-default-private =
    .label = Vëre si Motor Kërkimi Parazgjedhje për Dritare Private
    .accesskey = V
# Search engine one-off buttons with an @alias shortcut/keyword.
# Variables:
#  $engineName (String): The name of the engine.
#  $alias (String): The @alias shortcut/keyword.
search-one-offs-engine-with-alias =
    .tooltiptext = { $engineName } ({ $alias })
# Shown when adding new engines from the address bar shortcut buttons or context
# menu, or from the search bar shortcut buttons.
# Variables:
#  $engineName (String): The name of the engine.
search-one-offs-add-engine =
    .label = Shtoni “{ $engineName }”
    .tooltiptext = Shtoni motorin e kërkimeve “{ $engineName }”
    .aria-label = Shtoni motorin e kërkimeve “{ $engineName }”
# When more than 5 engines are offered by a web page, they are grouped in a
# submenu using this as its label.
search-one-offs-add-engine-menu =
    .label = Shtoni motor kërkimesh

## Local search mode one-off buttons
## Variables:
##  $restrict (String): The restriction token corresponding to the search mode.
##    Restriction tokens are special characters users can type in the urlbar to
##    restrict their searches to certain sources (e.g., "*" to search only
##    bookmarks).

search-one-offs-bookmarks =
    .tooltiptext = Faqerojtës ({ $restrict })
search-one-offs-tabs =
    .tooltiptext = Skeda ({ $restrict })
search-one-offs-history =
    .tooltiptext = Historik ({ $restrict })
search-one-offs-actions =
    .tooltiptext = Veprime ({ $restrict })

## QuickActions are shown in the urlbar as the user types a matching string
## The -cmd- strings are comma separated list of keywords that will match
## the action.

# Opens the about:addons page in the home / recommendations section
quickactions-addons = Shihini Shtesa
# In English we provide multiple spellings for "add-ons". If that's not
# applicable to your language, only use the correct spelling (don't repeat the
# same word).
quickactions-cmd-addons3 = zgjerime, tema, shtesa
quickactions-cmd-addons2 = shtesa
# Opens the bookmarks library window
quickactions-bookmarks2 = Administroni faqerojtës
quickactions-cmd-bookmarks = faqerojtës
# Opens a SUMO article explaining how to clear history
quickactions-clearrecenthistory = Spastro historik së fundi
quickactions-cmd-clearrecenthistory = spastro historik së fundi, historik
# Opens a SUMO article explaining how to clear history
quickactions-clearhistory = Spastro Historikun
quickactions-cmd-clearhistory = spastroni historikun
# Opens about:downloads page
quickactions-downloads2 = Shihni shkarkime
quickactions-cmd-downloads = shkarkime
# Opens about:addons page in the extensions section
quickactions-extensions = Administroni zgjerime
quickactions-cmd-extensions2 = zgjerime, shtesa
quickactions-cmd-extensions = zgjerime
# Opens Firefox View
quickactions-firefoxview = Hap { -firefoxview-brand-name }
# English is using "view" and "open view", since the feature name is
# "Firefox View". If you have translated the name in your language, you
# should use a word related to the existing translation.
quickactions-cmd-firefoxview = hap { -firefoxview-brand-name }, { -firefoxview-brand-name }, hap pamje, pamje
# Opens SUMO home page
quickactions-help = Ndihmë { -brand-product-name }
quickactions-cmd-help = ndihmë, asistencë
# Opens the devtools web inspector
quickactions-inspector2 = Hap Mjete Zhvilluesish
quickactions-cmd-inspector2 = mbikëqyrë, mjete zhvilluesi
quickactions-cmd-inspector = mbikëqyrës, mjete zhvilluesish
# Opens about:logins
quickactions-logins2 = Administroni fjalëkalime
quickactions-cmd-logins = kredenciale hyrjesh, fjalëkalime
# Opens about:addons page in the plugins section
quickactions-plugins = Administroni shtojca
quickactions-cmd-plugins = shtojca
# Opens the print dialog
quickactions-print2 = Shtypni faqe
quickactions-cmd-print = shtype
# Opens the print dialog at the save to PDF option
quickactions-savepdf = Ruaje faqen si PDF
quickactions-cmd-savepdf2 = pdf, ruaje faqen
# Opens a new private browsing window
quickactions-private2 = Hap dritare private
quickactions-cmd-private = shfletim privat
# Opens a SUMO article explaining how to refresh
quickactions-refresh = Rifreskoni { -brand-short-name }-in
quickactions-cmd-refresh = rifreskoje
# Restarts the browser
quickactions-restart = Riniseni { -brand-short-name }-in
quickactions-cmd-restart = rinise
# Opens the screenshot tool
quickactions-screenshot3 = Bëni një foto ekrani
quickactions-cmd-screenshot2 = foto ekrani, bëni një foto ekrani
quickactions-cmd-screenshot = foto ekrani
# Opens about:preferences
quickactions-settings2 = Administroni rregullime
# "manage" should match the corresponding command, which is “Manage settings” in English.
quickactions-cmd-settings2 = rregullime, parapëlqime, mundësi, administroni
quickactions-cmd-settings = rregullime, parapëlqime, mundësi
# Opens about:addons page in the themes section
quickactions-themes = Administroni tema
# In English we provide multiple spellings for "add-ons". If that's not
# applicable to your language, only use the correct spelling (don't repeat the
# same word).
quickactions-cmd-themes2 = temsa, shtesa
quickactions-cmd-themes = tema
# Opens a SUMO article explaining how to update the browser
quickactions-update = Përditësoni { -brand-short-name }
quickactions-cmd-update = përditësoje
# Opens the view-source UI with current pages source
quickactions-viewsource2 = Shihni Burim Faqeje
quickactions-cmd-viewsource2 = shihini burimin, burim, burim faqeje
quickactions-cmd-viewsource = shihni burimin, burim
# Tooltip text for the help button shown in the result.
quickactions-learn-more =
    .title = Mësoni më tepër rreth Veprimesh të shpejta
# Will be shown to users the first configurable number of times
# they experience actions giving them instructions on how to
# select the action shown by pressing the tab key.
press-tab-label = Shtypni tastin tab, që të përzgjidhet:

## Bookmark Panel

bookmarks-add-bookmark = Shto faqerojtës
bookmarks-edit-bookmark = Përpunoni faqerojtësin
bookmark-panel-cancel =
    .label = Anuloje
    .accesskey = A
# Variables:
#  $count (number): number of bookmarks that will be removed
bookmark-panel-remove =
    .label =
        { $count ->
            [one] Hiqe Faqerojtësin
           *[other] Hiqi Faqerojtësit ({ $count })
        }
    .accesskey = H
bookmark-panel-show-editor-checkbox =
    .label = Shfaqe përpunuesin, kur bëhen ruajtje
    .accesskey = S
bookmark-panel-save-button =
    .label = Ruaje
# Width of the bookmark panel.
# Should be large enough to fully display the Done and
# Cancel/Remove Bookmark buttons.
bookmark-panel =
    .style = min-width: 23em

## Identity Panel

# Variables
#  $host (String): the hostname of the site that is being displayed.
identity-site-information = Hollësi sajti për { $host }
# Variables
#  $host (String): the hostname of the site that is being displayed.
identity-header-security-with-host =
    .title = Siguri Lidhjeje për { $host }
identity-connection-not-secure = Lidhje jo e siguruar
identity-connection-secure = Lidhje e siguruar
identity-connection-failure = Dështim lidhjeje
identity-connection-internal = Kjo është një faqe { -brand-short-name } e siguruar.
identity-connection-file = Kjo është faqe e depozituar në kompjuterin tuaj.
identity-connection-associated = Kjo faqe është ngarkuar nga një tjetër faqe.
identity-extension-page = Kjo faqe është ngarkuar nga një zgjerim.
identity-active-blocked = { -brand-short-name }-i ka bllokuar pjesë të kësaj faqeje që s'janë të siguruara.
identity-custom-root = Lidhje e verifikuar nga një lëshues dëshmish që s’njihet nga Mozilla.
identity-passive-loaded = Pjesë të kësaj faqeje (fjala vjen, figura) s'janë të siguruara.
identity-active-loaded = E keni çaktivizuar mbrojtjen për këtë faqe.
identity-weak-encryption = Kjo faqe përdor fshehtëzim të dobët.
identity-insecure-login-forms = Kredencialet e hyrjeve të dhëna në këtë faqe mund të komprometohen.
identity-https-only-connection-upgraded = (u përmirësua në HTTPS)
identity-https-only-label = Mënyra Vetëm-HTTPS
identity-https-only-label2 = Përmirësoje automatikisht këtë sajt me një lidhje të siguruar
identity-https-only-dropdown-on =
    .label = On
identity-https-only-dropdown-off =
    .label = Off
identity-https-only-dropdown-off-temporarily =
    .label = Off përkohësisht
identity-https-only-info-turn-on2 = Aktivizoni Mënyrën Vetëm-HTTPS për këtë sajt, nëse doni që { -brand-short-name }-i të përmirësojë lidhjen, kur është e mundur.
identity-https-only-info-turn-off2 = Nëse faqja duket të jetë e dëmtuar, mund të doni të çaktivizoni Mënyrën Vetëm-HTTPS- për këtë sajt, që të ringarkohet duke përdorur HTTP jo të siguruar.
identity-https-only-info-turn-on3 = Nëse doni që { -brand-short-name }-i të përmirësojë lidhjen, kur kjo është e mundur, aktivizoni përmirësime HTTPS për këtë sajt.
identity-https-only-info-turn-off3 = Nëse faqja duket e dëmtuar, mund të doni të çaktivizoni përmirësime  HTTPS për këtë sajt, që të ngarkohet duke përdorur HTTP jo të siguruar.
identity-https-only-info-no-upgrade = S’arrihet të përmirësohet lidhja nga HTTP.
identity-permissions-storage-access-header = “Cookies” palësh të treta
identity-permissions-storage-access-hint = Këto palë mund të përdorin “cookies” palësh të treta të dhëna sajtesh, ndërkohë që jeni në këtë sajt.
identity-permissions-storage-access-learn-more = Mësoni më tepër
identity-permissions-reload-hint = Mund t'ju duhet të ringarkoni faqen që të hyjnë në fuqi ndryshimet.
identity-clear-site-data =
    .label = Spastroni Cookie-t dhe të Dhëna Sajti…
identity-connection-not-secure-security-view = S'jeni lidhur në mënyrë të siguruar me këtë sajt.
identity-connection-verified = Jeni lidhur në mënyrë të siguruar me këtë sajt.
identity-ev-owner-label = Dëshmi lëshuar për:
identity-description-custom-root2 = Mozilla nuk e njeh këtë lëshues dëshmish. Mund të jetë shtuar nga sistemi juaj operativ ose nga një përgjegjës.
identity-remove-cert-exception =
    .label = Hiqeni Përjashtimin
    .accesskey = H
identity-description-insecure = Lidhja juaj te ky sajt, s'është private. Hollësitë që parashtroni (fjala vjen, fjalëkalime, mesazhe, karta krediti, etj.) mund të shihen nga të tjerë.
identity-description-insecure-login-forms = Hollësitë për hyrje që dhatë në këtë faqe s'janë të siguruara dhe mund të komprometohen.
identity-description-weak-cipher-intro = Lidhja juaj te ky sajt përdor fshehtëzim të dobët dhe s'është private.
identity-description-weak-cipher-risk = Të tjerët mund të shohin të dhënat tuaja ose të ndryshojnë sjelljen e sajtit.
identity-description-active-blocked2 = { -brand-short-name }-i ka bllokuar pjesë të kësaj faqeje që s'janë të siguruara.
identity-description-passive-loaded = Lidhja juaj s'është private dhe të dhënat që ndani me të tjerët në këtë saj mund të shihen nga të tjerë.
identity-description-passive-loaded-insecure2 = Ky sajt përmban lëndë që s'është e siguruar (fjala vjen, figura).
identity-description-passive-loaded-mixed2 = Edhe pse { -brand-short-name }-i ka bllokuar një pjesë të lëndës, në këtë faqe prapë ka lëndë që s'është e siguruar (fjala vjen, figura).
identity-description-active-loaded = Ky sajt përmban lëndë që s'është e siguruar (fjala vjen, programthe) dhe lidhja juaj me të s'është private.
identity-description-active-loaded-insecure = Të dhënat që ndani me këtë sajt mund të shihen nga të tjerë (fjala vjen, fjalëkalime, mesazhe, karta krediti, etj.).
identity-disable-mixed-content-blocking =
    .label = Çaktivizoje mbrojtjen për tani
    .accesskey = Ç
identity-enable-mixed-content-blocking =
    .label = Aktivizo mbrojtjen
    .accesskey = A
identity-more-info-link-text =
    .label = Më tepër hollësi

## Window controls

browser-window-minimize-button =
    .tooltiptext = Minimizojeni
browser-window-maximize-button =
    .tooltiptext = Maksimizoje
browser-window-restore-down-button =
    .tooltiptext = Riktheje Poshtë
browser-window-close-button =
    .tooltiptext = Mbylleni

## Tab actions

# This label should be written in all capital letters if your locale supports them.
browser-tab-audio-playing2 = PO LUHET
# This label should be written in all capital letters if your locale supports them.
browser-tab-audio-muted2 = HESHTUAR
# This label should be written in all capital letters if your locale supports them.
browser-tab-audio-blocked = VETËLUAJTJA E BLLOKUAR
# This label should be written in all capital letters if your locale supports them.
browser-tab-audio-pip = PICTURE-IN-PICTURE

## These labels should be written in all capital letters if your locale supports them.
## Variables:
##  $count (number): number of affected tabs

browser-tab-mute =
    { $count ->
        [1] HESHTOJE SKEDËN
       *[other] HESHTO { $count } SKEDA
    }
browser-tab-unmute =
    { $count ->
        [1] KTHEJI ZËRIN SKEDËS
       *[other] KTHEJU ZËRIN { $count } SKEDAVE
    }
browser-tab-unblock =
    { $count ->
        [1] LUAJE SKEDËN
       *[other] LUAJ { $count } SKEDA
    }

## Bookmarks toolbar items

browser-import-button2 =
    .label = Importoni faqerojtës…
    .tooltiptext = Importoni faqerojtës nga një shfletues tjetër në { -brand-short-name }
bookmarks-toolbar-empty-message = Për përdorim të shpejtë, vendosini faqerojtësit këtu te paneli i faqerojtësve. <a data-l10n-name="manage-bookmarks">Administroni faqerojtës…</a>

## WebRTC Pop-up notifications

popup-select-camera-device =
    .value = Kamerë:
    .accesskey = K
popup-select-camera-icon =
    .tooltiptext = Kamerë
popup-select-microphone-device =
    .value = Mikrofon:
    .accesskey = M
popup-select-microphone-icon =
    .tooltiptext = Mikrofon
popup-select-speaker-icon =
    .tooltiptext = Altoparlantë
popup-select-window-or-screen =
    .label = Dritare ose skenë:
    .accesskey = D
popup-all-windows-shared = Do të ndahen me të tjerët krejt dritaret e dukshme në ekranin tuaj.

## WebRTC window or screen share tab switch warning

sharing-warning-window = Jeni duke ndarë { -brand-short-name }-in me të tjerë. Persona të tjerë mund ta shohin, kur kaloni te një skedë e re.
sharing-warning-screen = Po ndani me të tjerë krejt ekranin. Persona të tjerë mund ta shohin, kur kaloni te një skedë e re.
sharing-warning-proceed-to-tab =
    .label = Kalo te Skeda
sharing-warning-disable-for-session =
    .label = Çaktivizo mbrojtje ndarjeje për këtë sesion

## DevTools F12 popup

enable-devtools-popup-description2 = Që të përdorni shkurtoren F12, së pari hapni DevTools që nga menuja Mjete Shfletuesi.

## URL Bar

# This string is used as an accessible name to the "X" button that cancels a custom search mode (i.e. exits the Amazon.com search mode).
urlbar-search-mode-indicator-close =
    .aria-label = Mbylleni
# This placeholder is used when not in search mode and the user's default search
# engine is unknown.
urlbar-placeholder =
    .placeholder = Bëni kërkim, ose jepni adresë
# This placeholder is used when not in search mode and searching in the urlbar
# is disabled via the keyword.enabled pref.
urlbar-placeholder-keyword-disabled =
    .placeholder = Jepni adresë
# This placeholder is used in search mode with search engines that search the
# entire web.
# Variables
#  $name (String): the name of a search engine that searches the entire Web
#  (e.g. Google).
urlbar-placeholder-search-mode-web-2 =
    .placeholder = Kërkoni në Web
    .aria-label = Kërkoni me { $name }
# This placeholder is used in search mode with search engines that search a
# specific site (e.g., Amazon).
# Variables
#  $name (String): the name of a search engine that searches a specific site
#  (e.g. Amazon).
urlbar-placeholder-search-mode-other-engine =
    .placeholder = Jepni terma kërkimi
    .aria-label = Kërkoni me { $name }
# This placeholder is used when searching bookmarks.
urlbar-placeholder-search-mode-other-bookmarks =
    .placeholder = Jepni terma kërkimi
    .aria-label = Kërko te faqerojtësit
# This placeholder is used when searching history.
urlbar-placeholder-search-mode-other-history =
    .placeholder = Jepni terma kërkimi
    .aria-label = Kërko në historik
# This placeholder is used when searching open tabs.
urlbar-placeholder-search-mode-other-tabs =
    .placeholder = Jepni terma kërkimi
    .aria-label = Kërko në skeda
# This placeholder is used when searching quick actions.
urlbar-placeholder-search-mode-other-actions =
    .placeholder = Jepni terma kërkimi
    .aria-label = Veprime kërkimi
# Variables
#  $name (String): the name of the user's default search engine
urlbar-placeholder-with-name =
    .placeholder = Kërkoni me { $name } ose jepni adresë
# Variables
#  $component (String): the name of the component which forces remote control.
#    Example: "DevTools", "Marionette", "RemoteAgent".
urlbar-remote-control-notification-anchor2 =
    .tooltiptext = Shfletuesi gjendet nën kontroll së largëti (arsye: { $component })
urlbar-permissions-granted =
    .tooltiptext = I keni akorduar leje shtesë këtij sajti.
urlbar-switch-to-tab =
    .value = Kalo te skeda:
# Used to indicate that a selected autocomplete entry is provided by an extension.
urlbar-extension =
    .value = Zgjerim:
urlbar-go-button =
    .tooltiptext = Shkoni te adresa e dhënë te Shtylla e Vendndodhjeve
urlbar-page-action-button =
    .tooltiptext = Veprime faqeje
urlbar-revert-button =
    .tooltiptext = Shfaqe adresën te Shtylla e Vendndodhjeve

## Action text shown in urlbar results, usually appended after the search
## string or the url, like "result value - action text".

# Used when the private browsing engine differs from the default engine.
# The "with" format was chosen because the search engine name can end with
# "Search", and we would like to avoid strings like "Search MSN Search".
# Variables
#  $engine (String): the name of a search engine
urlbar-result-action-search-in-private-w-engine = Kërko me { $engine } në një Dritare Private
# Used when the private browsing engine is the same as the default engine.
urlbar-result-action-search-in-private = Kërko në Dritare Private
# The "with" format was chosen because the search engine name can end with
# "Search", and we would like to avoid strings like "Search MSN Search".
# Variables
#  $engine (String): the name of a search engine
urlbar-result-action-search-w-engine = Kërko me { $engine }
urlbar-result-action-sponsored = E sponsorizuar
urlbar-result-action-switch-tab = Kalo te Skeda
urlbar-result-action-visit = Vizitojeni
# "Switch to tab with container" is used when the target tab is located in a
# different container.
# Variables
# $container (String): the name of the target container
urlbar-result-action-switch-tab-with-container = Kaloni te Skeda · <span>{ $container }</span>
# Used when the target tab is in a tab group that doesn't have a label.
urlbar-result-action-tab-group-unnamed = Grup i paemër
# Allows the user to visit a URL that was previously copied to the clipboard.
urlbar-result-action-visit-from-clipboard = Vizitojeni që nga e papastra
# Directs a user to press the Tab key to perform a search with the specified
# engine.
# Variables
#  $engine (String): the name of a search engine that searches the entire Web
#  (e.g. Google).
urlbar-result-action-before-tabtosearch-web = Shtypni tastin Tab që të kërkohet me { $engine }
# Directs a user to press the Tab key to perform a search with the specified
# engine.
# Variables
#  $engine (String): the name of a search engine that searches a specific site
#  (e.g. Amazon).
urlbar-result-action-before-tabtosearch-other = Shtypni tastin Tab që të kërkohet me { $engine }
# Variables
#  $engine (String): the name of a search engine that searches the entire Web
#  (e.g. Google).
urlbar-result-action-tabtosearch-web = Kërkoni me { $engine } drejt e nga shtylla e adresave
# Variables
#  $engine (String): the name of a search engine that searches a specific site
#  (e.g. Amazon).
urlbar-result-action-tabtosearch-other-engine = Kërkoni me { $engine } drejt e nga shtylla e adresave
# Action text for copying to clipboard.
urlbar-result-action-copy-to-clipboard = Kopjoje
# Shows the result of a formula expression being calculated, the last = sign will be shown
# as part of the result (e.g. "= 2").
# Variables
#  $result (String): the string representation for a formula result
urlbar-result-action-calculator-result = = { $result }
# The string returned for an undefined calculator result such as when dividing by 0
urlbar-result-action-undefined-calculator-result = e papërcaktuar
# Shows the result of a formula expression being calculated, in scientific notation.
# The last = sign will be shown as part of the result (e.g. "= 1.0e17").
# Variables
#  $result (String): the string representation for a result in scientific notation
#  (e.g. "1.0e17").
urlbar-result-action-calculator-result-scientific-notation = = { $result }
# Shows the result of a formula expression being calculated, this is used for numbers >= 1.
# The last = sign will be shown as part of the result (e.g. "= 2").
# Variables
#  $result (String): the string representation for a formula result
urlbar-result-action-calculator-result-3 = = { NUMBER($result, useGrouping: "false", maximumFractionDigits: 8) }
# Shows the result of a formula expression being calculated, to a maximum of 9 significant
# digits. This is used for numbers < 1.
# The last = sign will be shown as part of the result (e.g. "= 0.333333333").
# Variables
#  $result (String): the string representation for a formula result
urlbar-result-action-calculator-result-decimal = = { NUMBER($result, maximumSignificantDigits: 9) }
# The title of a weather suggestion in the urlbar. The temperature and unit
# substring should be inside a <strong> tag. If the temperature and unit are not
# adjacent in the localization, it's OK to include only the temperature in the
# tag.
# Variables:
#   $temperature (number) - The temperature value
#   $unit (String) - The unit for the temperature, either "C" or "F"
#   $city (String) - The name of the city the weather data is for
#   $region (String) - The name of the city's region or country. Depending on
#       the user's location in relation to the city, this may be the name or
#       abbreviation of one of the city's administrative divisions like a
#       province or state, or it may be the name of the city's country.
urlbar-result-weather-title = <strong>{ $temperature }°{ $unit }</strong> në { $city }, { $region }
# The title of a weather suggestion in the urlbar including a region and
# country. The temperature and unit substring should be inside a <strong> tag.
# If the temperature and unit are not adjacent in the localization, it's OK to
# include only the temperature in the tag.
# Variables:
#   $temperature (number) - The temperature value
#   $unit (String) - The unit for the temperature, either "C" or "F"
#   $city (String) - The name of the city the weather data is for
#   $region (String) - The name or abbreviation of one of the city's
#       administrative divisions like a province or state.
#   $country (String) - The name of the city's country.
urlbar-result-weather-title-with-country = <strong>{ $temperature }°{ $unit }</strong> në { $city }, { $region }, { $country }
# The title of a weather suggestion in the urlbar only including the city. The
# temperature and unit substring should be inside a <strong> tag. If the
# temperature and unit are not adjacent in the localization, it's OK to include
# only the temperature in the tag.
# Variables:
#   $temperature (number) - The temperature value
#   $unit (String) - The unit for the temperature, either "C" or "F"
#   $city (String) - The name of the city the weather data is for
urlbar-result-weather-title-city-only = <strong>{ $temperature }°{ $unit }</strong> në { $city }
# Shows the name of the provider of weather data in a weather suggestion in the
# urlbar.
# Variables:
#   $provider (String) - The name of the weather-data provider. It will be the
#       name of a company, organization, or service.
urlbar-result-weather-provider-sponsored = { $provider } ·E sponsorizuar

## These strings are used for Realtime suggestions in the urlbar.
## Market refers to stocks, indexes, and funds.

# This string is shown as title when Market suggestion are disabled.
urlbar-result-market-opt-in-title = Merrni të dhëna tregu aksionesh drejt e te shtylla juaj e kërkimeve
# This string is shown as description when Market suggestion are disabled.
urlbar-result-market-opt-in-description = Shfaq përditësime tregjesh, etj, nga partnerët tanë, kur ndani me { -vendor-short-name } të dhëna termash kërkimi. <a data-l10n-name="learn-more-link">Mësoni më tepër</a>
# This string is shown as button to activate online when realtime suggestion are disabled.
urlbar-result-realtime-opt-in-allow = Shfaq sugjerime
# This string is shown in split button to dismiss activation the Realtime suggestion.
urlbar-result-realtime-opt-in-not-now = Jo tani
urlbar-result-realtime-opt-in-dismiss = Hidhe tej
urlbar-result-realtime-opt-in-dismiss-all =
    .label = Mos i shfaq këto sugjerime
# This string is shown in the result menu.
urlbar-result-menu-dont-show-market =
    .label = Mos shfaq sugjerime tregu
# A message that replaces a result when the user dismisses Market suggestions.
urlbar-result-dismissal-acknowledgment-market = Faleminderit për përshtypjet. S’do të shihni më sugjerime tregu.
# A message that replaces a result when the user dismisses all suggestions of a
# particular type.
urlbar-result-dismissal-acknowledgment-all = Faleminderit për përshtypjet. S’do të shihni më këto sugjerime.

## These strings are used for suggestions of important dates in the urlbar.

# The name of an event and the number of days until it starts separated by a
# middot.
# Variables:
#   $name (string) - The name of the event.
#   $daysUntilStart (integer) - The number of days until the event starts.
urlbar-result-dates-countdown =
    { $daysUntilStart ->
        [one] { $name } · në { $daysUntilStart } ditë
       *[other] { $name } · në { $daysUntilStart } ditë
    }
# The name of a multiple day long event and the number of days until it starts
# separated by a middot.
# Variables:
#   $name (string) - The name of the event.
#   $daysUntilStart (integer) - The number of days until the event starts.
urlbar-result-dates-countdown-range =
    { $daysUntilStart ->
        [one] { $name } · Fillon për  { $daysUntilStart } ditë
       *[other] { $name } · Fillon për { $daysUntilStart } ditë
    }
# The name of a multiple day long event and the number of days until it ends
# separated by a middot.
# Variables:
#   $name (string) - The name of the event.
#   $daysUntilEnd (integer) - The number of days until the event ends.
urlbar-result-dates-ongoing =
    { $daysUntilEnd ->
        [one] { $name } · Përfundon pas { $daysUntilEnd } dite
       *[other] { $name } · Përfundon pas { $daysUntilEnd } ditësh
    }
# The name of an event and a note that it is happening today separated by a
# middot.
# Variables:
#   $name (string) - The name of the event.
urlbar-result-dates-today = { $name } · Sot
# The name of multiple day long event and a note that it is ends today
# separated by a middot.
# Variables:
#   $name (string) - The name of the event.
urlbar-result-dates-ends-today = { $name } · Përfundon sot

## Strings used for buttons in the urlbar

# Label prompting user to search with a particular search engine.
#  $engine (String): the name of a search engine that searches a specific site
urlbar-result-search-with = Kërko me { $engine }
# Label for the urlbar result row, prompting the user to use a local keyword to enter search mode.
#  $keywords (String): the restrict keyword to enter search mode.
#  $localSearchMode (String): the local search mode (history, tabs, bookmarks,
#  or actions) to search with.
urlbar-result-search-with-local-search-mode = { $keywords } - Kërkoni me { $localSearchMode }
# Label for the urlbar result row, prompting the user to use engine keywords to enter search mode.
#  $keywords (String): the default keyword and user's set keyword if available
#  $engine (String): the name of a search engine
urlbar-result-search-with-engine-keywords = { $keywords } - Kërkoni me { $engine }
urlbar-searchmode-dropmarker =
    .tooltiptext = Zgjidhni një Motor Kërkimesh
urlbar-searchmode-bookmarks =
    .label = Faqerojtës
urlbar-searchmode-tabs =
    .label = Skeda
urlbar-searchmode-history =
    .label = Historik
urlbar-searchmode-actions =
    .label = Veprime
urlbar-searchmode-exit-button =
    .tooltiptext = Mbylle
urlbar-searchmode-default =
    .tooltiptext = Motor parazgjedhje kërkimesh
# Label shown on the top of Searchmode Switcher popup. After this label, the
# available search engines will be listed.
urlbar-searchmode-popup-description = Këtë herë kërko me:
urlbar-searchmode-popup-search-settings-menuitem =
    .label = Parametra Kërkimi
# Label shown next to a new search engine in the Searchmode Switcher popup to promote it.
urlbar-searchmode-new = I ri
# Searchmode Switcher button
# Variables:
#   $engine (String): the current default search engine.
urlbar-searchmode-button2 =
    .label = { $engine }, zgjidhni një motor kërkimesh
    .tooltiptext = { $engine }, zgjidhni një motor kërkimesh
urlbar-searchmode-button-no-engine =
    .label = S’u përzgjodh shkurtore, zgjidhni një shkurtore
    .tooltiptext = S’u përzgjodh shkurtore, zgjidhni një shkurtore

## Action text shown in urlbar results, usually appended after the search
## string or the url, like "result value - action text".
## In these actions "Search" is a verb, followed by where the search is performed.

urlbar-result-action-search-bookmarks = Kërkoni Te Faqerojtësit
urlbar-result-action-search-history = Kërkoni Në Historik
urlbar-result-action-search-tabs = Kërkoni Në Skeda
urlbar-result-action-search-actions = Veprime Kërkimi
# Label for a quickaction result used to switch to an open tab group.
#  $group (String): the name of the tab group to switch to
urlbar-result-action-switch-to-tabgroup = Kalo te { $group }
# Label for a quickaction result used to re-opan a saved tab group.
#  $group (String): the name of the tab group to re-open
urlbar-result-action-open-saved-tabgroup = Hap { $group }

## Labels shown above groups of urlbar results

# A label shown above the "Firefox Suggest" (bookmarks/history) group in the
# urlbar results.
urlbar-group-firefox-suggest =
    .label = { -firefox-suggest-brand-name }
# A label shown above the search suggestions group in the urlbar results. It
# should use sentence case.
# Variables
#  $engine (String): the name of the search engine providing the suggestions
urlbar-group-search-suggestions =
    .label = Sugjerime nga { $engine }
# A label shown above Quick Actions in the urlbar results.
urlbar-group-quickactions =
    .label = Veprime të Shpejta
# A label shown above the recent searches group in the urlbar results.
# Variables
#  $engine (String): the name of the search engine used to search.
urlbar-group-recent-searches =
    .label = Kërkime Së Fundi
# The header shown above trending results.
# Variables:
#  $engine (String): the name of the search engine providing the trending suggestions
urlbar-group-trending =
    .label = Prirje te { $engine }
# Label shown above sponsored suggestions in the urlbar results.
urlbar-group-sponsored =
    .label = Të sponsorizuar
# The result menu labels shown next to trending results.
urlbar-result-menu-trending-dont-show =
    .label = Mos shfaq prirje kërkimesh
    .accesskey = M
urlbar-result-menu-trending-why =
    .label = Pse më del kjo?
    .accesskey = P
# A message that replaces a result when the user dismisses all suggestions of a
# particular type.
urlbar-trending-dismissal-acknowledgment = Faleminderit për përshtypjet. S’do të shihni më prirje kërkimi.

## Reader View toolbar buttons

# This should match menu-view-enter-readerview in menubar.ftl
reader-view-enter-button =
    .aria-label = Kalo në Pamjen Lexues
# This should match menu-view-close-readerview in menubar.ftl
reader-view-close-button =
    .aria-label = Mbylle Pamjen Lexues

## Picture-in-Picture urlbar button
## Variables:
##   $shortcut (String) - Keyboard shortcut to execute the command.

picture-in-picture-urlbar-button-open =
    .tooltiptext = Hap Picture-in-Picture ({ $shortcut })
picture-in-picture-urlbar-button-close =
    .tooltiptext = Mbylle Picture-in-Picture ({ $shortcut })
picture-in-picture-panel-header = Picture-in-Picture
picture-in-picture-panel-headline = Ky sajt nuk rekomandon përdorim të “Picture-in-Picture”
picture-in-picture-panel-body = Videot mund të mos shfaqen, ngaqë zhvilluesi i pat menduar me Picture-in-Picture të aktivizuar.
picture-in-picture-enable-toggle =
    .label = Aktivizoje, sido qoftë

## Full Screen and Pointer Lock UI

# Please ensure that the domain stays in the `<span data-l10n-name="domain">` markup.
# Variables
#  $domain (String): the domain that is full screen, e.g. "mozilla.org"
fullscreen-warning-domain = <span data-l10n-name="domain">{ $domain }</span> tani është sa krejt ekrani
fullscreen-warning-no-domain = Ky dokument tani shfaqet sa krejt ekrani
fullscreen-exit-button = Dilni nga Sa Krejt Ekrani (Esc)
# "esc" is lowercase on mac keyboards, but uppercase elsewhere.
fullscreen-exit-mac-button = Dilni Nga Sa Krejt Ekrani (esc)
# Please ensure that the domain stays in the `<span data-l10n-name="domain">` markup.
# Variables
#  $domain (String): the domain that is using pointer-lock, e.g. "mozilla.org"
pointerlock-warning-domain = <span data-l10n-name="domain">{ $domain }</span> është në kontroll të kursorit tuaj. Shtypni Esc që të rimerrni kontrollin.
pointerlock-warning-no-domain = Kursori është nën kontrollin e kursorit tuaj. Shtypni Esc që të rimerrni kontrollin.

## Bookmarks panels, menus and toolbar

bookmarks-manage-bookmarks =
    .label = Administroni faqerojtës
bookmarks-recent-bookmarks-panel-subheader = Faqerojtës Së Fundi
bookmarks-toolbar-chevron =
    .tooltiptext = Shfaqni më tepër faqerojtës
bookmarks-sidebar-content =
    .aria-label = Faqerojtës
bookmarks-menu-button =
    .label = Menu Faqerojtësish
bookmarks-other-bookmarks-menu =
    .label = Faqerojtës të Tjerë
bookmarks-mobile-bookmarks-menu =
    .label = Faqerojtës Celulari

## Variables:
##   $isVisible (boolean): if the specific element (e.g. bookmarks sidebar,
##                         bookmarks toolbar, etc.) is visible or not.

bookmarks-tools-sidebar-visibility =
    .label =
        { $isVisible ->
            [true] Fshihe Anështyllën e Faqerojtësve
           *[other] Shihni Anështyllë Faqerojtësish
        }
bookmarks-tools-toolbar-visibility-menuitem =
    .label =
        { $isVisible ->
            [true] Fshihe Panelin e Faqerojtësve
           *[other] Shihni Panel Faqerojtësish
        }
bookmarks-tools-toolbar-visibility-panel =
    .label =
        { $isVisible ->
            [true] Fshih Panel Faqerojtësish
           *[other] Shfaq Panel Faqerojtësish
        }
bookmarks-tools-menu-button-visibility =
    .label =
        { $isVisible ->
            [true] Hiqe Menunë e Faqerojtësve nga Paneli
           *[other] Shtoje Menunë e Faqerojtësve te Paneli
        }

##

bookmarks-search =
    .label = Kërkoni Te Faqerojtësit
bookmarks-tools =
    .label = Mjete Faqeruajtjeje
bookmarks-subview-edit-bookmark =
    .label = Përpunojeni këtë faqerojtës…
# The aria-label is a spoken label that should not include the word "toolbar" or
# such, because screen readers already know that this container is a toolbar.
# This avoids double-speaking.
bookmarks-toolbar =
    .toolbarname = Panel Faqerojtësish
    .accesskey = F
    .aria-label = Faqerojtës
bookmarks-toolbar-menu =
    .label = Panel Faqerojtësish
bookmarks-toolbar-placeholder =
    .title = Objekte Paneli Faqerojtësish
bookmarks-toolbar-placeholder-button =
    .label = Objekte Paneli Faqerojtësish
# "Bookmark" is a verb, as in "Add current tab to bookmarks".
bookmarks-subview-bookmark-tab =
    .label = Faqeruani skedën e tanishme…

## Library Panel items

library-bookmarks-menu =
    .label = Faqerojtës
library-recent-activity-title =
    .value = Veprimtari Së fundi

## Pocket toolbar button

save-to-pocket-button =
    .label = Ruajeni te { -pocket-brand-name }
    .tooltiptext = Ruajeni te { -pocket-brand-name }

## Repair text encoding toolbar button

repair-text-encoding-button =
    .label = Riparo kodim teksti
    .tooltiptext = Hamendësoje kodimin e saktë të tekstit që nga lënda e faqes

## Customize Toolbar Buttons

# Variables:
#  $shortcut (String): keyboard shortcut to open settings (only on macOS)
toolbar-settings-button =
    .label = Rregullime
    .tooltiptext =
        { PLATFORM() ->
            [macos] Hapni rregullimet ({ $shortcut })
           *[other] Hapni rregullimet
        }
toolbar-overflow-customize-button =
    .label = Përshtateni Panelin…
    .accesskey = P
toolbar-button-email-link =
    .label = Dërgojeni Lidhjen me Email
    .tooltiptext = Dërgoni me email një lidhje për te kjo faqe
toolbar-button-logins =
    .label = Fjalëkalime
    .tooltiptext = Shihni dhe administroni fjalëkalimet tuaj të ruajtur
# Variables:
#  $shortcut (String): keyboard shortcut to save a copy of the page
toolbar-button-save-page =
    .label = Ruaje Faqen
    .tooltiptext = Ruajeni këtë faqe ({ $shortcut })
# Variables:
#  $shortcut (String): keyboard shortcut to open a local file
toolbar-button-open-file =
    .label = Hap Kartelë
    .tooltiptext = Hapni kartelë ({ $shortcut })
toolbar-button-synced-tabs =
    .label = Skeda të Njëkohësuara
    .tooltiptext = Shfaqni skeda nga pajisje të tjera
# Variables
# $shortcut (string) - Keyboard shortcut to open a new private browsing window
toolbar-button-new-private-window =
    .label = Dritare e re private
    .tooltiptext = Hapni një dritare të re shfletimi privat ({ $shortcut })

## EME notification panel

eme-notifications-drm-content-playing = Audio ose video në këtë sajt përdor software DRM, çka mund të kufizojë ato që { -brand-short-name }-i mund t’ju lejojë të bëni me të.
eme-notifications-drm-content-playing-manage = Administroni rregullime
eme-notifications-drm-content-playing-manage-accesskey = A
eme-notifications-drm-content-playing-dismiss = Hidhe tej
eme-notifications-drm-content-playing-dismiss-accesskey = H

## Password save/update panel

panel-save-update-username = Emër përdoruesi
panel-save-update-password = Fjalëkalim

##

# "More" item in macOS share menu
menu-share-more =
    .label = Më tepër…
menu-share-copy-link =
    .label = Kopjoji Lidhjen
    .accesskey = L
ui-tour-info-panel-close =
    .tooltiptext = Mbylleni

## Variables:
##  $uriHost (String): URI host for which the popup was allowed or blocked.

popups-infobar-allow =
    .label = Lejo flluska nga { $uriHost }
    .accesskey = L
popups-infobar-block =
    .label = Blloko flluska nga { $uriHost }
    .accesskey = L
popups-infobar-allow2 =
    .label = Lejo flluska dhe ridrejtime palësh të treta për { $uriHost }
    .accesskey = L

##

popups-infobar-dont-show-message =
    .label = Mos e shfaq këtë mesazh kur bllokohen flluska
    .accesskey = M
edit-popup-settings =
    .label = Administroni rregullime për flluskat…
    .accesskey = A
picture-in-picture-hide-toggle =
    .label = Fshih Buton Picture-in-Picture
    .accesskey = F

## Since the default position for PiP controls does not change for RTL layout,
## right-to-left languages should use "Left" and "Right" as in the English strings,

picture-in-picture-move-toggle-right =
    .label = Kaloje Butonin për “Picture-in-Picture” në të Djathtë Toggle to Right Side
    .accesskey = D
picture-in-picture-move-toggle-left =
    .label = Kaloje Butonin për “Picture-in-Picture” në të Majtë
    .accesskey = M

##


# Navigator Toolbox

# This string is a spoken label that should not include
# the word "toolbar" or such, because screen readers already know that
# this container is a toolbar. This avoids double-speaking.
navbar-accessible =
    .aria-label = Lëvizje
navbar-downloads =
    .label = Shkarkime
navbar-overflow-2 =
    .tooltiptext = Më tepër mjete
navbar-overflow =
    .tooltiptext = Më tepër mjete…
# Variables:
#   $shortcut (String): keyboard shortcut to print the page
navbar-print =
    .label = Shtype
    .tooltiptext = Shtypeni këtë faqe… ({ $shortcut })
navbar-home =
    .label = Kreu
    .tooltiptext = Faqe Hyrëse e { -brand-short-name }-it
navbar-library =
    .label = Arkiv
    .tooltiptext = Shihni historikun, faqerojtësit e ruajtur, etj
navbar-search =
    .title = Kërkoni
# Name for the tabs toolbar as spoken by screen readers. The word
# "toolbar" is appended automatically and should not be included in
# in the string
tabs-toolbar =
    .aria-label = Skedash shfletuesi
tabs-toolbar-new-tab =
    .label = Skedë e Re
tabs-toolbar-list-all-tabs =
    .label = Paraqiti krejt skedat
    .tooltiptext = Paraqiti krejt skedat

## Drop indicator text for pinned tabs when no tabs are pinned.

pinned-tabs-drop-indicator = Lini këtu skedë që duhet fiksuar

## Infobar shown at startup to suggest session-restore

# <img data-l10n-name="icon"/> will be replaced by the application menu icon
restore-session-startup-suggestion-message = <strong>Të hapen skeda të mëparshme?</strong> Sesionin tuaj të mëparshëm mund ta riktheni që nga menuja e aplikacionit { -brand-short-name } <img data-l10n-name="icon"/>, nën Historik.
restore-session-startup-suggestion-button = Tregomëni se si

## Infobar shown when the user tries to open a file picker and file pickers are blocked by enterprise policy

filepicker-blocked-infobar = Enti juaj e ka bllokuar hyrjen te kartela vendore në këtë kompjuter

## Mozilla data reporting notification (Telemetry, Firefox Health Report, etc)

data-reporting-notification-message = { -brand-short-name } dërgon vetvetiu disa të dhëna te { -vendor-short-name } që të mund të përmirësojmë punimin e tij për ju.
data-reporting-notification-button =
    .label = Zgjidhni Ç’Të Ndahet Me Të Tjerët
    .accesskey = Z
# Label for the indicator shown in the private browsing window titlebar.
private-browsing-indicator-label = Shfletim privat
# Tooltip for the indicator shown in the private browsing window titlebar.
private-browsing-indicator-tooltip =
    .tooltiptext = Shfletim privat
# Tooltip for the indicator shown in the window titlebar when content analysis is active.
# Variables:
#   $agentName (String): The name of the DLP agent that is connected
content-analysis-indicator-tooltip =
    .tooltiptext = Parandalim humbjeje të dhënash (DLP) nga { $agentName }. Klikoni për më tepër hollësi.
content-analysis-panel-title = Mbrojtje të dhënash
# Variables:
#   $agentName (String): The name of the DLP agent that is connected
content-analysis-panel-text-styled = Enti juaj përdor <b>{ $agentName }</b> për mbrojtje kundër humbjesh të dhënash. <a data-l10n-name="info">Mësoni më tepër</a>

## Unified extensions (toolbar) button

unified-extensions-button =
    .label = Zgjerime
    .tooltiptext = Zgjerime

## Unified extensions button when permission(s) are needed.
## Note that the new line is intentionally part of the tooltip.

unified-extensions-button-permissions-needed =
    .label = Zgjerime
    .tooltiptext = Zgjerime

## Unified extensions button when some extensions are quarantined.
## Note that the new line is intentionally part of the tooltip.

unified-extensions-button-quarantined =
    .label = Zgjerime
    .tooltiptext =
        Zgjerime
        Disa zgjerime nuk lejohen

## Unified extensions button when some extensions are disabled (e.g. through add-ons blocklist).
## Note that the new line is intentionally part of the tooltip.

unified-extensions-button-blocklisted =
    .label = Zgjerime
    .tooltiptext =
        Zgjerime
        Disa zgjerime janë aktivizuar

## Private browsing reset button

reset-pbm-toolbar-button =
    .label = Përfundo Sesion Privat
    .tooltiptext = Përfundoni Sesion Privat
reset-pbm-panel-heading = Të përfundohet sesion privat?
reset-pbm-panel-description = Mbyll krejt skedat private dhe fshi historik, “cookies” dhe të tjera të dhëna sajti.
reset-pbm-panel-always-ask-checkbox =
    .label = Pyetmë përherë
    .accesskey = P
reset-pbm-panel-cancel-button =
    .label = Anuloje
    .accesskey = A
reset-pbm-panel-confirm-button =
    .label = Fshi të dhëna sesioni
    .accesskey = F
reset-pbm-panel-complete = Të dhënat e sesionit privat u fshinë

## Autorefresh blocker

refresh-blocked-refresh-label = { -brand-short-name }-i i pengoi kësaj faqeje ringarkimin e vetvetishëm.
refresh-blocked-redirect-label = { -brand-short-name }-i i pengoi kësaj faqeje ridrejtimin e vetvetishëm te një faqe tjetër.
refresh-blocked-allow =
    .label = Lejoje
    .accesskey = L

## Firefox Relay integration

firefox-relay-offer-why-to-use-relay = Maskat tona të siguruara, të lehta për t’u përdorur mbrojnë identitetin tuaj dhe parandalojnë mesazhe të padëshiruar, duke fshehur adresën tuaj email.
# Variables:
#  $useremail (String): user email that will receive messages
firefox-relay-offer-what-relay-provides = Krejt email-et dërguar te maskat e emal-eve tuaj do të përcillen te <strong>{ $useremail }</strong> (veç në vendosshi t’i bllokoni ato).
firefox-relay-offer-legal-notice = Duke klikuar mbi “Përdor maskë email-i”, pajtoheni me <label data-l10n-name="tos-url">Kushte Shërbimi</label> dhe <label data-l10n-name="privacy-url">Shënim Privatësie</label>.
firefox-relay-offer-legal-notice-1 = Duke u regjistruar dhe duke krijuar një maskë email-i”, pajtoheni me <label data-l10n-name="tos-url">Kushte Shërbimi</label> dhe <label data-l10n-name="privacy-url">Shënim Privatësie</label>.

## Add-on Pop-up Notifications

popup-notification-addon-install-unsigned =
    .value = (E paverifikuar)
popup-notification-xpinstall-prompt-learn-more = Mësoni më tepër rreth instalimit të shtesave në mënyrë të parrezik
popup-notification-xpinstall-prompt-block-url = Shihni hollësitë
# Note: Access key is set to p to match "private" in the corresponding localized label.
popup-notification-addon-privatebrowsing-checkbox2 =
    .label = Lejoje zgjerimin të xhirojë në dritare private
    .accesskey = p
# This string is similar to `webext-perms-description-data-long-technicalAndInteraction`
# but it is used in the install prompt, and it needs an access key.
popup-notification-addon-technical-and-interaction-checkbox =
    .label = Ndani me zhvillues të zgjerimit të dhëna teknike dhe ndërveprimi
    .accesskey = N

## Pop-up warning

# Variables:
#   $popupCount (Number): the number of pop-ups blocked.
popup-warning-message =
    { $popupCount ->
        [one] { -brand-short-name } pengoi këtë sajt të hapë një dritare flluskë.
       *[other] { -brand-short-name } pengoi kë të sajt të hapë { $popupCount } dritare flluska.
    }
# Variables:
#   $popupCount (Number): the number of pop-ups blocked.
redirect-warning-with-popup-message =
    { $popupCount ->
        [0] { -brand-short-name }-i i pengoi këtij sajti ridrejtimin.
        [1] { -brand-short-name }-i e pengoi këtë sajt të hapë një dritare flluskë dhe të bëjë ridrejtim.
       *[other] { -brand-short-name } e pengoi këtë sajt të hapë { $popupCount } dritare flluskë dhe të bëjë ridrejtim.
    }
# The singular form is left out for English, since the number of blocked pop-ups is always greater than 1.
# Variables:
#   $popupCount (Number): the number of pop-ups blocked.
popup-warning-exceeded-message = { -brand-short-name } e pengoi këtë sajt të hapë më shumë se { $popupCount } dritare flluska.
# Variables:
#   $popupCount (Number): the number of pop-ups blocked.
popup-warning-exceeded-with-redirect-message =
    { $popupCount ->
        [one] { -brand-short-name } e pengoi këtë sajt të hapë më tepër se { $popupCount } dritare flluskë dhe të bëjë ridrejtim.
       *[other] { -brand-short-name } e pengoi këtë sajt të hapë më tepër se { $popupCount } dritare flluskë dhe të bëjë ridrejtim.
    }
popup-warning-button =
    .label =
        { PLATFORM() ->
            [windows] Mundësi
           *[other] Parapëlqime
        }
    .accesskey =
        { PLATFORM() ->
            [windows] M
           *[other] P
        }
# Variables:
#   $popupURI (String): the URI for the pop-up window
popup-show-popup-menuitem =
    .label = Shfaq '{ $popupURI }'
# Variables:
#   $redirectURI (String): the URI for the redirect
popup-trigger-redirect-menuitem =
    .label = Shfaq “{ $redirectURI }”

## File-picker crash notification ("FilePickerCrashed.sys.mjs")

file-picker-failed-open = Dialogu Windows për kartela s’u hap dot. S’përzgjidhej dot kartelë, ose dosje.
#   $path (string): The full path to which the file will be saved (e.g., 'C:\Users\Default User\Downloads\readme.txt').
file-picker-failed-save-somewhere = Dialogu Windows për kartela s’u hap dot. Kartela do të ruhet te { $path }.
file-picker-failed-save-nowhere = Dialogu Windows për kartela s’u hap dot. S’u gjet dot dosje parazgjedhje, kartela s’do të ruhet.
file-picker-crashed-open = Dialogu Windows për kartela u vithis. S’përzgjidhej dot kartelë, ose dosje.
#   $path (string): The full path to which the file will be saved (e.g., 'C:\Users\Default User\Downloads\readme.txt').
file-picker-crashed-save-somewhere = Dialogu Windows për kartela u vithis. Kartela do të ruhet te { $path }.
file-picker-crashed-save-nowhere = Dialogu Windows për kartela u vithis. S’përzgjidhej dot dosje parazgjedhje; kartela s’do të ruhet.

# Button used with file-picker-crashed-save-default. Opens the folder in Windows
# Explorer, with the saved file selected and in focus.
#
# The wording here should be consistent with the Windows variant of
# `downloads-cmd-show-menuitem-2` and similar messages.

file-picker-crashed-show-in-folder =
    .label = Shfaqe Në Dosje
    .accessKey = D

## Onboarding Finish Setup checklist

onboarding-checklist-button-label = Përfundo ujdisjen
onboarding-aw-finish-setup-button =
    .label = Përfundo ujdisjen
    .tooltiptext = Përfundoni ujdisjen e { -brand-short-name }-it

## The urlbar trust icon & panel

trustpanel-etp-label-enabled = Mbrojtje e Thelluar Nga Gjurmimi është aktive
trustpanel-etp-label-disabled = Mbrojtje e Thelluar Nga Gjurmimi është joaktive
# Variables
#  $host (String): the hostname of the site that is being displayed.
trustpanel-etp-toggle-on =
    .aria-label = Mbrojtje e Thelluar Nga Gjurmimi: On për { $host }
# Variables
#  $host (String): the hostname of the site that is being displayed.
trustpanel-etp-toggle-off =
    .aria-label = Mbrojtje e Thelluar Nga Gjurmimi: Off për { $host }
trustpanel-etp-description-enabled = Nëse diçka duket se nuk punon në këtë sajt, provoni të çaktivizoni mbrojtjet.
trustpanel-etp-description-disabled = { -brand-product-name }-i mendon se shoqëritë duhet t’ju ndjekin më pak. Bllokojmë aq gjurmues sa mundim, kur aktivizoni mbrojtjet.
trustpanel-connection-label-secure = Lidhje e siguruar
trustpanel-connection-label-insecure = Lidhje jo e siguruar
trustpanel-header-enabled = { -brand-product-name }-i po bën rojë
trustpanel-description-enabled2 = Jeni i mbrojtur. Nëse vërejmë gjë, do t’ua bëjmë të ditur.
trustpanel-header-enabled-insecure = Hapni sytë në këtë sajt
trustpanel-description-enabled-insecure = { -brand-product-name } vuri re diçka të dyshimtë.
trustpanel-description-enabled = Jeni i mbrojtur. Nëse vërejmë gjë, do t’ua bëjmë të ditur
trustpanel-header-disabled = Keni mbyllur mbrojtjet
trustpanel-description-disabled = { -brand-product-name }-i s’është në shërbim. Sugjerojmë të riaktivizoni mbrojtjet.
trustpanel-clear-cookies-button = Spastro cookie-t dhe të dhëna sajti
trustpanel-privacy-link = Rregullime Privatësie
# Variables
#  $host (String): the hostname of the site that is being displayed.
trustpanel-clear-cookies-header =
    .title = Spastro “ cookies” dhe të dhëna sajti për { $host }
trustpanel-clear-cookies-description = Heqja e cookie-eve dhe të dhënave të sajteve mund të sjellë daljen tuaj nga sajte dhe spastrim shportash blerjesh.
trustpanel-clear-cookies-subview-button-clear = Spastroje
trustpanel-clear-cookies-subview-button-cancel = Anuloje
# Variables
#  $host (String): the hostname of the site that is being displayed.
trustpanel-site-information-header =
    .title = Mbrojtje lidhjeje për { $host }
trustpanel-siteinformation-morelink = Më tepër hollësi sajti
trustpanel-blocker-see-all = Shihini Krejt
# Variables
#  $host (String): the hostname of the site that is being displayed.
trustpanel-blocker-header =
    .title = Mbrojtje nga gjurmimet për { $host }

## The urlbar trust icon & panel

# LOCALIZATION NOTE (trustpanel-urlbar-notsecure-label):
# Keep this string as short as possible, this is displayed in the URL bar
# use a synonym for "safe" or "private" if "secure" is too long.
urlbar-trust-icon-notsecure-label = Jo i Siguruar

## Variables
##  $count (String): the number of trackers blocked.

trustpanel-blocker-section-header =
    { $count ->
        [one] <span>{ $count }</span> Gjurmues i bllokuar në këtë sajt
       *[other] <span>{ $count }</span> Gjurmues të bllokuar në këtë sajt
    }
trustpanel-blocker-description = { -brand-product-name } mendon se shoqëritë duhet t’ju ndjekin më pak. Ndaj bllokojmë sa më shumë të mundemi.
trustpanel-blocked-header = { -brand-product-name }-i bllokoi këto gjëra për ju:
trustpanel-tracking-header = { -brand-product-name }-i lejoi këto gjëra, që kështu të mos dëmtohet funksionimi i sajteve:
trustpanel-tracking-description = Pa gjurmues, disa butona, formularë dhe fusha në kredenciale hyrjesh mund të mos funksionojnë.
trustpanel-insecure-section-header = Lidhja juaj s’është e sigurt
trustpanel-insecure-description = Të dhënat që po dërgoni te ky sajt s’janë të fshehtëzuara. Mund të shihen, vidhen, ose ndryshohen.
trustpanel-list-label-tracking-cookies =
    { $count ->
        [one] { $count } “Cookie” gjurmimi nga sajte në sajte
       *[other] { $count } “Cookies” gjurmimi nga sajte në sajte
    }
trustpanel-list-label-tracking-content = Lëndë gjurmimi
trustpanel-list-label-fingerprinter =
    { $count ->
        [one] { $count } Krijues Shenjash Gishtash
       *[other] { $count } Krijues Shenjash Gishtash
    }
trustpanel-list-label-social-tracking =
    { $count ->
        [one] { $count } Gjurmues mediash shoqërore
       *[other] { $count } Gjurmues mediash shoqërore
    }
trustpanel-list-label-cryptominer =
    { $count ->
        [one] { $count } Nxjerrës kriptomonedhash
       *[other] { $count } Nxjerrës kriptomonedhash
    }
trustpanel-social-tracking-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i bllokoi { $count } gjurmues mediash shoqërore
       *[other] { -brand-product-name }-i bllokoi { $count } gjurmues mediash shoqërore
    }
trustpanel-social-tracking-not-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i lejoi { $count } gjurmues mediash shoqërore
       *[other] { -brand-product-name }-i lejoi { $count } gjurmues mediash shoqërore
    }
trustpanel-tracking-cookies-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i bllokoi { $count } “cookie” gjurmimi nga sajti në sajt
       *[other] { -brand-product-name }-i bllokoi { $count } “cookies” gjurmimi nga sajti në sajt
    }
trustpanel-tracking-cookies-not-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i lejoi { $count } “cookie” gjurmimi nga sajti në sajt
       *[other] { -brand-product-name }-i lejoi { $count } “cookies” gjurmimi nga sajti në sajt
    }
trustpanel-tracking-content-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i bllokoi { $count } gjurmues
       *[other] { -brand-product-name }-i bllokoi { $count } gjurmues
    }
trustpanel-tracking-content-not-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i lejoi { $count } gjurmues
       *[other] { -brand-product-name }-i lejoi { $count } gjurmues
    }
trustpanel-tracking-content-tab-list-header = Këto sajte po rreken t’ju ndjekin:
trustpanel-fingerprinter-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i bllokoi { $count } krijues shenjash gishtash
       *[other] { -brand-product-name }-i bllokoi { $count } krijues shenjash gishtash
    }
trustpanel-fingerprinter-not-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name }-i lejoi { $count } krijues shenjash gishtash
       *[other] { -brand-product-name }-i lejoi { $count } krijues shenjash gishtash
    }
trustpanel-fingerprinter-list-header = Këto sajte po rreken të krijojnë shenja gishtash rreth jush:
trustpanel-cryptominer-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name } bllokoi { $count } nxjerrës kriptomonedhash
       *[other] { -brand-product-name } bllokoi { $count } nxjerrës kriptomonedhash
    }
trustpanel-cryptominer-not-blocking-tab-header =
    { $count ->
        [one] { -brand-product-name } lejoi { $count } nxjerrës kriptomonedhash
       *[other] { -brand-product-name } lejoi { $count } nxjerrës kriptomonedhash
    }
trustpanel-cryptominer-tab-list-header = Këto sajte po rreken të nxjerrin kriptomonedha:
