# frozen_string_literal: true

class QueueBackfillHasRemediationsOfVulnerabilityReads < Gitlab::Database::Migration[2.1]
  MIGRATION = "BackfillHasRemediationsOfVulnerabilityReads"
  DELAY_INTERVAL = 2.minutes
  BATCH_SIZE = 10_000
  SUB_BATCH_SIZE = 50

  restrict_gitlab_migration gitlab_schema: :gitlab_main
  disable_ddl_transaction!

  # per: https://docs.gitlab.com/ee/development/database/batched_background_migrations.html#requeuing-batched-background-migrations
  # > When you requeue the batched background migration, turn the original queuing
  # > into a no-op by clearing up the #up and #down methods of the migration
  # > performing the requeuing. Otherwise, the batched background migration is
  # > queued multiple times on systems that are upgrading multiple patch releases
  # > at once.
  #
  # being re-run via https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135747
  def up; end

  def down; end
end
