# frozen_string_literal: true

class IndexVulnerabilityReadsForVulnerabilityExport < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '16.11'

  TABLE_NAME = :vulnerability_reads
  INDEX_NAME = :index_vulnerability_reads_for_vulnerability_export

  def up
    add_concurrent_index TABLE_NAME, %i[traversal_ids vulnerability_id], name: INDEX_NAME, where: 'archived = false'
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end
end
