# frozen_string_literal: true

class DropTmpIndexCisVulnerabilityReadsOnId < Gitlab::Database::Migration[2.2]
  INDEX_NAME = 'tmp_index_cis_vulnerability_reads_on_id'

  disable_ddl_transaction!
  milestone '17.1'

  def up
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end

  def down
    add_concurrent_index :vulnerability_reads, :id, name: INDEX_NAME, where: 'report_type = 7'
  end
end
