// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A subset of terms proposed by the proposer, which have been accepted by the
// acceptor as part of agreement creation.
//
// The following types satisfy this interface:
//
//	AcceptedTermMemberByolPricingTerm
//	AcceptedTermMemberConfigurableUpfrontPricingTerm
//	AcceptedTermMemberFixedUpfrontPricingTerm
//	AcceptedTermMemberFreeTrialPricingTerm
//	AcceptedTermMemberLegalTerm
//	AcceptedTermMemberPaymentScheduleTerm
//	AcceptedTermMemberRecurringPaymentTerm
//	AcceptedTermMemberRenewalTerm
//	AcceptedTermMemberSupportTerm
//	AcceptedTermMemberUsageBasedPricingTerm
//	AcceptedTermMemberValidityTerm
type AcceptedTerm interface {
	isAcceptedTerm()
}

// Enables you and your customers to move your existing agreements to AWS
// Marketplace. The customer won't be charged for product usage in AWS Marketplace
// because they already paid for the product outside of AWS Marketplace.
type AcceptedTermMemberByolPricingTerm struct {
	Value ByolPricingTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberByolPricingTerm) isAcceptedTerm() {}

// Defines a prepaid payment model that allows buyers to configure the
// entitlements they want to purchase and the duration.
type AcceptedTermMemberConfigurableUpfrontPricingTerm struct {
	Value ConfigurableUpfrontPricingTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberConfigurableUpfrontPricingTerm) isAcceptedTerm() {}

// Defines a pre-paid pricing model where the customers are charged a fixed
// upfront amount.
type AcceptedTermMemberFixedUpfrontPricingTerm struct {
	Value FixedUpfrontPricingTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberFixedUpfrontPricingTerm) isAcceptedTerm() {}

// Defines a short-term free pricing model where the buyers aren’t charged
// anything within a specified limit.
type AcceptedTermMemberFreeTrialPricingTerm struct {
	Value FreeTrialPricingTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberFreeTrialPricingTerm) isAcceptedTerm() {}

// Defines the list of text agreements proposed to the acceptors. An example is
// the end user license agreement (EULA).
type AcceptedTermMemberLegalTerm struct {
	Value LegalTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberLegalTerm) isAcceptedTerm() {}

// Defines an installment-based pricing model where customers are charged a fixed
// price on different dates during the agreement validity period. This is used most
// commonly for flexible payment schedule pricing.
type AcceptedTermMemberPaymentScheduleTerm struct {
	Value PaymentScheduleTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberPaymentScheduleTerm) isAcceptedTerm() {}

// Defines a pricing model where customers are charged a fixed recurring price at
// the end of each billing period.
type AcceptedTermMemberRecurringPaymentTerm struct {
	Value RecurringPaymentTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberRecurringPaymentTerm) isAcceptedTerm() {}

// Defines that on graceful expiration of the agreement (when the agreement ends
// on its pre-defined end date), a new agreement will be created using the accepted
// terms on the existing agreement. In other words, the agreement will be renewed.
// Presence of RenewalTerm in the offer document means that auto-renewal is
// allowed. Buyers will have the option to accept or decline auto-renewal at the
// offer acceptance/agreement creation. Buyers can also change this flag from True
// to False or False to True at anytime during the agreement's lifecycle.
type AcceptedTermMemberRenewalTerm struct {
	Value RenewalTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberRenewalTerm) isAcceptedTerm() {}

// Defines the customer support available for the acceptors when they purchase the
// software.
type AcceptedTermMemberSupportTerm struct {
	Value SupportTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberSupportTerm) isAcceptedTerm() {}

// Defines a usage-based pricing model (typically, pay-as-you-go pricing), where
// the customers are charged based on product usage.
type AcceptedTermMemberUsageBasedPricingTerm struct {
	Value UsageBasedPricingTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberUsageBasedPricingTerm) isAcceptedTerm() {}

// Defines the conditions that will keep an agreement created from this offer
// valid.
type AcceptedTermMemberValidityTerm struct {
	Value ValidityTerm

	noSmithyDocumentSerde
}

func (*AcceptedTermMemberValidityTerm) isAcceptedTerm() {}

// The details of the party accepting the agreement terms. This is commonly the
// buyer for PurchaseAgreement .
type Acceptor struct {

	// The AWS account ID of the acceptor.
	AccountId *string

	noSmithyDocumentSerde
}

// A summary of the agreement, including top-level attributes (for example, the
// agreement ID, version, proposer, and acceptor).
type AgreementViewSummary struct {

	// The date and time that the agreement was accepted.
	AcceptanceTime *time.Time

	// Details of the party accepting the agreement terms. This is commonly the buyer
	// for PurchaseAgreement.
	Acceptor *Acceptor

	// The unique identifier of the agreement.
	AgreementId *string

	// The type of agreement. Values are PurchaseAgreement or VendorInsightsAgreement .
	AgreementType *string

	// The date and time when the agreement ends. The field is null for pay-as-you-go
	// agreements, which don’t have end dates.
	EndTime *time.Time

	// A summary of the proposal
	ProposalSummary *ProposalSummary

	// Details of the party proposing the agreement terms, most commonly the seller
	// for PurchaseAgreement .
	Proposer *Proposer

	// The date and time when the agreement starts.
	StartTime *time.Time

	// The current status of the agreement.
	Status AgreementStatus

	noSmithyDocumentSerde
}

// Enables you and your customers to move your existing agreements to AWS
// Marketplace. The customer won't be charged for product usage in AWS Marketplace
// because they already paid for the product outside of AWS Marketplace.
type ByolPricingTerm struct {

	// Type of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

// Defines a prepaid payment model that allows buyers to configure the
// entitlements they want to purchase and the duration.
type ConfigurableUpfrontPricingTerm struct {

	// Additional parameters specified by the acceptor while accepting the term.
	Configuration *ConfigurableUpfrontPricingTermConfiguration

	// Defines the currency for the prices mentioned in the term.
	CurrencyCode *string

	// A rate card defines the per unit rates for product dimensions.
	RateCards []ConfigurableUpfrontRateCardItem

	// Category of selector.
	Type *string

	noSmithyDocumentSerde
}

// Defines a prepaid payment model that allows buyers to configure the
// entitlements they want to purchase and the duration.
type ConfigurableUpfrontPricingTermConfiguration struct {

	// Defines the dimensions that the acceptor has purchased from the overall set of
	// dimensions presented in the rate card.
	//
	// This member is required.
	Dimensions []Dimension

	// Defines the length of time for which the particular pricing/dimension is being
	// purchased by the acceptor.
	//
	// This member is required.
	SelectorValue *string

	noSmithyDocumentSerde
}

// Within the prepaid payment model defined under ConfigurableUpfrontPricingTerm ,
// the RateCardItem defines all the various rate cards (including pricing and
// dimensions) that have been proposed.
type ConfigurableUpfrontRateCardItem struct {

	// Defines limits on how the term can be configured by acceptors.
	Constraints *Constraints

	// Defines the per unit rates for product dimensions.
	RateCard []RateCardItem

	// Differentiates between the mutually exclusive rate cards in the same pricing
	// term to be selected by the buyer.
	Selector *Selector

	noSmithyDocumentSerde
}

// Defines limits on how the term can be configured by acceptors.
type Constraints struct {

	// Determines if buyers are allowed to select multiple dimensions in the rate
	// card. The possible values are Allowed and Disallowed . The default value is
	// Allowed .
	MultipleDimensionSelection *string

	// Determines if acceptors are allowed to configure quantity for each dimension in
	// rate card. The possible values are Allowed and Disallowed . The default value is
	// Allowed .
	QuantityConfiguration *string

	noSmithyDocumentSerde
}

// Defines the dimensions that the acceptor has purchased from the overall set of
// dimensions presented in the rate card.
type Dimension struct {

	// The name of key value of the dimension.
	//
	// This member is required.
	DimensionKey *string

	// The number of units of the dimension the acceptor has purchased.
	//
	// For Agreements with ConfigurableUpfrontPricingTerm , the RateCard section will
	// define the prices and dimensions defined by the seller (proposer), whereas the
	// Configuration section will define the actual dimensions, prices, and units the
	// buyer has chosen to accept.
	//
	// This member is required.
	DimensionValue int32

	noSmithyDocumentSerde
}

// Includes the list of references to legal resources proposed by the proposer to
// the acceptor. Each DocumentItem refers to an individual reference.
type DocumentItem struct {

	// Category of the document. Document types include:
	//
	//   - CustomEula – A custom EULA provided by you as seller. A URL for a EULA
	//   stored in an accessible Amazon S3 bucket is required for this document type.
	//
	//   - CustomDsa – A custom Data Subscription Agreement (DSA) provided by you as
	//   seller. A URL for a DSA stored in an accessible Amazon S3 bucket is required for
	//   this document type.
	//
	//   - StandardEula – The Standard Contract for AWS Marketplace (SCMP). For more
	//   information about SCMP, see the AWS Marketplace Seller Guide. You don’t provide
	//   a URL for this type because it’s managed by AWS Marketplace.
	//
	//   - StandardDsa – DSA for AWS Marketplace. For more information about the DSA,
	//   see the AWS Data Exchange User Guide. You don’t provide a URL for this type
	//   because it’s managed by AWS Marketplace.
	Type *string

	// A URL to the legal document for buyers to read. Required when Type is CustomEula
	// .
	Url *string

	// Version of standard contracts provided by AWS Marketplace. Required when Type
	// is StandardEula or StandardDsa .
	Version *string

	noSmithyDocumentSerde
}

// Estimated cost of the agreement.
type EstimatedCharges struct {

	// The total known amount customer has to pay across the lifecycle of the
	// agreement.
	//
	// This is the total contract value if accepted terms contain
	// ConfigurableUpfrontPricingTerm or FixedUpfrontPricingTerm . In the case of pure
	// contract pricing, this will be the total value of the contract. In the case of
	// contracts with consumption pricing, this will only include the committed value
	// and not include any overages that occur.
	//
	// If the accepted terms contain PaymentScheduleTerm , it will be the total payment
	// schedule amount. This occurs when flexible payment schedule is used, and is the
	// sum of all invoice charges in the payment schedule.
	//
	// In case a customer has amended an agreement, by purchasing more units of any
	// dimension, this will include both the original cost as well as the added cost
	// incurred due to addition of new units.
	//
	// This is 0 if the accepted terms contain UsageBasedPricingTerm without
	// ConfigurableUpfrontPricingTerm or RecurringPaymentTerm . This occurs for
	// usage-based pricing (such as SaaS metered or AMI/container hourly or monthly),
	// because the exact usage is not known upfront.
	AgreementValue *string

	// Defines the currency code for the charge.
	CurrencyCode *string

	noSmithyDocumentSerde
}

// The filter name and value pair that is used to return a more specific list of
// results. Filters can be used to match a set of resources by various criteria,
// such as offerId or productId .
type Filter struct {

	// The name of the filter.
	Name *string

	// The filter value.
	Values []string

	noSmithyDocumentSerde
}

// Defines a prepaid pricing model where the customers are charged a fixed upfront
// amount.
type FixedUpfrontPricingTerm struct {

	// Defines the currency for the prices mentioned in this term.
	CurrencyCode *string

	// Contract duration for the terms.
	Duration *string

	// Entitlements granted to the acceptor of fixed upfront as part of agreement
	// execution.
	Grants []GrantItem

	// Fixed amount to be charged to the customer when this term is accepted.
	Price *string

	// Category of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

// Defines a short-term free pricing model where the buyers aren’t charged
// anything within a specified limit.
type FreeTrialPricingTerm struct {

	// Duration of the free trial period (5–31 days).
	Duration *string

	// Entitlements granted to the acceptor of a free trial as part of an agreement
	// execution.
	Grants []GrantItem

	// Category of the term.
	Type *string

	noSmithyDocumentSerde
}

// Entitlements granted to the acceptor of fixed upfront as part of agreement
// execution.
type GrantItem struct {

	// Unique dimension key defined in the product document. Dimensions represent
	// categories of capacity in a product and are specified when the product is listed
	// in AWS Marketplace.
	DimensionKey *string

	// Maximum amount of capacity that the buyer can be entitled to the given
	// dimension of the product. If MaxQuantity is not provided, the buyer will be
	// able to use an unlimited amount of the given dimension.
	MaxQuantity *int32

	noSmithyDocumentSerde
}

// Defines the list of text agreements proposed to the acceptors. An example is
// the end user license agreement (EULA).
type LegalTerm struct {

	// List of references to legal resources proposed to the buyers. An example is the
	// EULA.
	Documents []DocumentItem

	// Category of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

// Defines an installment-based pricing model where customers are charged a fixed
// price on different dates during the agreement validity period. This is used most
// commonly for flexible payment schedule pricing.
type PaymentScheduleTerm struct {

	// Defines the currency for the prices mentioned in the term.
	CurrencyCode *string

	// List of the payment schedule where each element defines one installment of
	// payment. It contains the information necessary for calculating the price.
	Schedule []ScheduleItem

	// Type of the term.
	Type *string

	noSmithyDocumentSerde
}

// A summary of the proposal received from the proposer.
type ProposalSummary struct {

	// The unique identifier of the offer in AWS Marketplace.
	OfferId *string

	// The list of resources involved in the agreement.
	Resources []Resource

	noSmithyDocumentSerde
}

// Details of the party proposing the agreement terms,. This is commonly the
// seller for PurchaseAgreement .
type Proposer struct {

	// The AWS account ID of the proposer.
	AccountId *string

	noSmithyDocumentSerde
}

// Defines the per unit rates for each individual product dimension.
type RateCardItem struct {

	// Dimension for which the given entitlement applies. Dimensions represent
	// categories of capacity in a product and are specified when the product is listed
	// in AWS Marketplace.
	DimensionKey *string

	// Per unit price for the product dimension that’s used for calculating the amount
	// to be charged.
	Price *string

	noSmithyDocumentSerde
}

// Defines a pricing model where customers are charged a fixed recurring price at
// the end of each billing period.
type RecurringPaymentTerm struct {

	// Defines the recurrence at which buyers are charged.
	BillingPeriod *string

	// Defines the currency for the prices mentioned in this term.
	CurrencyCode *string

	// Amount charged to the buyer every billing period.
	Price *string

	// Type of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

// Defines that on graceful expiration of the agreement (when the agreement ends
// on its pre-defined end date), a new agreement will be created using the accepted
// terms on the existing agreement. In other words, the agreement will be renewed.
// The presence of RenewalTerm in the offer document means that auto-renewal is
// allowed. Buyers will have the option to accept or decline auto-renewal at the
// offer acceptance/agreement creation. Buyers can also change this flag from True
// to False or False to True at anytime during the agreement's lifecycle.
type RenewalTerm struct {

	// Additional parameters specified by the acceptor while accepting the term.
	Configuration *RenewalTermConfiguration

	// Category of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

// Additional parameters specified by the acceptor while accepting the term.
type RenewalTermConfiguration struct {

	// Defines whether the acceptor has chosen to auto-renew the agreement at the end
	// of its lifecycle. Can be set to True or False .
	//
	// This member is required.
	EnableAutoRenew *bool

	noSmithyDocumentSerde
}

// The list of resources involved in the agreement.
type Resource struct {

	// The unique identifier of the resource.
	//
	// We mention the term resource, which is most commonly a product, so a resourceId
	// is also a productId .
	Id *string

	// Type of the resource, which is the product. Values include SaaSProduct or
	// AmiProduct .
	Type *string

	noSmithyDocumentSerde
}

// An individual installment of the payment that includes the date and amount of
// the charge.
type ScheduleItem struct {

	// The price that the customer would pay on the scheduled date (chargeDate).
	ChargeAmount *string

	// The date that the customer would pay the price defined in this payment schedule
	// term. Invoices are generated on the date provided.
	ChargeDate *time.Time

	noSmithyDocumentSerde
}

// Differentiates between the mutually exclusive rate cards in the same pricing
// term to be selected by the buyer.
type Selector struct {

	// Category of selector.
	Type *string

	// Contract duration. This field supports the ISO 8601 format.
	Value *string

	noSmithyDocumentSerde
}

// An object that contains the SortBy and SortOrder attributes.
type Sort struct {

	// The attribute on which the data is grouped, which can be by StartTime and
	// EndTime . The default value is EndTime .
	SortBy *string

	// The sorting order, which can be ASCENDING or DESCENDING . The default value is
	// DESCENDING .
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Defines the customer support available for the acceptors when they purchase the
// software.
type SupportTerm struct {

	// Free-text field about the refund policy description that will be shown to
	// customers as is on the website and console.
	RefundPolicy *string

	// Category of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

// Defines a usage-based pricing model (typically, pay-as-you-go pricing), where
// the customers are charged based on product usage.
type UsageBasedPricingTerm struct {

	// Defines the currency for the prices mentioned in the term.
	CurrencyCode *string

	// List of rate cards.
	RateCards []UsageBasedRateCardItem

	// Category of the term.
	Type *string

	noSmithyDocumentSerde
}

// Within the pay-as-you-go model defined under UsageBasedPricingTerm , the
// UsageBasedRateCardItem defines an individual rate for a product dimension.
type UsageBasedRateCardItem struct {

	// Defines the per unit rates for product dimensions.
	RateCard []RateCardItem

	noSmithyDocumentSerde
}

// The input fails to satisfy the constraints specified by the service.
type ValidationExceptionField struct {

	// See applicable actions.
	//
	// This member is required.
	Message *string

	// The name of the field associated with the error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Defines the conditions that will keep an agreement created from this offer
// valid.
type ValidityTerm struct {

	// Defines the duration that the agreement remains active. If AgreementStartDate
	// isn’t provided, the agreement duration is relative to the agreement signature
	// time. The duration is represented in the ISO_8601 format.
	AgreementDuration *string

	// Defines the date when the agreement ends. The agreement ends at 23:59:59.999
	// UTC on the date provided. If AgreementEndDate isn’t provided, the agreement end
	// date is determined by the validity of individual terms.
	AgreementEndDate *time.Time

	// Defines the date when agreement starts. The agreement starts at 00:00:00.000
	// UTC on the date provided. If AgreementStartDate isn’t provided, the agreement
	// start date is determined based on agreement signature time.
	AgreementStartDate *time.Time

	// Category of the term being updated.
	Type *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAcceptedTerm() {}
