/***********************************************************************************************
 * File Info: $Id: StockDataProcessor.java,v 1.2 2002/10/14 20:52:04 nathaniel_auvil Exp $
 * Copyright (C) 2000
 * Author: Nathaniel G. Auvil
 * Contributor(s):
 *
 * Copyright 2002 (C) Nathaniel G. Auvil. All Rights Reserved.
 *
 * Redistribution and use of this software and associated documentation
 * ("Software"), with or without modification, are permitted provided
 * that the following conditions are met:
 *
 * 1. Redistributions of source code must retain copyright
 *    statements and notices.  Redistributions must also contain a
 *    copy of this document.
 *
 * 2. Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *
 * 3. The name "jCharts" or "Nathaniel G. Auvil" must not be used to
 * 	  endorse or promote products derived from this Software without
 * 	  prior written permission of Nathaniel G. Auvil.  For written
 *    permission, please contact nathaniel_auvil@users.sourceforge.net
 *
 * 4. Products derived from this Software may not be called "jCharts"
 *    nor may "jCharts" appear in their names without prior written
 *    permission of Nathaniel G. Auvil. jCharts is a registered
 *    trademark of Nathaniel G. Auvil.
 *
 * 5. Due credit should be given to the jCharts Project
 *    (http://jcharts.sourceforge.net/).
 *
 * THIS SOFTWARE IS PROVIDED BY Nathaniel G. Auvil AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * jCharts OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ************************************************************************************************/

package org.jCharts.chartData.processors;


import org.jCharts.chartData.interfaces.IStockChartDataSet;


/*******************************************************************************************
 * Custom processor for the Stock Chart as data is semi-processed by default.
 *
 *******************************************************************************************/
abstract class StockDataProcessor
{

	/*******************************************************************************************
	 * Only need to loop through the 'high' to find MAX and 'low' to find MIN.
	 *
	 * @param iStockChartDataSet
	 * @param axisChartDataProcessor
	 ********************************************************************************************/
	public static final void processData( IStockChartDataSet iStockChartDataSet,
													  AxisChartDataProcessor axisChartDataProcessor )
	{
		//LOOP
		for( int i=0; i < iStockChartDataSet.getNumberOfDataItems(); i++ )
		{
			//---look for MAX in 'high'.
			if( iStockChartDataSet.getHighValue( i ) > axisChartDataProcessor.getMaxValue() )
			{
				axisChartDataProcessor.setMaxValue( iStockChartDataSet.getHighValue( i ) );
			}

			//---look for MIN in 'Low'
			if( iStockChartDataSet.getLowValue( i ) < axisChartDataProcessor.getMinValue() )
			{
				axisChartDataProcessor.setMinValue( iStockChartDataSet.getLowValue( i ) );
			}
		}
	}
}
