/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Test whether a collection contains at least `n` elements which pass a test implemented by a predicate function.
*
* @module @stdlib/utils/async/some-by
*
* @example
* var readFile = require( '@stdlib/fs/read-file' );
* var someByAsync = require( '@stdlib/utils/async/some-by' );
*
* var files = [
*     './beep.js',
*     './boop.js'
* ];
*
* function done( error, bool ) {
*     if ( error ) {
*         throw error;
*     }
*     if ( bool ) {
*         console.log( 'Successfully read some files.' );
*     } else {
*         console.log( 'Unable to read some files.' );
*     }
* }
*
* function predicate( file, next ) {
*     var opts = {
*         'encoding': 'utf8'
*     };
*     readFile( file, opts, onFile );
*
*     function onFile( error ) {
*         if ( error ) {
*             return next( null, false );
*         }
*         next( null, true );
*     }
* }
*
* someByAsync( files, 2, predicate, done );
*/

// MODULES //

var setReadOnly = require( './../../../define-nonenumerable-read-only-property' );
var someByAsync = require( './some_by.js' );
var factory = require( './factory.js' );


// MAIN //

setReadOnly( someByAsync, 'factory', factory );


// EXPORTS //

module.exports = someByAsync;
