//// [objectTypesIdentityWithOptionality.ts]
// object types are identical structurally

class A {
    foo: string;
}

class B {
    foo: string;
}

class C<T> {
    foo: T;
}

interface I {
    foo?: string;
}

var a: { foo?: string; }
var b = { foo: '' };

function foo2(x: I);
function foo2(x: I); // error
function foo2(x: any) { }

function foo3(x: typeof a);
function foo3(x: typeof a); // error
function foo3(x: any) { }

function foo6(x: A);
function foo6(x: I); // ok
function foo6(x: any) { }

function foo7(x: A);
function foo7(x: typeof a); // ok
function foo7(x: any) { }

function foo8(x: B);
function foo8(x: I); // ok
function foo8(x: any) { }

function foo10(x: B);
function foo10(x: typeof a); // ok
function foo10(x: any) { }

function foo12(x: I);
function foo12(x: C<string>); // ok
function foo12(x: any) { }

function foo13(x: I);
function foo13(x: typeof a); // error
function foo13(x: any) { }

function foo14(x: I);
function foo14(x: typeof b); // ok
function foo14(x: any) { }

//// [objectTypesIdentityWithOptionality.js]
// object types are identical structurally
var A = /** @class */ (function () {
    function A() {
    }
    return A;
}());
var B = /** @class */ (function () {
    function B() {
    }
    return B;
}());
var C = /** @class */ (function () {
    function C() {
    }
    return C;
}());
var a;
var b = { foo: '' };
function foo2(x) { }
function foo3(x) { }
function foo6(x) { }
function foo7(x) { }
function foo8(x) { }
function foo10(x) { }
function foo12(x) { }
function foo13(x) { }
function foo14(x) { }
