/*
 * Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.security.provider;

import java.math.BigInteger;

import java.security.*;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

/**
 * A fake DSA key pair generator
 */
class DSAKeyPairGenerator extends KeyPairGenerator {

    private int plen;

    DSAKeyPairGenerator(int defaultKeySize) {
        super("DSA");
        this.plen = defaultKeySize;
    }

    public void initialize(int modlen, SecureRandom random) {
        this.plen = modlen;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) {
        throw new UnsupportedOperationException();
    }

    public KeyPair generateKeyPair() {
        BigInteger p, q, g, x, y;
        switch (plen) {
            case 1024:
                p = new BigInteger("178011905478542266528237562450159990145232"
                        + "156369120674273274450314442865788737020770612695252"
                        + "123463079567156784778466449970650770920727857050009"
                        + "668388144034129745221171818506047231150039301079959"
                        + "358067395348717066319802262019714966524135060945913"
                        + "707594956514672855690606794135837542707371727429551"
                        + "343320695239");
                q = new BigInteger("864205495604807476120572616017955259175325"
                        + "408501");
                g = new BigInteger("174068207532402095185811980123523436538604"
                        + "490794561350978495831040599953488455823147851597408"
                        + "940950725307797094915759492368300574252438761037084"
                        + "473467180148876118103083043754985190983472601550494"
                        + "691329488083395492313850000361646482644608492304078"
                        + "721818959999056496097769368017749273708962006689187"
                        + "956744210730");
                x = new BigInteger("442684721233431748836258763370873041965448"
                        + "305045");
                y = new BigInteger("123777377875361061959303516913138943002334"
                        + "907914087825062123737715425120688699041350157178201"
                        + "400875613890444051801751930684745642628053940339973"
                        + "838660880918443284038995141330502246221730915504106"
                        + "313025753680709037893119973285385498869618080832350"
                        + "844717549458284541384384444940685082987448444197127"
                        + "109727215326");
                break;
            case 3072:
                p = new BigInteger("532424770282957507167558442446475365039221"
                        + "865310725601984444684810811113744209961033785957055"
                        + "545569814329215072178264469737927701168579964248618"
                        + "212671015750272795670312875451455848633455356647610"
                        + "802537682630581977793580392148938495801039643027210"
                        + "168055234243089546290868853109011307872303192870862"
                        + "928522910714047973751079687063489704904165319118754"
                        + "414656318529199596549052269402875554159175957058778"
                        + "440558421673575502884909440510567191072050738584727"
                        + "120524174557883883057055053123583287619621138916493"
                        + "103747092870334536468061850120264153241617645557971"
                        + "369719361654590867807897284715299844320510777830158"
                        + "726099043158186232574541934847234927190558272654504"
                        + "899757279197741136733127726856995584055651857157703"
                        + "730144527174175430693903863066052387871964460507889"
                        + "647358151911550149297202134918108185581732063173116"
                        + "923323722454275514471399056679497166381315291238166"
                        + "678637058042047687405023560967657729197010282296512"
                        + "1019243318222397");
                q = new BigInteger("890750162030504407723769200757822201430799"
                        + "34855896740921457815099167207156753");
                g = new BigInteger("151817606774376623890824510431247991418389"
                        + "715779225250508738780526725946562383344295250350988"
                        + "771843988677909140611473778208677098146023000408394"
                        + "159085130929460916510001933636711147155614261913281"
                        + "024881629605746742555704817858764668833915862917006"
                        + "598838541275997577579609978297421111961935816027196"
                        + "483840098753346970227821715342000582711792748060856"
                        + "726896896804543780217869880654497603605897208724113"
                        + "159746510357451233393865294043543249227656881945445"
                        + "911394836487973565655780621125471620102365417701222"
                        + "942700788591992318925980959657031578942777920589286"
                        + "616050851348109471636081284309144953091734152913609"
                        + "446411782660994503265873790796828974300693496175976"
                        + "687169380996928285288177682058646187108156643041984"
                        + "849723272840833108573298006600021948389582796433112"
                        + "947515654733901137745000270350091408182905439114222"
                        + "789179830877253611946986888461931792357280552721443"
                        + "254779196196933589018709692301251250169609249601817"
                        + "4795480503442737");
                x = new BigInteger("837184725379267020693579006510066460977336"
                        + "11851797067505263114214549968402803");
                y = new BigInteger("395340495486576955293430186860596538887519"
                        + "532234445217156133155957480616804094258448364164620"
                        + "019669119585215430588435624960233328621409901309332"
                        + "192899527076171337665680476899693664056285881110265"
                        + "747619109873269836751712303602309960796986216520795"
                        + "801714761851172570535758859846766099312622783018124"
                        + "479033035974495130498276693342256396509951099944860"
                        + "886247767918456849069941054372775951688384599525157"
                        + "707186634084399395289878437457318095050730531728857"
                        + "772445883395712924633196197942869159234956079072812"
                        + "033713932103618702222793066673087288841096282175640"
                        + "243353943285718935517693389945339235110435667386410"
                        + "827568246083609394541667076709869892137539964277111"
                        + "881671381034966060604088870102183420000265271778711"
                        + "380501229707440889595235145225482336904915838699846"
                        + "941323450568220944649213026904670943083185766542427"
                        + "196471392765688014947830444837953042683779059773143"
                        + "877079141940001705246446188097009313372159366032655"
                        + "5436444354063312");
                break;
            default:
                throw new AssertionError("Unknown keySize " + plen);
        }

        try {
            return new KeyPair(new DSAPublicKeyImpl(y, p, q, g),
                    new DSAPrivateKey(x, p, q, g));
        } catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
    }
}
