
/*---------------------------------------------------------*\
| RGBController_GigabyteRGBFusion2USBBoards.cpp             |
|                                                           |
|   RGBController for Gigabyte Aorus RGB Fusion 2 USB       |
|   motherboard                                             |
|                                                           |
|   megadjc                                     31 Jul 2025 |
|                                                           |
|   This file is part of the OpenRGB project                |
|   SPDX-License-Identifier: GPL-2.0-or-later               |
\*---------------------------------------------------------*/

#include "RGBController_GigabyteRGBFusion2USBBoards.h"

/*---------------------------------------------------------*\
| This is a list of known layouts listed by controller      |
\*---------------------------------------------------------*/

const MBName MBName2LayoutLookup8297 =
{
    {"X570 AORUS ELITE",                  "STD_ATX" },
    {"X570 AORUS ELITE WIFI",             "STD_ATX" },
    {"X570 AORUS MASTER",              "MSTR_ATX_3" },
    {"X570 AORUS PRO",                    "STD_ATX" },
    {"X570 AORUS PRO WIFI",               "STD_ATX" },
    {"X570 AORUS ULTRA",                  "STD_ATX" },
    {"X570 I AORUS PRO WIFI",  "B550I-AORUS-PRO-AX" },
    {"Z390 AORUS MASTER-CF",             "MSTR_ATX" },
};

const MBName MBName2LayoutLookup8950 =
{
    {"H810M GAMING WIFI6",                  "H810M" },
    {"H810M H",                             "H810M" },
    {"H810M S2H",                           "H810M" },
};

const MBName MBName2LayoutLookup5702 =
{
    {"A620I AX",                        "B650-C-V2" },
    {"A620M C",                          "B650-D2H" },
    {"A620M D2H",                        "B650-D2H" },
    {"A620M DS3H",                        "A620M-H" },
    {"A620M GAMING X",                    "A620M-H" },
    {"A620M GAMING X AX",                 "A620M-H" },
    {"A620M H",                           "A620M-H" },
    {"A620M S2H",                       "B650-C-V2" },
    {"B550 AORUS ELITE",                  "STD_ATX" },
    {"B550 AORUS PRO",                    "STD_ATX" },
    {"B550I AORUS PRO AX",     "B550I-AORUS-PRO-AX" },
    {"B650 AERO G",                    "X670-ELITE" },
    {"B650 AORUS ELITE",               "B650-ELITE" },
    {"B650 AORUS ELITE AX",            "B650-ELITE" },
    {"B650 AORUS ELITE AX ICE",     "B650-ELITE-V2" },
    {"B650 AORUS ELITE AX V2",      "B650-ELITE-V2" },
    {"B650 AORUS ELITE V2",         "B650-ELITE-V2" },
    {"B650 AORUS PRO AX",                "B650-PRO" },
    {"B650 EAGLE",                  "B650-Eagle-AX" },
    {"B650 EAGLE AX",               "B650-Eagle-AX" },
    {"B650 GAMING X",                    "B650-PRO" },
    {"B650 GAMING X AX",                 "B650-PRO" },
    {"B650 GAMING X AX V2",              "B650-PRO" },
    {"B650 GAMING X V2",                 "B650-PRO" },
    {"B650 UD AC",                        "B650-UD" },
    {"B650 UD AX",                        "B650-UD" },
    {"B650E AORUS ELITE X AX ICE",  "B650-ELITE-V2" },
    {"B650E AORUS MASTER",             "MSTR_ATX_2" },
    {"B650E AORUS PRO X USB4",          "B650-USB4" },
    {"B650E AORUS TACHYON",             "B650-TACH" },
    {"B650I AORUS ULTRA",                "B650-D2H" },
    {"B650I AX",                        "B650-C-V2" },
    {"B650M AORUS ELITE",              "B650-ELITE" },
    {"B650M AORUS ELITE AX",           "B650-ELITE" },
    {"B650M AORUS ELITE AX ICE",       "B650-ELITE" },
    {"B650M AORUS PRO",                "B650-ELITE" },
    {"B650M AORUS PRO AX",             "B650-ELITE" },
    {"B650M C V2",                      "B650-C-V2" },
    {"B650M C V3",                      "B650-C-V2" },
    {"B650M D2H",                        "B650-D2H" },
    {"B650M D2HP",                     "B650M-DS3H" },
    {"B650M D3HP",                     "B650M-DS3H" },
    {"B650M D3HP AX",                  "B650M-DS3H" },
    {"B650M DS3H",                     "B650M-DS3H" },
    {"B650M GAMING PLUS WIFI",         "B650M-DS3H" },
    {"B650M GAMING WIFI",              "B650M-DS3H" },
    {"B650M GAMING WIFI6",             "B650M-DS3H" },
    {"B650M GAMING X AX",              "B650M-DS3H" },
    {"B650M H",                          "B650-D2H" },
    {"B650M K",                        "B650M-DS3H" },
    {"B650M S2H",                        "B650-D2H" },
    {"B760 AORUS ELITE",              "Z790-S-DDR4" },
    {"B760 AORUS ELITE AX",           "Z790-S-DDR4" },
    {"B760 AORUS MASTER DDR4",         "Z690-ELITE" },
    {"B760 DS3H",                     "Z790-S-DDR4" },
    {"B760 DS3H AC",                  "Z790-S-DDR4" },
    {"B760 DS3H AC DDR4",             "Z790-S-DDR4" },
    {"B760 DS3H AX",                  "Z790-S-DDR4" },
    {"B760 DS3H AX DDR4",             "Z790-S-DDR4" },
    {"B760 DS3H AX V2",               "Z790-S-DDR4" },
    {"B760 DS3H DDR4",                "Z790-S-DDR4" },
    {"B760 GAMING X",                 "Z790-S-DDR4" },
    {"B760 GAMING X AX",              "Z790-S-DDR4" },
    {"B760 GAMING X AX DDR4",         "Z790-S-DDR4" },
    {"B760 GAMING X DDR4",            "Z790-S-DDR4" },
    {"B760I AORUS PRO",        "B550I-AORUS-PRO-AX" },
    {"B760I AORUS PRO DDR4",   "B550I-AORUS-PRO-AX" },
    {"B760M AORUS ELITE",               "Z790-XTRM" },
    {"B760M AORUS ELITE AX",            "Z790-XTRM" },
    {"B760M AORUS ELITE AX DDR4",       "Z790-XTRM" },
    {"B760M AORUS ELITE DDR4",          "Z790-XTRM" },
    {"B760M AORUS ELITE X AX",         "B760M-EXAX" },
    {"B760M AORUS PRO",                 "Z790-XTRM" },
    {"B760M AORUS PRO AX",              "Z790-XTRM" },
    {"B760M AORUS PRO AX DDR4",         "Z790-XTRM" },
    {"B760M AORUS PRO DDR4",            "Z790-XTRM" },
    {"B760M C",                       "Z790-S-DDR4" },
    {"B760M C V2",                    "Z790-S-DDR4" },
    {"B760M D2H",                       "B760M-D2H" },
    {"B760M D2H DDR4",                  "B760M-D2H" },
    {"B760M D3H",                       "B760M-D2H" },
    {"B760M D3H DDR4",                  "B760M-D2H" },
    {"B760M D3HP",                      "B760M-D2H" },
    {"B760M D3HP DDR4",                 "B760M-D2H" },
    {"B760M D3HP WIFI6",                "B760M-D2H" },
    {"B760M DS3H",                      "B760M-D2H" },
    {"B760M DS3H AX",                   "B760M-D2H" },
    {"B760M DS3H AX DDR4",              "B760M-D2H" },
    {"B760M DS3H DDR4",                 "B760M-D2H" },
    {"B760M DS3H GEN 5",         "B760M-DS3H-DR-G5" },
    {"B760M G AX",                      "B760M-GAX" },
    {"B760M GAMING",                    "B760M-GAX" },
    {"B760M GAMING AC",                 "B760M-GAX" },
    {"B760M GAMING AC DDR4",            "B760M-D2H" },
    {"B760M GAMING DDR4",               "B760M-D2H" },
    {"B760M GAMING PLUS WIFI DDR4",     "B760M-D2H" },
    {"B760M GAMING WIFI",               "B760M-GAX" },
    {"B760M GAMING WIFI PLUS",          "B760M-GAX" },
    {"B760M GAMING X",                "Z790-S-DDR4" },
    {"B760M GAMING X AX",             "Z790-S-DDR4" },
    {"B760M GAMING X AX DDR4",        "Z790-S-DDR4" },
    {"B760M GAMING X DDR4",           "Z790-S-DDR4" },
    {"B760M POWER",                     "B760M-D2H" },
    {"B760M POWER DDR4",                "B760M-D2H" },
    {"H610M D3H DDR4",                  "B860I-Pro" },
    {"H610M D3H WIFI DDR4",             "B860I-Pro" },
    {"H610M GAMING WIFI DDR4",          "B860I-Pro" },
    {"TRX50 AERO D",                 "TRX50-AERO-D" },
    {"X570S AERO G",                   "X670-ELITE" },
    {"X570S AORUS ELITE",             "X570S-ELITE" },
    {"X570S AORUS ELITE AX",          "X570S-ELITE" },
    {"X570S AORUS MASTER",           "X570S-A-MSTR" },
    {"X570S AORUS PRO AX",           "X570S-PRO-AX" },
    {"X570S GAMING X",                "X570S-ELITE" },
    {"X570S UD",                       "X670-ELITE" },
    {"X570SI AORUS PRO AX",    "B550I-AORUS-PRO-AX" },
    {"X670 AORUS ELITE AX",            "X670-ELITE" },
    {"X670 GAMING X AX",               "X670-ELITE" },
    {"X670 GAMING X AX V2",         "B650-Eagle-AX" },
    {"X670E AORUS MASTER",             "MSTR_ATX_2" },
    {"X670E AORUS PRO X",            "X670-A-PRO-X" },
    {"X670E AORUS XTREME",             "MSTR_ATX_2" },
    {"Z690 AORUS ELITE",               "Z690-ELITE" },
    {"Z690 AORUS ELITE AX",            "Z690-ELITE" },
    {"Z690 AORUS ELITE AX DDR4",       "Z690-ELITE" },
    {"Z690 AORUS ELITE DDR4",          "Z690-ELITE" },
    {"Z790 AERO G",                   "Z790-S-DDR4" },
    {"Z790 AORUS ELITE",               "Z790-ELITE" },
    {"Z790 AORUS ELITE AX",            "Z790-ELITE" },
    {"Z790 AORUS ELITE AX DDR4",       "Z790-ELITE" },
    {"Z790 AORUS ELITE AX ICE",        "Z790-ELITE" },
    {"Z790 AORUS ELITE AX-W",          "Z790-ELITE" },
    {"Z790 AORUS ELITE DDR4",          "Z790-ELITE" },
    {"Z790 AORUS ELITE X",           "TRX50-AERO-D" },
    {"Z790 AORUS ELITE X AX",        "TRX50-AERO-D" },
    {"Z790 AORUS ELITE X WIFI7",     "TRX50-AERO-D" },
    {"Z790 AORUS MASTER",               "Z790-MSTR" },
    {"Z790 AORUS MASTER X",           "Z790-MSTR-X" },
    {"Z790 AORUS PRO X",               "Z790-PRO-X" },
    {"Z790 AORUS PRO X WIFI7",         "Z790-PRO-X" },
    {"Z790 AORUS TACHYON",              "Z790-XTRM" },
    {"Z790 AORUS TACHYON X",          "Z790-MSTR-X" },
    {"Z790 AORUS XTREME",               "Z790-XTRM" },
    {"Z790 AORUS XTREME X",           "Z790-XTRM-X" },
    {"Z790 AORUS XTREME X ICE",       "Z790-XTRM-X" },
    {"Z790 D",                             "Z790-D" },
    {"Z790 D AC",                          "Z790-D" },
    {"Z790 D AX",                          "Z790-D" },
    {"Z790 D WIFI",                        "Z790-D" },
    {"Z790 EAGLE",                         "Z790-D" },
    {"Z790 EAGLE AX",                      "Z790-D" },
    {"Z790 GAMING PLUS AX",           "Z790-S-DDR4" },
    {"Z790 GAMING X",                 "Z790-S-DDR4" },
    {"Z790 GAMING X AX",              "Z790-S-DDR4" },
    {"Z790 S DDR4",                   "Z790-S-DDR4" },
    {"Z790 S WIFI DDR4",              "Z790-S-DDR4" },
    {"Z790 UD",                            "Z790-D" },
    {"Z790 UD AC",                         "Z790-D" },
    {"Z790 UD AX",                         "Z790-D" },
    {"Z790I AORUS ULTRA",      "B550I-AORUS-PRO-AX" },
    {"Z790M AORUS ELITE",              "Z790-ELITE" },
    {"Z790M AORUS ELITE AX",           "Z790-ELITE" },
    {"Z790M AORUS ELITE AX ICE",       "Z790-ELITE" },
};

const MBName MBName2LayoutLookup5711 =
{
    {"A620I AX",                                     "B650-D2H" },
    {"A620M DS3H",                                 "B650M-DS3H" },
    {"A620M GAMING X",                             "B650M-DS3H" },
    {"A620M GAMING X AX",                          "B650M-DS3H" },
    {"A620M H",                                    "B650M-DS3H" },
    {"A620M S2H",                                  "B650M-DS3H" },
    {"B650E AORUS STEALTH ICE",           "B650E-AORUS-STEALTH" },
    {"B760 DS3H GEN5",                             "B840M-DS3H" },
    {"B760 DS3H WIFI6E GEN5",                      "B840M-DS3H" },
    {"B760 GAMING X DDR4 GEN5",                    "B840M-DS3H" },
    {"B760 GAMING X GEN5",                         "B840M-DS3H" },
    {"B760 GAMING X WIFI6 GEN5",                   "B840M-DS3H" },
    {"B760M AORUS ELITE DDR4 GEN5",                "X870-WIFI7" },
    {"B760M AORUS ELITE GEN5",                     "X870-WIFI7" },
    {"B760M AORUS ELITE WIFI6 DDR4 GEN5",          "X870-WIFI7" },
    {"B760M AORUS ELITE WIFI6 GEN5",               "X870-WIFI7" },
    {"B760M C V3",                             "B850-EGL-WIFI6" },
    {"B760M DS3H DDR4 GEN 5",                "B760M-DS3H-DR-G5" },
    {"B760M DS3H WIFI6E DDR4 GEN 5",         "B760M-DS3H-DR-G5" },
    {"B760M GAMING WIFI6 PLUS GEN5",         "B760M-DS3H-DR-G5" },
    {"B760M GAMING WIFI6E GEN 5",            "B760M-DS3H-DR-G5" },
    {"B760M GAMING X DDR4 GEN5",                  "B850-AI-TOP" },
    {"B760M GAMING X GEN5",                       "B850-AI-TOP" },
    {"B760M GAMING X WIFI6E DDR4 GEN5",           "B850-AI-TOP" },
    {"B760M GAMING X WIFI6E GEN5",                "B850-AI-TOP" },
    {"B840M AORUS ELITE WIFI6E",                 "B840M-WIFI6E" },
    {"B840M D2H",                                  "B840M-DS3H" },
    {"B840M DS3H",                                 "B840M-DS3H" },
    {"B840M EAGLE WIFI6",                          "B840M-DS3H" },
    {"B850 AI Top",                               "B850-AI-TOP" },
    {"B850 AORUS ELITE WIFI7",                     "X870-WIFI7" },
    {"B850 AORUS ELITE WIFI7 ICE",                 "X870-WIFI7" },
    {"B850 EAGLE ICE",                         "B850-EGL-WIFI6" },
    {"B850 EAGLE WIFI6E",                      "B850-EGL-WIFI6" },
    {"B850 EAGLE WIFI7 ICE",                   "B850-EGL-WIFI6" },
    {"B850 GAMING WIFI6",                      "B850-EGL-WIFI6" },
    {"B850 GAMING X WIFI6E",                   "B850-GMX-WIFI6" },
    {"B850I AORUS PRO",                             "X870I-PRO" },
    {"B850M AORUS ELITE",                      "B850-GMX-WIFI6" },
    {"B850M AORUS ELITE WIFI6E",               "B850-GMX-WIFI6" },
    {"B850M AORUS ELITE WIFI6E ICE",           "B850-GMX-WIFI6" },
    {"B850M AORUS PRO WIFI7",                      "Z890-WIFI7" },
    {"B850M D3HP",                                  "X870I-PRO" },
    {"B850M DS3H",                             "B850-EGL-WIFI6" },
    {"B850M DS3H ICE",                         "B850-EGL-WIFI6" },
    {"B850M EAGLE WIFI6E",                     "B850-EGL-WIFI6" },
    {"B850M EAGLE WIFI6E ICE",                 "B850-EGL-WIFI6" },
    {"B850M FORCE",                            "B850-EGL-WIFI6" },
    {"B850M FORCE WIFI6E",                     "B850-EGL-WIFI6" },
    {"B850M GAMING X WIFI6E",                  "B850-GMX-WIFI6" },
    {"B860 AORUS ELITE WIFI7 ICE",                 "B860-WIFI7" },
    {"B860 DS3H",                                   "B860-DS3H" },
    {"B860 DS3H WIFI6E",                            "B860-DS3H" },
    {"B860 EAGLE WIFI6E",                      "B860-EGL-WIFI6" },
    {"B860 GAMING X WIFI6E",                        "B860-DS3H" },
    {"B860I AORUS PRO ICE",                         "B860I-Pro" },
    {"B860M AORUS ELITE",                          "B860-WIFI7" },
    {"B860M AORUS ELITE WIFI6E",                   "B860-WIFI7" },
    {"B860M AORUS ELITE WIFI6E ICE",               "B860-WIFI7" },
    {"B860M AORUS PRO WIFI7",                      "B860-WIFI7" },
    {"B860M D2H",                                   "B860M-D2H" },
    {"B860M EAGLE",                          "B860-EGL-P-WIFI6" },
    {"B860M EAGLE DS3H",                     "B860-EGL-P-WIFI6" },
    {"B860M EAGLE DS3H WIFI6E",              "B860-EGL-P-WIFI6" },
    {"B860M EAGLE PLUS WIFI6E",              "B860-EGL-P-WIFI6" },
    {"B860M EAGLE WIFI6",                    "B860-EGL-P-WIFI6" },
    {"B860M EAGLE WIFI6 V2",                 "B860-EGL-P-WIFI6" },
    {"B860M GAMING WIFI6",                          "B860M-D2H" },
    {"B860M GAMING X",                       "B860-EGL-P-WIFI6" },
    {"B860M GAMING X WIFI6E",                "B860-EGL-P-WIFI6" },
    {"B860M POWER",                          "B860-EGL-P-WIFI6" },
    {"TRX50 AI TOP",                               "TRX50-A-TP" },
    {"W790 AI TOP",                               "B850-AI-TOP" },
    {"W880 AI TOP",                               "B850-AI-TOP" },
    {"X870 AORUS ELITE WIFI7",                     "X870-WIFI7" },
    {"X870 AORUS ELITE WIFI7 ICE",                 "X870-WIFI7" },
    {"X870 EAGLE WIFI7",                           "X870-WIFI7" },
    {"X870 GAMING WIFI6",                          "X870-WIFI7" },
    {"X870 GAMING X WIFI",                         "X870-WIFI7" },
    {"X870E AORUS ELITE WIFI7",                   "X870E-WIFI7" },
    {"X870E AORUS ELITE WIFI7 ICE",               "X870E-WIFI7" },
    {"X870E AORUS MASTER",                         "X870E-MSTR" },
    {"X870E AORUS PRO",                             "X870E-PRO" },
    {"X870E AORUS PRO ICE",                         "X870E-PRO" },
    {"X870E AORUS XTREME AI TOP",           "X870E-XTRM-AI-TOP" },
    {"X870I AORUS PRO",                             "X870I-PRO" },
    {"X870I AORUS PRO ICE",                         "X870I-PRO" },
    {"Z890 AERO D",                               "B850-AI-TOP" },
    {"Z890 AERO G",                               "B850-AI-TOP" },
    {"Z890 AI TOP",                               "B850-AI-TOP" },
    {"Z890 AORUS ELITE WIFI7",                     "Z890-WIFI7" },
    {"Z890 AORUS ELITE WIFI7 ICE",                 "Z890-WIFI7" },
    {"Z890 AORUS ELITE X ICE",                     "Z890-WIFI7" },
    {"Z890 AORUS MASTER",                           "Z890-MSTR" },
    {"Z890 AORUS MASTER AI TOP",             "Z890-MSTR-AI-TOP" },
    {"Z890 AORUS PRO ICE",                         "Z890-WIFI7" },
    {"Z890 AORUS TACHYON ICE",                    "B850-AI-TOP" },
    {"Z890 AORUS XTREME AI TOP",             "Z890-XTRM-AI-TOP" },
    {"Z890 EAGLE",                                 "Z890-WIFI7" },
    {"Z890 EAGLE WIFI7",                           "Z890-WIFI7" },
    {"Z890 GAMING X WIFI7",                        "Z890-WIFI7" },
    {"Z890 UD WIFI6E",                            "B850-AI-TOP" },
    {"Z890I AORUS ULTRA",                        "Z890-A-ULTRA" },
    {"Z890M AORUS ELITE WIFI7",                    "Z890-WIFI7" },
    {"Z890M AORUS ELITE WIFI7 ICE",                "Z890-WIFI7" },
    {"Z890M GAMING X",                              "X870I-PRO" },
};
