# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.dataprotection import DataProtectionClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-dataprotection
# USAGE
    python create_or_update_backup_policy.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DataProtectionClient(
        credential=DefaultAzureCredential(),
        subscription_id="04cf684a-d41f-4550-9f70-7708a3a2283b",
    )

    response = client.backup_policies.create_or_update(
        resource_group_name="000pikumar",
        vault_name="PrivatePreviewVault",
        backup_policy_name="OSSDBPolicy",
        parameters={
            "properties": {
                "datasourceTypes": ["OssDB"],
                "objectType": "BackupPolicy",
                "policyRules": [
                    {
                        "backupParameters": {"backupType": "Full", "objectType": "AzureBackupParams"},
                        "dataStore": {"dataStoreType": "VaultStore", "objectType": "DataStoreInfoBase"},
                        "name": "BackupWeekly",
                        "objectType": "AzureBackupRule",
                        "trigger": {
                            "objectType": "ScheduleBasedTriggerContext",
                            "schedule": {"repeatingTimeIntervals": ["R/2019-11-20T08:00:00-08:00/P1W"]},
                            "taggingCriteria": [
                                {"isDefault": True, "tagInfo": {"tagName": "Default"}, "taggingPriority": 99},
                                {
                                    "criteria": [
                                        {
                                            "daysOfTheWeek": ["Sunday"],
                                            "objectType": "ScheduleBasedBackupCriteria",
                                            "scheduleTimes": ["2019-03-01T13:00:00Z"],
                                        }
                                    ],
                                    "isDefault": False,
                                    "tagInfo": {"tagName": "Weekly"},
                                    "taggingPriority": 20,
                                },
                            ],
                        },
                    },
                    {
                        "isDefault": True,
                        "lifecycles": [
                            {
                                "deleteAfter": {"duration": "P1W", "objectType": "AbsoluteDeleteOption"},
                                "sourceDataStore": {"dataStoreType": "VaultStore", "objectType": "DataStoreInfoBase"},
                            }
                        ],
                        "name": "Default",
                        "objectType": "AzureRetentionRule",
                    },
                    {
                        "isDefault": False,
                        "lifecycles": [
                            {
                                "deleteAfter": {"duration": "P12W", "objectType": "AbsoluteDeleteOption"},
                                "sourceDataStore": {"dataStoreType": "VaultStore", "objectType": "DataStoreInfoBase"},
                            }
                        ],
                        "name": "Weekly",
                        "objectType": "AzureRetentionRule",
                    },
                ],
            }
        },
    )
    print(response)


# x-ms-original-file: specification/dataprotection/resource-manager/Microsoft.DataProtection/stable/2022-12-01/examples/PolicyCRUD/CreateOrUpdateBackupPolicy.json
if __name__ == "__main__":
    main()
