# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing.aio import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_customer(self, resource_group):
        response = await self.client.policies.get_by_customer(
            billing_account_name="str",
            billing_profile_name="str",
            customer_name="str",
            policy_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_customer(self, resource_group):
        response = await (
            await self.client.policies.begin_create_or_update_by_customer(
                billing_account_name="str",
                billing_profile_name="str",
                customer_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "viewCharges": "str",
                        "policies": [{"name": "str", "policyType": "str", "scope": "str", "value": "str"}],
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_billing_profile(self, resource_group):
        response = await self.client.policies.get_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_billing_profile(self, resource_group):
        response = await (
            await self.client.policies.begin_create_or_update_by_billing_profile(
                billing_account_name="str",
                billing_profile_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "enterpriseAgreementPolicies": {
                            "accountOwnerViewCharges": "str",
                            "authenticationType": "str",
                            "departmentAdminViewCharges": "str",
                        },
                        "invoiceSectionLabelManagement": "str",
                        "marketplacePurchases": "str",
                        "policies": [{"name": "str", "policyType": "str", "scope": "str", "value": "str"}],
                        "provisioningState": "str",
                        "reservationPurchases": "str",
                        "savingsPlanPurchases": "str",
                        "viewCharges": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_customer_at_billing_account(self, resource_group):
        response = await self.client.policies.get_by_customer_at_billing_account(
            billing_account_name="str",
            customer_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_customer_at_billing_account(self, resource_group):
        response = await (
            await self.client.policies.begin_create_or_update_by_customer_at_billing_account(
                billing_account_name="str",
                customer_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "viewCharges": "str",
                        "policies": [{"name": "str", "policyType": "str", "scope": "str", "value": "str"}],
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_billing_account(self, resource_group):
        response = await self.client.policies.get_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_billing_account(self, resource_group):
        response = await (
            await self.client.policies.begin_create_or_update_by_billing_account(
                billing_account_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "enterpriseAgreementPolicies": {
                            "accountOwnerViewCharges": "str",
                            "authenticationType": "str",
                            "departmentAdminViewCharges": "str",
                        },
                        "marketplacePurchases": "str",
                        "policies": [{"name": "str", "policyType": "str", "scope": "str", "value": "str"}],
                        "provisioningState": "str",
                        "reservationPurchases": "str",
                        "savingsPlanPurchases": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_subscription(self, resource_group):
        response = await self.client.policies.get_by_subscription(
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...
