// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    AccelGroup, Align, Application, Bin, Buildable, Container, ResizeMode, Widget, WindowGroup,
    WindowPosition, WindowType,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GtkWindow")]
    pub struct Window(Object<ffi::GtkWindow, ffi::GtkWindowClass>) @extends Bin, Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_window_get_type(),
    }
}

impl Window {
    pub const NONE: Option<&'static Window> = None;

    #[doc(alias = "gtk_window_new")]
    pub fn new(type_: WindowType) -> Window {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_window_new(type_.into_glib())).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Window`] objects.
    ///
    /// This method returns an instance of [`WindowBuilder`](crate::builders::WindowBuilder) which can be used to create [`Window`] objects.
    pub fn builder() -> WindowBuilder {
        WindowBuilder::new()
    }

    #[doc(alias = "gtk_window_get_default_icon_list")]
    #[doc(alias = "get_default_icon_list")]
    pub fn default_icon_list() -> Vec<gdk_pixbuf::Pixbuf> {
        assert_initialized_main_thread!();
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_window_get_default_icon_list())
        }
    }

    #[doc(alias = "gtk_window_get_default_icon_name")]
    #[doc(alias = "get_default_icon_name")]
    pub fn default_icon_name() -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_window_get_default_icon_name()) }
    }

    #[doc(alias = "gtk_window_list_toplevels")]
    pub fn list_toplevels() -> Vec<Widget> {
        assert_initialized_main_thread!();
        unsafe { FromGlibPtrContainer::from_glib_container(ffi::gtk_window_list_toplevels()) }
    }

    #[doc(alias = "gtk_window_set_auto_startup_notification")]
    pub fn set_auto_startup_notification(setting: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_auto_startup_notification(setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_default_icon")]
    pub fn set_default_icon(icon: &gdk_pixbuf::Pixbuf) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon(icon.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_default_icon_from_file")]
    pub fn set_default_icon_from_file(
        filename: impl AsRef<std::path::Path>,
    ) -> Result<(), glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::gtk_window_set_default_icon_from_file(
                filename.as_ref().to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gtk_window_set_default_icon_list")]
    pub fn set_default_icon_list(list: &[gdk_pixbuf::Pixbuf]) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon_list(list.to_glib_container().0);
        }
    }

    #[doc(alias = "gtk_window_set_default_icon_name")]
    pub fn set_default_icon_name(name: &str) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon_name(name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_interactive_debugging")]
    pub fn set_interactive_debugging(enable: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_interactive_debugging(enable.into_glib());
        }
    }
}

impl Default for Window {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Window`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct WindowBuilder {
    builder: glib::object::ObjectBuilder<'static, Window>,
}

impl WindowBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accept_focus(self, accept_focus: bool) -> Self {
        Self {
            builder: self.builder.property("accept-focus", accept_focus),
        }
    }

    pub fn application(self, application: &impl IsA<Application>) -> Self {
        Self {
            builder: self
                .builder
                .property("application", application.clone().upcast()),
        }
    }

    pub fn attached_to(self, attached_to: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("attached-to", attached_to.clone().upcast()),
        }
    }

    pub fn decorated(self, decorated: bool) -> Self {
        Self {
            builder: self.builder.property("decorated", decorated),
        }
    }

    pub fn default_height(self, default_height: i32) -> Self {
        Self {
            builder: self.builder.property("default-height", default_height),
        }
    }

    pub fn default_width(self, default_width: i32) -> Self {
        Self {
            builder: self.builder.property("default-width", default_width),
        }
    }

    pub fn deletable(self, deletable: bool) -> Self {
        Self {
            builder: self.builder.property("deletable", deletable),
        }
    }

    pub fn destroy_with_parent(self, destroy_with_parent: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("destroy-with-parent", destroy_with_parent),
        }
    }

    pub fn focus_on_map(self, focus_on_map: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-map", focus_on_map),
        }
    }

    pub fn focus_visible(self, focus_visible: bool) -> Self {
        Self {
            builder: self.builder.property("focus-visible", focus_visible),
        }
    }

    pub fn gravity(self, gravity: gdk::Gravity) -> Self {
        Self {
            builder: self.builder.property("gravity", gravity),
        }
    }

    pub fn hide_titlebar_when_maximized(self, hide_titlebar_when_maximized: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("hide-titlebar-when-maximized", hide_titlebar_when_maximized),
        }
    }

    pub fn icon(self, icon: &gdk_pixbuf::Pixbuf) -> Self {
        Self {
            builder: self.builder.property("icon", icon.clone()),
        }
    }

    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    pub fn mnemonics_visible(self, mnemonics_visible: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonics-visible", mnemonics_visible),
        }
    }

    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    pub fn resizable(self, resizable: bool) -> Self {
        Self {
            builder: self.builder.property("resizable", resizable),
        }
    }

    pub fn role(self, role: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("role", role.into()),
        }
    }

    pub fn screen(self, screen: &gdk::Screen) -> Self {
        Self {
            builder: self.builder.property("screen", screen.clone()),
        }
    }

    pub fn skip_pager_hint(self, skip_pager_hint: bool) -> Self {
        Self {
            builder: self.builder.property("skip-pager-hint", skip_pager_hint),
        }
    }

    pub fn skip_taskbar_hint(self, skip_taskbar_hint: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("skip-taskbar-hint", skip_taskbar_hint),
        }
    }

    pub fn startup_id(self, startup_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("startup-id", startup_id.into()),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn transient_for(self, transient_for: &impl IsA<Window>) -> Self {
        Self {
            builder: self
                .builder
                .property("transient-for", transient_for.clone().upcast()),
        }
    }

    pub fn type_(self, type_: WindowType) -> Self {
        Self {
            builder: self.builder.property("type", type_),
        }
    }

    pub fn type_hint(self, type_hint: gdk::WindowTypeHint) -> Self {
        Self {
            builder: self.builder.property("type-hint", type_hint),
        }
    }

    pub fn urgency_hint(self, urgency_hint: bool) -> Self {
        Self {
            builder: self.builder.property("urgency-hint", urgency_hint),
        }
    }

    pub fn window_position(self, window_position: WindowPosition) -> Self {
        Self {
            builder: self.builder.property("window-position", window_position),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Window`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Window {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Window>> Sealed for T {}
}

pub trait GtkWindowExt: IsA<Window> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_window_activate_default")]
    fn activate_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_activate_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_activate_focus")]
    fn activate_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_activate_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_activate_key")]
    fn activate_key(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_activate_key(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_window_add_accel_group")]
    fn add_accel_group(&self, accel_group: &impl IsA<AccelGroup>) {
        unsafe {
            ffi::gtk_window_add_accel_group(
                self.as_ref().to_glib_none().0,
                accel_group.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_add_mnemonic")]
    fn add_mnemonic(&self, keyval: u32, target: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_window_add_mnemonic(
                self.as_ref().to_glib_none().0,
                keyval,
                target.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_begin_move_drag")]
    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32) {
        unsafe {
            ffi::gtk_window_begin_move_drag(
                self.as_ref().to_glib_none().0,
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    #[doc(alias = "gtk_window_begin_resize_drag")]
    fn begin_resize_drag(
        &self,
        edge: gdk::WindowEdge,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    ) {
        unsafe {
            ffi::gtk_window_begin_resize_drag(
                self.as_ref().to_glib_none().0,
                edge.into_glib(),
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    #[doc(alias = "gtk_window_close")]
    fn close(&self) {
        unsafe {
            ffi::gtk_window_close(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_deiconify")]
    fn deiconify(&self) {
        unsafe {
            ffi::gtk_window_deiconify(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_fullscreen")]
    fn fullscreen(&self) {
        unsafe {
            ffi::gtk_window_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_fullscreen_on_monitor")]
    fn fullscreen_on_monitor(&self, screen: &gdk::Screen, monitor: i32) {
        unsafe {
            ffi::gtk_window_fullscreen_on_monitor(
                self.as_ref().to_glib_none().0,
                screen.to_glib_none().0,
                monitor,
            );
        }
    }

    #[doc(alias = "gtk_window_get_accept_focus")]
    #[doc(alias = "get_accept_focus")]
    fn accepts_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_accept_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_application")]
    #[doc(alias = "get_application")]
    fn application(&self) -> Option<Application> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_application(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_attached_to")]
    #[doc(alias = "get_attached_to")]
    fn attached_to(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_attached_to(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_decorated")]
    #[doc(alias = "get_decorated")]
    fn is_decorated(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_decorated(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_default_size")]
    #[doc(alias = "get_default_size")]
    fn default_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_window_get_default_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "gtk_window_get_default_widget")]
    #[doc(alias = "get_default_widget")]
    fn default_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_default_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_deletable")]
    #[doc(alias = "get_deletable")]
    fn is_deletable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_deletable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_destroy_with_parent")]
    #[doc(alias = "get_destroy_with_parent")]
    fn must_destroy_with_parent(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_destroy_with_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_focus")]
    #[doc(alias = "get_focus")]
    fn focused_widget(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_focus(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_focus_on_map")]
    #[doc(alias = "get_focus_on_map")]
    fn gets_focus_on_map(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_focus_on_map(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_focus_visible")]
    #[doc(alias = "get_focus_visible")]
    fn gets_focus_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_focus_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_gravity")]
    #[doc(alias = "get_gravity")]
    fn gravity(&self) -> gdk::Gravity {
        unsafe { from_glib(ffi::gtk_window_get_gravity(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_group")]
    #[doc(alias = "get_group")]
    fn group(&self) -> Option<WindowGroup> {
        unsafe { from_glib_none(ffi::gtk_window_get_group(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_hide_titlebar_when_maximized")]
    #[doc(alias = "get_hide_titlebar_when_maximized")]
    fn hides_titlebar_when_maximized(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_hide_titlebar_when_maximized(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_icon")]
    #[doc(alias = "get_icon")]
    fn icon(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe { from_glib_none(ffi::gtk_window_get_icon(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_icon_list")]
    #[doc(alias = "get_icon_list")]
    fn icon_list(&self) -> Vec<gdk_pixbuf::Pixbuf> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_window_get_icon_list(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    fn icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_mnemonic_modifier")]
    #[doc(alias = "get_mnemonic_modifier")]
    fn mnemonic_modifier(&self) -> gdk::ModifierType {
        unsafe {
            from_glib(ffi::gtk_window_get_mnemonic_modifier(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_mnemonics_visible")]
    #[doc(alias = "get_mnemonics_visible")]
    fn is_mnemonics_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_mnemonics_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_modal")]
    #[doc(alias = "get_modal")]
    fn is_modal(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_get_modal(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_position")]
    #[doc(alias = "get_position")]
    fn position(&self) -> (i32, i32) {
        unsafe {
            let mut root_x = mem::MaybeUninit::uninit();
            let mut root_y = mem::MaybeUninit::uninit();
            ffi::gtk_window_get_position(
                self.as_ref().to_glib_none().0,
                root_x.as_mut_ptr(),
                root_y.as_mut_ptr(),
            );
            (root_x.assume_init(), root_y.assume_init())
        }
    }

    #[doc(alias = "gtk_window_get_resizable")]
    #[doc(alias = "get_resizable")]
    fn is_resizable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_resizable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_role")]
    #[doc(alias = "get_role")]
    fn role(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_window_get_role(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_screen")]
    #[doc(alias = "get_screen")]
    fn screen(&self) -> Option<gdk::Screen> {
        unsafe { from_glib_none(ffi::gtk_window_get_screen(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_size")]
    #[doc(alias = "get_size")]
    fn size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_window_get_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "gtk_window_get_skip_pager_hint")]
    #[doc(alias = "get_skip_pager_hint")]
    fn skips_pager_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_skip_pager_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_skip_taskbar_hint")]
    #[doc(alias = "get_skip_taskbar_hint")]
    fn skips_taskbar_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_skip_taskbar_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_window_get_title(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_titlebar")]
    #[doc(alias = "get_titlebar")]
    fn titlebar(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_titlebar(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_transient_for")]
    #[doc(alias = "get_transient_for")]
    #[must_use]
    fn transient_for(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_transient_for(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_type_hint")]
    #[doc(alias = "get_type_hint")]
    fn type_hint(&self) -> gdk::WindowTypeHint {
        unsafe {
            from_glib(ffi::gtk_window_get_type_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_urgency_hint")]
    #[doc(alias = "get_urgency_hint")]
    fn is_urgency_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_urgency_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_window_type")]
    #[doc(alias = "get_window_type")]
    fn window_type(&self) -> WindowType {
        unsafe {
            from_glib(ffi::gtk_window_get_window_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_has_group")]
    fn has_group(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_has_group(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_has_toplevel_focus")]
    fn has_toplevel_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_has_toplevel_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_iconify")]
    fn iconify(&self) {
        unsafe {
            ffi::gtk_window_iconify(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_is_active")]
    fn is_active(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_active(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_is_maximized")]
    fn is_maximized(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_maximized(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_maximize")]
    fn maximize(&self) {
        unsafe {
            ffi::gtk_window_maximize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_mnemonic_activate")]
    fn mnemonic_activate(&self, keyval: u32, modifier: gdk::ModifierType) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_mnemonic_activate(
                self.as_ref().to_glib_none().0,
                keyval,
                modifier.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_window_move")]
    #[doc(alias = "move")]
    fn move_(&self, x: i32, y: i32) {
        unsafe {
            ffi::gtk_window_move(self.as_ref().to_glib_none().0, x, y);
        }
    }

    #[doc(alias = "gtk_window_present")]
    fn present(&self) {
        unsafe {
            ffi::gtk_window_present(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_present_with_time")]
    fn present_with_time(&self, timestamp: u32) {
        unsafe {
            ffi::gtk_window_present_with_time(self.as_ref().to_glib_none().0, timestamp);
        }
    }

    #[doc(alias = "gtk_window_propagate_key_event")]
    fn propagate_key_event(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_propagate_key_event(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_window_remove_accel_group")]
    fn remove_accel_group(&self, accel_group: &impl IsA<AccelGroup>) {
        unsafe {
            ffi::gtk_window_remove_accel_group(
                self.as_ref().to_glib_none().0,
                accel_group.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_remove_mnemonic")]
    fn remove_mnemonic(&self, keyval: u32, target: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_window_remove_mnemonic(
                self.as_ref().to_glib_none().0,
                keyval,
                target.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_resize")]
    fn resize(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_resize(self.as_ref().to_glib_none().0, width, height);
        }
    }

    #[doc(alias = "gtk_window_set_accept_focus")]
    fn set_accept_focus(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_accept_focus(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_application")]
    fn set_application(&self, application: Option<&impl IsA<Application>>) {
        unsafe {
            ffi::gtk_window_set_application(
                self.as_ref().to_glib_none().0,
                application.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_attached_to")]
    fn set_attached_to(&self, attach_widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_attached_to(
                self.as_ref().to_glib_none().0,
                attach_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_decorated")]
    fn set_decorated(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_decorated(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_default")]
    fn set_default(&self, default_widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_default(
                self.as_ref().to_glib_none().0,
                default_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_default_size")]
    fn set_default_size(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_set_default_size(self.as_ref().to_glib_none().0, width, height);
        }
    }

    #[doc(alias = "gtk_window_set_deletable")]
    fn set_deletable(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_deletable(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_destroy_with_parent")]
    fn set_destroy_with_parent(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_destroy_with_parent(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_focus")]
    fn set_focus(&self, focus: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_focus(
                self.as_ref().to_glib_none().0,
                focus.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_focus_on_map")]
    fn set_focus_on_map(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_focus_on_map(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_focus_visible")]
    fn set_focus_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_focus_visible(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_geometry_hints")]
    fn set_geometry_hints(
        &self,
        geometry_widget: Option<&impl IsA<Widget>>,
        geometry: Option<&gdk::Geometry>,
        geom_mask: gdk::WindowHints,
    ) {
        unsafe {
            ffi::gtk_window_set_geometry_hints(
                self.as_ref().to_glib_none().0,
                geometry_widget.map(|p| p.as_ref()).to_glib_none().0,
                mut_override(geometry.to_glib_none().0),
                geom_mask.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_gravity")]
    fn set_gravity(&self, gravity: gdk::Gravity) {
        unsafe {
            ffi::gtk_window_set_gravity(self.as_ref().to_glib_none().0, gravity.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_has_user_ref_count")]
    fn set_has_user_ref_count(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_has_user_ref_count(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_hide_titlebar_when_maximized")]
    fn set_hide_titlebar_when_maximized(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_hide_titlebar_when_maximized(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_icon")]
    fn set_icon(&self, icon: Option<&gdk_pixbuf::Pixbuf>) {
        unsafe {
            ffi::gtk_window_set_icon(self.as_ref().to_glib_none().0, icon.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_icon_from_file")]
    fn set_icon_from_file(&self, filename: impl AsRef<std::path::Path>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::gtk_window_set_icon_from_file(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gtk_window_set_icon_list")]
    fn set_icon_list(&self, list: &[gdk_pixbuf::Pixbuf]) {
        unsafe {
            ffi::gtk_window_set_icon_list(self.as_ref().to_glib_none().0, list.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_icon_name")]
    fn set_icon_name(&self, name: Option<&str>) {
        unsafe {
            ffi::gtk_window_set_icon_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_keep_above")]
    fn set_keep_above(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_keep_above(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_keep_below")]
    fn set_keep_below(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_keep_below(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_mnemonic_modifier")]
    fn set_mnemonic_modifier(&self, modifier: gdk::ModifierType) {
        unsafe {
            ffi::gtk_window_set_mnemonic_modifier(
                self.as_ref().to_glib_none().0,
                modifier.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_mnemonics_visible")]
    fn set_mnemonics_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_mnemonics_visible(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_modal")]
    fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::gtk_window_set_modal(self.as_ref().to_glib_none().0, modal.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_position")]
    fn set_position(&self, position: WindowPosition) {
        unsafe {
            ffi::gtk_window_set_position(self.as_ref().to_glib_none().0, position.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_resizable")]
    fn set_resizable(&self, resizable: bool) {
        unsafe {
            ffi::gtk_window_set_resizable(self.as_ref().to_glib_none().0, resizable.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_role")]
    fn set_role(&self, role: &str) {
        unsafe {
            ffi::gtk_window_set_role(self.as_ref().to_glib_none().0, role.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_screen")]
    fn set_screen(&self, screen: &gdk::Screen) {
        unsafe {
            ffi::gtk_window_set_screen(self.as_ref().to_glib_none().0, screen.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_skip_pager_hint")]
    fn set_skip_pager_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_skip_pager_hint(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_skip_taskbar_hint")]
    fn set_skip_taskbar_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_skip_taskbar_hint(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_startup_id")]
    fn set_startup_id(&self, startup_id: &str) {
        unsafe {
            ffi::gtk_window_set_startup_id(
                self.as_ref().to_glib_none().0,
                startup_id.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_title")]
    fn set_title(&self, title: &str) {
        unsafe {
            ffi::gtk_window_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_titlebar")]
    fn set_titlebar(&self, titlebar: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_titlebar(
                self.as_ref().to_glib_none().0,
                titlebar.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_transient_for")]
    fn set_transient_for(&self, parent: Option<&impl IsA<Window>>) {
        unsafe {
            ffi::gtk_window_set_transient_for(
                self.as_ref().to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_type_hint")]
    fn set_type_hint(&self, hint: gdk::WindowTypeHint) {
        unsafe {
            ffi::gtk_window_set_type_hint(self.as_ref().to_glib_none().0, hint.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_urgency_hint")]
    fn set_urgency_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_urgency_hint(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_stick")]
    fn stick(&self) {
        unsafe {
            ffi::gtk_window_stick(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_unfullscreen")]
    fn unfullscreen(&self) {
        unsafe {
            ffi::gtk_window_unfullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_unmaximize")]
    fn unmaximize(&self) {
        unsafe {
            ffi::gtk_window_unmaximize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_unstick")]
    fn unstick(&self) {
        unsafe {
            ffi::gtk_window_unstick(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "default-height")]
    fn default_height(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "default-height")
    }

    #[doc(alias = "default-height")]
    fn set_default_height(&self, default_height: i32) {
        ObjectExt::set_property(self.as_ref(), "default-height", default_height)
    }

    #[doc(alias = "default-width")]
    fn default_width(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "default-width")
    }

    #[doc(alias = "default-width")]
    fn set_default_width(&self, default_width: i32) {
        ObjectExt::set_property(self.as_ref(), "default-width", default_width)
    }

    #[doc(alias = "type")]
    fn type_(&self) -> WindowType {
        ObjectExt::property(self.as_ref(), "type")
    }

    #[doc(alias = "window-position")]
    fn window_position(&self) -> WindowPosition {
        ObjectExt::property(self.as_ref(), "window-position")
    }

    #[doc(alias = "window-position")]
    fn set_window_position(&self, window_position: WindowPosition) {
        ObjectExt::set_property(self.as_ref(), "window-position", window_position)
    }

    #[doc(alias = "activate-default")]
    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_default_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_default(&self) {
        self.emit_by_name::<()>("activate-default", &[]);
    }

    #[doc(alias = "activate-focus")]
    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_focus_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_focus(&self) {
        self.emit_by_name::<()>("activate-focus", &[]);
    }

    #[doc(alias = "enable-debugging")]
    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn enable_debugging_trampoline<
            P: IsA<Window>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkWindow,
            toggle: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Window::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(toggle),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"enable-debugging\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    enable_debugging_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_enable_debugging(&self, toggle: bool) -> bool {
        self.emit_by_name("enable-debugging", &[&toggle])
    }

    #[doc(alias = "keys-changed")]
    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn keys_changed_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"keys-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    keys_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "set-focus")]
    fn connect_set_focus<F: Fn(&Self, Option<&Widget>) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn set_focus_trampoline<
            P: IsA<Window>,
            F: Fn(&P, Option<&Widget>) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            widget: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Window::from_glib_borrow(this).unsafe_cast_ref(),
                Option::<Widget>::from_glib_borrow(widget).as_ref().as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"set-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    set_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "accept-focus")]
    fn connect_accept_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_focus_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accept-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accept_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "application")]
    fn connect_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::application\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_application_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attached-to")]
    fn connect_attached_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attached_to_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attached-to\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attached_to_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "decorated")]
    fn connect_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_decorated_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::decorated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_decorated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-height")]
    fn connect_default_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_height_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_default_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-width")]
    fn connect_default_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_width_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_default_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "deletable")]
    fn connect_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_deletable_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::deletable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_deletable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "destroy-with-parent")]
    fn connect_destroy_with_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_destroy_with_parent_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::destroy-with-parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_destroy_with_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-on-map")]
    fn connect_focus_on_map_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_on_map_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-on-map\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_on_map_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-visible")]
    fn connect_focus_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_visible_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gravity")]
    fn connect_gravity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gravity_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gravity\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gravity_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-toplevel-focus")]
    fn connect_has_toplevel_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_toplevel_focus_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-toplevel-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_toplevel_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hide-titlebar-when-maximized")]
    fn connect_hide_titlebar_when_maximized_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hide_titlebar_when_maximized_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hide-titlebar-when-maximized\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hide_titlebar_when_maximized_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon")]
    fn connect_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-active")]
    fn connect_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_active_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-active\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-maximized")]
    fn connect_is_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_maximized_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-maximized\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_maximized_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mnemonics-visible")]
    fn connect_mnemonics_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonics_visible_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonics-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mnemonics_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "modal")]
    fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_modal_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "resizable")]
    fn connect_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resizable_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resizable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_resizable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "role")]
    fn connect_role_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_role_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::role\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_role_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "screen")]
    fn connect_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_screen_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::screen\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_screen_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "skip-pager-hint")]
    fn connect_skip_pager_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_skip_pager_hint_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::skip-pager-hint\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_skip_pager_hint_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "skip-taskbar-hint")]
    fn connect_skip_taskbar_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_skip_taskbar_hint_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::skip-taskbar-hint\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_skip_taskbar_hint_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "startup-id")]
    fn connect_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_startup_id_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::startup-id\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_startup_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "transient-for")]
    fn connect_transient_for_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transient_for_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transient-for\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transient_for_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "type-hint")]
    fn connect_type_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_type_hint_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::type-hint\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_type_hint_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "urgency-hint")]
    fn connect_urgency_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_urgency_hint_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::urgency-hint\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_urgency_hint_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "window-position")]
    fn connect_window_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_position_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_window_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Window>> GtkWindowExt for O {}

impl fmt::Display for Window {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Window")
    }
}
