% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colIQRDiffs,dgCMatrix-method}
\alias{colIQRDiffs,dgCMatrix-method}
\alias{rowIQRDiffs,dgCMatrix-method}
\title{Calculates the interquartile range of the difference between each element of
a row (column) of a matrix-like object}
\usage{
\S4method{colIQRDiffs}{dgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, diff = 1L, trim = 0)

\S4method{rowIQRDiffs}{dgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, diff = 1L, trim = 0)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{diff}{An integer specifying the order of difference.}

\item{trim}{A double in [0,1/2] specifying the fraction of observations to
be trimmed from each end of (sorted) x before estimation.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the interquartile range of the difference between each element of
a row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowIQRDiffs}
/ \code{matrixStats::colIQRDiffs}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowIQRDiffs(mat)
  colIQRDiffs(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:varDiff]{rowIQRDiffs}()} and
\code{matrixStats::\link[matrixStats:varDiff]{colIQRDiffs}()} which
are used when the input is a \code{matrix} or \code{numeric} vector.
\item For the direct interquartile range see also \link[MatrixGenerics]{rowIQRs}.
}
}
