% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muhaz-tidiers.R
\name{tidy.muhaz}
\alias{tidy.muhaz}
\alias{muhaz_tidiers}
\title{Tidy a(n) muhaz object}
\usage{
\method{tidy}{muhaz}(x, ...)
}
\arguments{
\item{x}{A \code{muhaz} object returned by \code{\link[muhaz:muhaz]{muhaz::muhaz()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed(c("muhaz", "survival"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load libraries for models and data
library(muhaz)
library(survival)

# fit model
x <- muhaz(ovarian$futime, ovarian$fustat)

# summarize model fit with tidiers
tidy(x)
glance(x)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[muhaz:muhaz]{muhaz::muhaz()}}

Other muhaz tidiers: 
\code{\link{glance.muhaz}()}
}
\concept{muhaz tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{time}{Point in time.}
  \item{estimate}{Estimated hazard rate.}

}
