% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cvd.R
\name{simulate_cvd}
\alias{simulate_cvd}
\alias{deutan}
\alias{protan}
\alias{tritan}
\alias{interpolate_cvd_transform}
\title{Simulate Color Vision Deficiency}
\usage{
simulate_cvd(col, cvd_transform)

deutan(col, severity = 1)

protan(col, severity = 1)

tritan(col, severity = 1)

interpolate_cvd_transform(cvd, severity = 1)
}
\arguments{
\item{col}{character. A color or vector of colors, e.g., \code{"#FFA801"} or \code{"blue"}.
Input \code{col} can also be a matrix with three rows containing R/G/B (0-255) values, see details.}

\item{cvd_transform}{numeric 3x3 matrix, specifying the color vision deficiency transform matrix.}

\item{severity}{numeric. Severity of the color vision defect, a number between 0 and 1.}

\item{cvd}{list of cvd transformation matrices. See \code{\link{cvd}} for available options.}
}
\description{
Transformation of R colors by simulating color vision deficiencies,
based on a CVD transform matrix.
}
\details{
Using the physiologically-based model for simulating color vision deficiency (CVD)
of Machado et al. (2009), different kinds of limitations can be
emulated: deuteranope (green cone cells defective), protanope (red cone cells defective),
and tritanope (blue cone cells defective).
The workhorse function to do so is \code{simulate_cvd} which can take any vector
of valid R colors and transform them according to a certain CVD transformation
matrix (see \code{\link{cvd}}) and transformation equation.

The functions \code{deutan}, \code{protan}, and \code{tritan} are the high-level functions for
simulating the corresponding kind of colorblindness with a given severity.
Internally, they all call \code{simulate_cvd} along with a (possibly interpolated)
version of the matrices from \code{\link{cvd}}. Matrix interpolation can be carried out with
the function \code{interpolate_cvd_transform} (see Examples).

If input \code{col} is a matrix with three rows named \code{R}, \code{G}, and
\code{B} (top down) they are interpreted as Red-Green-Blue values within the
range \code{[0-255]}. Instead of an (s)RGB color vector a matrix of the same size as the
input \code{col} with the corresponding simulated Red-Green-Blue values will be returned.
This can be handy to avoid too many conversions.
}
\examples{
# simulate color-vision deficiency by calling `simulate_cvd` with specified matrix
simulate_cvd(c("#005000", "blue", "#00BB00"), tritanomaly_cvd["6"][[1]])

# simulate color-vision deficiency by calling the shortcut high-level function
tritan(c("#005000", "blue", "#00BB00"), severity = 0.6)

# simulate color-vision deficiency by calling `simulate_cvd` with interpolated cvd matrix
simulate_cvd(c("#005000", "blue", "#00BB00"),
             interpolate_cvd_transform(tritanomaly_cvd, severity = 0.6))

# apply CVD directly on RGB matrix
RGB <- t(hex2RGB(rainbow(3))@coords*255)
deutan(RGB)

}
\references{
Machado GM, Oliveira MM, Fernandes LAF (2009).
  A Physiologically-Based Model for Simulation of Color Vision Deficiency.
  \emph{IEEE Transactions on Visualization and Computer Graphics}. \bold{15}(6), 1291--1298.
  \doi{10.1109/TVCG.2009.113}
  Online version with supplements at
  \url{http://www.inf.ufrgs.br/~oliveira/pubs_files/CVD_Simulation/CVD_Simulation.html}.

Zeileis A, Fisher JC, Hornik K, Ihaka R, McWhite CD, Murrell P, Stauffer R, Wilke CO (2020).
\dQuote{ccolorspace: A Toolbox for Manipulating and Assessing Colors and Palettes.}
\emph{Journal of Statistical Software}, \bold{96}(1), 1--49. \doi{10.18637/jss.v096.i01}
}
\seealso{
\code{\link{cvd}}
}
\keyword{colorblind}
\keyword{colors}
\keyword{cvd}
