% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_qualitative.R
\name{scale_colour_binned_qualitative}
\alias{scale_colour_binned_qualitative}
\alias{scale_color_binned_qualitative}
\alias{scale_fill_binned_qualitative}
\title{HCL-Based Binned Qualitative Color Scales for ggplot2}
\usage{
scale_colour_binned_qualitative(
  palette = NULL,
  c1 = NULL,
  l1 = NULL,
  h1 = NULL,
  h2 = NULL,
  alpha = 1,
  rev = FALSE,
  begin = 0,
  end = 1,
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour",
  n_interp = 11,
  ...
)

scale_color_binned_qualitative(
  palette = NULL,
  c1 = NULL,
  l1 = NULL,
  h1 = NULL,
  h2 = NULL,
  alpha = 1,
  rev = FALSE,
  begin = 0,
  end = 1,
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour",
  n_interp = 11,
  ...
)

scale_fill_binned_qualitative(..., aesthetics = "fill")
}
\arguments{
\item{palette}{The name of the palette to be used. Run \code{hcl_palettes(type = "qualitative")} for available options.}

\item{c1}{Chroma value, used for all colors in the scale.}

\item{l1}{Luminance value, used for all colors in the scale.}

\item{h1}{Beginning hue value.}

\item{h2}{Ending hue value.}

\item{alpha}{Numeric vector of values in the range \code{[0, 1]} for alpha transparency channel (0 means transparent and 1 means opaque).}

\item{rev}{If \code{TRUE}, reverses the order of the colors in the color scale.}

\item{begin}{Number in the range of \code{[0, 1]} indicating to which point in the color scale the smallest data value should be mapped.}

\item{end}{Number in the range of \code{[0, 1]} indicating to which point in the color scale the largest data value should be mapped.}

\item{na.value}{Color to be used for missing data points.}

\item{guide}{Type of legend. Use \code{"coloursteps"} for color bar with discrete steps.}

\item{aesthetics}{The ggplot2 aesthetics to which this scale should be applied.}

\item{n_interp}{Number of discrete colors that should be used to interpolate the binned color scale. 11 will work fine in most cases.}

\item{...}{common binned scale parameters: `name`, `breaks`, `labels`, and `limits`. See
\code{\link[ggplot2]{binned_scale}} for more details.}
}
\description{
Binned ggplot2 color scales using the color palettes generated by \code{\link{qualitative_hcl}}. These scales are provided
for completeness. It is not normally a good idea to color a continuous, binned variable using a qualitative scale.
}
\details{
If both a valid palette name and palette parameters are provided then the provided palette parameters overwrite the parameters in the
named palette. This enables easy customization of named palettes.
}
\examples{
library("ggplot2")

# none of these examples are necessarily good ideas
gg <- ggplot(iris, aes(x = Species, y = Sepal.Width, color = Sepal.Length)) + 
  geom_jitter(width = 0.3) + theme_minimal()
  
gg + scale_color_binned_qualitative(palette = "Dynamic")
gg + scale_color_binned_qualitative(palette = "Dark3", l1 = 70)

nx = 87
ny = 61
df <- data.frame(height = c(volcano), x = rep(1:nx, ny), y = rep(1:ny, each = nx))
ggplot(df, aes(x, y, fill=height)) + 
  geom_raster() + scale_fill_binned_qualitative(palette = "Dark 3") +
  coord_fixed(expand = FALSE)
}
