% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneThreshold.R
\name{tuneThreshold}
\alias{tuneThreshold}
\title{Tune prediction threshold.}
\usage{
tuneThreshold(pred, measure, task, model, nsub = 20L, control = list())
}
\arguments{
\item{pred}{(\link{Prediction})\cr
Prediction object.}

\item{measure}{(\link{Measure})\cr
Performance measure to optimize.
Default is the default measure for the task.}

\item{task}{(\link{Task})\cr
Learning task. Rarely neeeded,
only when required for the performance measure.}

\item{model}{(\link{WrappedModel})\cr
Fitted model. Rarely neeeded,
only when required for the performance measure.}

\item{nsub}{(\code{integer(1)})\cr
Passed to \link[BBmisc:optimizeSubInts]{BBmisc::optimizeSubInts} for 2class problems.
Default is 20.}

\item{control}{(\link{list})\cr
Control object for \link[GenSA:GenSA]{GenSA::GenSA} when used.
Default is empty list.}
}
\value{
(\link{list}). A named list with with the following components:
\code{th} is the optimal threshold, \code{perf} the performance value.
}
\description{
Optimizes the threshold of predictions based on probabilities.
Works for classification and multilabel tasks.
Uses \link[BBmisc:optimizeSubInts]{BBmisc::optimizeSubInts} for normal binary class problems and
\link[GenSA:GenSA]{GenSA::GenSA} for multiclass and multilabel problems.
}
\seealso{
Other tune: 
\code{\link{TuneControl}},
\code{\link{getNestedTuneResultsOptPathDf}()},
\code{\link{getNestedTuneResultsX}()},
\code{\link{getResamplingIndices}()},
\code{\link{getTuneResult}()},
\code{\link{makeModelMultiplexerParamSet}()},
\code{\link{makeModelMultiplexer}()},
\code{\link{makeTuneControlCMAES}()},
\code{\link{makeTuneControlDesign}()},
\code{\link{makeTuneControlGenSA}()},
\code{\link{makeTuneControlGrid}()},
\code{\link{makeTuneControlIrace}()},
\code{\link{makeTuneControlMBO}()},
\code{\link{makeTuneControlRandom}()},
\code{\link{makeTuneWrapper}()},
\code{\link{tuneParams}()}
}
\concept{tune}
