% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{prophet_plot_components}
\alias{prophet_plot_components}
\title{Plot the components of a prophet forecast.
Prints a ggplot2 with whichever are available of: trend, holidays, weekly
seasonality, yearly seasonality, and additive and multiplicative extra
regressors.}
\usage{
prophet_plot_components(
  m,
  fcst,
  uncertainty = TRUE,
  plot_cap = TRUE,
  weekly_start = 0,
  yearly_start = 0,
  render_plot = TRUE
)
}
\arguments{
\item{m}{Prophet object.}

\item{fcst}{Data frame returned by predict(m, df).}

\item{uncertainty}{Optional boolean indicating if the uncertainty interval should be
plotted for the trend, from fcst columns trend_lower and trend_upper.This will
only be done if m$uncertainty.samples > 0.}

\item{plot_cap}{Boolean indicating if the capacity should be shown in the
figure, if available.}

\item{weekly_start}{Integer specifying the start day of the weekly
seasonality plot. 0 (default) starts the week on Sunday. 1 shifts by 1 day
to Monday, and so on.}

\item{yearly_start}{Integer specifying the start day of the yearly
seasonality plot. 0 (default) starts the year on Jan 1. 1 shifts by 1 day
to Jan 2, and so on.}

\item{render_plot}{Boolean indicating if the plots should be rendered.
Set to FALSE if you want the function to only return the list of panels.}
}
\value{
Invisibly return a list containing the plotted ggplot objects
}
\description{
Plot the components of a prophet forecast.
Prints a ggplot2 with whichever are available of: trend, holidays, weekly
seasonality, yearly seasonality, and additive and multiplicative extra
regressors.
}
