% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{sfc}
\alias{sfc}
\alias{st_sfc}
\alias{sfc_POINT}
\alias{sfc_LINESTRING}
\alias{sfc_POLYGON}
\alias{sfc_MULTIPOINT}
\alias{sfc_MULTILINESTRING}
\alias{sfc_MULTIPOLYGON}
\alias{sfc_GEOMETRYCOLLECTION}
\title{Create simple feature geometry list column}
\usage{
st_sfc(
  ...,
  crs = NA_crs_,
  precision = 0,
  check_ring_dir = FALSE,
  dim,
  recompute_bbox = FALSE
)
}
\arguments{
\item{...}{zero or more simple feature geometries (objects of class \code{sfg}), or a single list of such objects; \code{NULL} values will get replaced by empty geometries.}

\item{crs}{coordinate reference system: integer with the EPSG code, or character with proj4string}

\item{precision}{numeric; see \link{st_as_binary}}

\item{check_ring_dir}{see \link{st_read}}

\item{dim}{character; if this function is called without valid geometries, this argument may carry the right dimension to set empty geometries}

\item{recompute_bbox}{logical; use \code{TRUE} to force recomputation of the bounding box}
}
\value{
an object of class \code{sfc}, which is a classed list-column with simple feature geometries.
}
\description{
Create simple feature geometry list column, set class, and add coordinate reference system and precision
}
\details{
A simple feature geometry list-column is a list of class
\code{c("stc_TYPE", "sfc")} which most often contains objects of identical type;
in case of a mix of types or an empty set, \code{TYPE} is set to the
superclass \code{GEOMETRY}.
}
\examples{
pt1 = st_point(c(0,1))
pt2 = st_point(c(1,1))
(sfc = st_sfc(pt1, pt2))
d = st_sf(data.frame(a=1:2, geom=sfc))
}
