// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DisplayControl.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.display {
  public class DisplayControl_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("display.DisplayControl:1.0.1", null);

    public DisplayControl_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DisplayControl_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DisplayControl_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DisplayControl_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_VALUE = 1;

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.fwAppVersion = this.fwAppVersion;
        copy.fwBootVersion = this.fwBootVersion;
        copy.orientation = this.orientation;
        copy.width = this.width;
        copy.height = this.height;
        copy.versionAvailable = this.versionAvailable;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["fwAppVersion"] = this.fwAppVersion;
        json["fwBootVersion"] = this.fwBootVersion;
        json["orientation"] = this.orientation;
        json["width"] = this.width;
        json["height"] = this.height;
        json["versionAvailable"] = this.versionAvailable;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.fwAppVersion = (int)json["fwAppVersion"];
        inst.fwBootVersion = (int)json["fwBootVersion"];
        inst.orientation = (int)json["orientation"];
        inst.width = (int)json["width"];
        inst.height = (int)json["height"];
        inst.versionAvailable = (bool)json["versionAvailable"];
        return inst;
      }

      public int fwAppVersion = 0;
      public int fwBootVersion = 0;
      public int orientation = 0;
      public int width = 0;
      public int height = 0;
      public bool versionAvailable = false;
    }

    public class DefaultViewItem : ICloneable {
      public object Clone() {
        DefaultViewItem copy = new DefaultViewItem();
        copy.id = this.id;
        copy.description = this.description;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["description"] = this.description;
        return json;
      }

      public static DefaultViewItem Decode(LightJson.JsonObject json, Agent agent) {
        DefaultViewItem inst = new DefaultViewItem();
        inst.id = (string)json["id"];
        inst.description = (string)json["description"];
        return inst;
      }

      public string id = "";
      public string description = "";
    }

    public class DefaultViewChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("display.DisplayControl_1_0_1.DefaultViewChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem newView = new Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem();
    }

    public class GetAvailableDefaultViewsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem> _ret_;
    }

    public GetAvailableDefaultViewsResult getAvailableDefaultViews() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAvailableDefaultViews", _parameters);
      var _ret = new GetAvailableDefaultViewsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAvailableDefaultViews(AsyncRpcResponse<GetAvailableDefaultViewsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAvailableDefaultViews(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAvailableDefaultViews(AsyncRpcResponse<GetAvailableDefaultViewsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAvailableDefaultViews", _parameters,
        _result => {
          try {
            var _ret = new GetAvailableDefaultViewsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.display.DisplayControl_1_0_1.DefaultViewItem.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDefaultViewResult {
      public string _ret_;
    }

    public GetDefaultViewResult getDefaultView() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDefaultView", _parameters);
      var _ret = new GetDefaultViewResult();
      _ret._ret_ = (string)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getDefaultView(AsyncRpcResponse<GetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDefaultView(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDefaultView(AsyncRpcResponse<GetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDefaultView", _parameters,
        _result => {
          try {
            var _ret = new GetDefaultViewResult();
            _ret._ret_ = (string)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetDefaultViewResult {
      public int _ret_;
    }

    public SetDefaultViewResult setDefaultView(string id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("setDefaultView", _parameters);
      var _ret = new SetDefaultViewResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setDefaultView(string id, AsyncRpcResponse<SetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setDefaultView(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setDefaultView(string id, AsyncRpcResponse<SetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setDefaultView", _parameters,
        _result => {
          try {
            var _ret = new SetDefaultViewResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.display.DisplayControl_1_0_1.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.display.DisplayControl_1_0_1.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.display.DisplayControl_1_0_1.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ShowSmileyResult {
    }

    public ShowSmileyResult showSmiley(bool on, bool happy, string msg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["on"] = on;
      _parameters["happy"] = happy;
      _parameters["msg"] = msg;

      var _result = RpcCall("showSmiley", _parameters);
      var _ret = new ShowSmileyResult();
      return _ret;
    }

    public AsyncRequest showSmiley(bool on, bool happy, string msg, AsyncRpcResponse<ShowSmileyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return showSmiley(on, happy, msg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest showSmiley(bool on, bool happy, string msg, AsyncRpcResponse<ShowSmileyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["on"] = on;
        _parameters["happy"] = happy;
        _parameters["msg"] = msg;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("showSmiley", _parameters,
        _result => {
          try {
            var _ret = new ShowSmileyResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
