/*
 * Ensuring smooth padding to limit edge effects from padding and peridiosing.
 * This file is part of ufo-serge filter set.
 * Copyright (C) 2025 Serge Cohen
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Serge Cohen <serge.cohen@cnrs.fr>
 */

__kernel void
smooth_pad(
	   __global float *iImage,
	   __global float *oImage,
	   const uint in_width,
	   const uint out_width,
	   const uint out_offset
	   )
{
  // One processing kernel by row of the image (a sinogram most likely)
  size_t y = get_global_id(0);
  size_t y_off_in = y*in_width;
  size_t y_off_out = y*out_width;

  float padding = (float)(out_width - in_width);
  float val_start = iImage[y_off_in];
  float val_end = iImage[y_off_in + in_width - 1];
  float pad_increment = (val_start-val_end) / padding;

  size_t x_out, x_in;
  float val = val_start - (float)(out_offset) * pad_increment;
  for ( x_out = 0; out_offset != x_out; ++x_out) {
    oImage[x_out + y_off_out] = val;
    val += pad_increment;
  }
  for ( x_in=0; in_width != x_in; ++x_in) {
    oImage[x_out + y_off_out] = iImage[x_in + y_off_in];
    ++x_out;
  }
  val = val_end + pad_increment;
  for ( ; out_width > x_out; ++x_out) {
    oImage[x_out + y_off_out] = val;
    val += pad_increment;
  }
}
