
/*
 * Ekiga -- A VoIP and Video-Conferencing application
 * Copyright (C) 2000-2009 Damien Sandras <dsandras@seconix.com>

 * This program is free software; you can  redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version. This program is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Ekiga is licensed under the GPL license and as a special exception, you
 * have permission to link or otherwise combine this program with the
 * programs OPAL, OpenH323 and PWLIB, and distribute the combination, without
 * applying the requirements of the GNU GPL to the OPAL, OpenH323 and PWLIB
 * programs, as long as you do follow the requirements of the GNU GPL for all
 * the rest of the software thus combined.
 */


/*
 *                         chat-simple.h  -  description
 *                         ------------------------------------------
 *   begin                : written in 2007 by Julien Puydt
 *   copyright            : (c) 2007 by Julien Puydt
 *   description          : declaration of the interface of a chat with a
 *                          single person
 *
 */

#ifndef __CHAT_SIMPLE_H__
#define __CHAT_SIMPLE_H__

#include <boost/smart_ptr.hpp>

#include "chat.h"
#include "presentity.h"

namespace Ekiga
{

  class SimpleChat: public Chat
  {
  public:

    /** The destructor.
     */
    virtual ~SimpleChat ()
    {}

    /** Returns the Presentity associated with the SimpleChat.
     * @return The SimpleChat's Presentity.
     */
    virtual PresentityPtr get_presentity () const = 0;
  };

  typedef boost::shared_ptr<SimpleChat> SimpleChatPtr;
};

#endif
