; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 5
; RUN: opt < %s -passes=amdgpu-sw-lower-lds -S -amdgpu-asan-instrument-lds=false -mtriple=amdgcn-amd-amdhsa | FileCheck %s

; Test to check if LDS accesses in kernels without sanitize_address attribute are not lowered
; if all other kernels don't have sanitize_address attribute.
@lds_1 = internal addrspace(3) global [1 x i8] poison, align 4
@lds_2 = internal addrspace(3) global [1 x i32] poison, align 8

;.
; CHECK: @lds_1 = internal addrspace(3) global [1 x i8] poison, align 4
; CHECK: @lds_2 = internal addrspace(3) global [1 x i32] poison, align 8
;.
define amdgpu_kernel void @k0() {
; CHECK-LABEL: define amdgpu_kernel void @k0() {
; CHECK-NEXT:    store i8 7, ptr addrspace(3) @lds_1, align 4
; CHECK-NEXT:    store i32 8, ptr addrspace(3) @lds_2, align 2
; CHECK-NEXT:    ret void
;
  store i8 7, ptr addrspace(3) @lds_1, align 4
  store i32 8, ptr addrspace(3) @lds_2, align 2
  ret void
}

define amdgpu_kernel void @k1() {
; CHECK-LABEL: define amdgpu_kernel void @k1() {
; CHECK-NEXT:    store i32 9, ptr addrspace(3) @lds_2, align 2
; CHECK-NEXT:    ret void
;
  store i32 9, ptr addrspace(3) @lds_2, align 2
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 4, !"nosanitize_address", i32 1}
;.
; CHECK: [[META0:![0-9]+]] = !{i32 4, !"nosanitize_address", i32 1}
;.
