; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 5
; RUN: opt < %s -passes=rel-lookup-table-converter -relocation-model=pic -S | FileCheck %s
; REQUIRES: nvptx-registered-target
target triple = "nvptx64-nvidia-cuda"

; Do not produce relative lookup table for nvptx target.

@a1 = internal constant i32 0, align 4
@b1 = internal constant i32 0, align 4
@c1 = internal constant i32 0, align 4
@d1 = internal constant i32 0, align 4

@switch.table = private unnamed_addr constant [3 x ptr] [ptr @a1, ptr @b1, ptr @c1], align 8

;.
; CHECK: @a1 = internal constant i32 0, align 4
; CHECK: @b1 = internal constant i32 0, align 4
; CHECK: @c1 = internal constant i32 0, align 4
; CHECK: @d1 = internal constant i32 0, align 4
; CHECK: @switch.table = private unnamed_addr constant [3 x ptr] [ptr @a1, ptr @b1, ptr @c1], align 8
;.
define ptr @internal_linkage(i32 %cond) {
; CHECK-LABEL: define ptr @internal_linkage(
; CHECK-SAME: i32 [[COND:%.*]]) {
; CHECK-NEXT:    [[SWITCH_GEP:%.*]] = getelementptr inbounds [3 x ptr], ptr @switch.table, i32 0, i32 [[COND]]
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = load ptr, ptr [[SWITCH_GEP]], align 8
; CHECK-NEXT:    ret ptr [[RELTABLE_INTRINSIC]]
;
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @switch.table, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  ret ptr %switch.load
}
