This variant of the calc demo uses Menhir with the `--table` and `--unparsing`
options. It illustrates how to construct and print a concrete syntax tree.

The code is organized in the following modules:

* `AST` defines the type of *abstract syntax trees*.

* `Eval` evaluates ASTs.

* `Lexer` and `Parser`,
  whose source code is found in the files `lexer.mll` and `parser.mly`,
  are the lexer and parser.

* `AST2DCST` translates abstract syntax trees to
  *disjunctive concrete syntax trees* (DCSTs).
  This is the first step of the unparsing process.
  DCSTs contain disjunction (choice) nodes that are used to
  indicate where parentheses *may* be legally inserted.

* `Parser.Settle` (which is generated by Menhir) translates DCSTs to
  *concrete syntax trees* (CSTs).
  CSTs do not contain choice nodes.
  Thus, this translation decides where to *actually* insert parentheses.

* `CST2String` translates CSTs to strings in a simple-minded way.
  It takes advantage of the visitor class `Parser.CST.reduce`,
  which is generated by Menhir.

* `CST2Document` translates CSTs to the abstract *documents*
  provided by the `PPrint` library.
  This allows pretty-printing CSTs in various styles and column widths.

* `Calc` is the main program.

To run the program, type `dune exec ./calc.exe` and provide
a well-formed arithmetic expression on the standard input channel.

In the following example, all parentheses are lost when the input text is
converted to an AST. Then, during unparsing, the code produced by Menhir
decides that parentheses are needed around the subexpression `1 + 2 * 10` and
are not needed elsewhere.

```
$ more test00.in
(1 + (2 * 10)) * 2
$ dune exec ./calc.exe < test00.in
This expression evaluates to 42
This expression is printed as follows:
( 1 + 2 * 10 ) * 2
This expression is pretty-printed in 10 columns as follows:
( 1 +
  2 * 10
) *
2
This expression is pretty-printed in 20 columns as follows:
(1 + 2 * 10) * 2
```
