/* Description of s390 insn formats.  */
/* NAME   F1,          F2... */
F0(E)
F1(I,     I(1, 8, 8))
F2(RI_a,  R(1, 8),     I(2,16,16))
F2(RI_b,  R(1, 8),     I(2,16,16))
F2(RI_c,  M(1, 8),     I(2,16,16))
F3(RIE_a, R(1, 8),     I(2,16,16),  M(3,32))
F4(RIE_b, R(1, 8),     R(2,12),     M(3,32),   I(4,16,16))
F4(RIE_c, R(1, 8),     I(2,32, 8),  M(3,12),   I(4,16,16))
F3(RIE_d, R(1, 8),     I(2,16,16),  R(3,12))
F3(RIE_e, R(1, 8),     I(2,16,16),  R(3,12))
F5(RIE_f, R(1, 8),     R(2,12),     I(3,16,8), I(4,24,8),  I(5,32,8))
F3(RIE_g, R(1, 8),     I(2,16,16),  M(3,12))
F2(RIL_a, R(1, 8),     I(2,16,32))
F2(RIL_b, R(1, 8),     I(2,16,32))
F2(RIL_c, M(1, 8),     I(2,16,32))
F4(RIS,   R(1, 8),     I(2,32, 8),  M(3,12),   BD(4,16,20))
/* ??? The PoO does not call out subtypes _a and _b for RR, as it does
   for e.g. RX.  Our checking requires this for e.g. BCR.  */
F2(RR_a,  R(1, 8),     R(2,12))
F2(RR_b,  M(1, 8),     R(2,12))
F2(RRE,   R(1,24),     R(2,28))
F3(RRD,   R(1,16),     R(2,28),     R(3,24))
F4(RRF_a, R(1,24),     R(2,28),     R(3,16),   M(4,20))
F4(RRF_b, R(1,24),     R(2,28),     R(3,16),   M(4,20))
F4(RRF_c, R(1,24),     R(2,28),     M(3,16),   M(4,20))
F4(RRF_d, R(1,24),     R(2,28),     M(3,16),   M(4,20))
F4(RRF_e, R(1,24),     R(2,28),     M(3,16),   M(4,20))
F4(RRS,   R(1, 8),     R(2,12),     M(3,32),   BD(4,16,20))
F3(RS_a,  R(1, 8),     BD(2,16,20), R(3,12))
F3(RS_b,  R(1, 8),     BD(2,16,20), M(3,12))
F3(RSI,   R(1, 8),     I(2,16,16),  R(3,12))
F2(RSL,   L(1, 8, 4),  BD(1,16,20))
F3(RSY_a, R(1, 8),     BDL(2),      R(3,12))
F3(RSY_b, R(1, 8),     BDL(2),      M(3,12))
F2(RX_a,  R(1, 8),     BXD(2))
F2(RX_b,  M(1, 8),     BXD(2))
F3(RXE,   R(1, 8),     BXD(2),      M(3,32))
F3(RXF,   R(1,32),     BXD(2),      R(3, 8))
F2(RXY_a, R(1, 8),     BXDL(2))
F2(RXY_b, M(1, 8),     BXDL(2))
F1(S,     BD(2,16,20))
F2(SI,    BD(1,16,20), I(2,8,8))
F2(SIL,   BD(1,16,20), I(2,32,16))
F2(SIY,   BDL(1),      I(2, 8, 8))
F3(SS_a,  L(1, 8, 8),  BD(1,16,20), BD(2,32,36))
F4(SS_b,  L(1, 8, 4),  BD(1,16,20), L(2,12,4),   BD(2,32,36))
F4(SS_c,  L(1, 8, 4),  BD(1,16,20), BD(2,32,36), I(3,12, 4))
/* ??? Odd man out.  The L1 field here is really a register, but the
   easy way to compress the fields has R1 and B1 overlap.  */
F4(SS_d,  L(1, 8, 4),  BD(1,16,20), BD(2,32,36), R(3,12))
F4(SS_e,  R(1, 8),     BD(2,16,20), R(3,12),     BD(4,32,36))
F3(SS_f,  BD(1,16,20), L(2,8,8),    BD(2,32,36))
F2(SSE,   BD(1,16,20), BD(2,32,36))
F3(SSF,   BD(1,16,20), BD(2,32,36), R(3,8))
F3(VRI_a, V(1,8),      I(2,16,16),  M(3,32))
F4(VRI_b, V(1,8),      I(2,16,8),   I(3,24,8),   M(4,32))
F4(VRI_c, V(1,8),      V(3,12),     I(2,16,16),  M(4,32))
F5(VRI_d, V(1,8),      V(2,12),     V(3,16),     I(4,24,8),   M(5,32))
F5(VRI_e, V(1,8),      V(2,12),     I(3,16,12),  M(5,28),     M(4,32))
F5(VRI_f, V(1,8),      V(2,12),     V(3,16),     M(5,24),     I(4,28,8))
F5(VRI_g, V(1,8),      V(2,12),     I(4,16,8),   M(5,24),     I(3,28,8))
F3(VRI_h, V(1,8),      I(2,16,16),  I(3,32,4))
F4(VRI_i, V(1,8),      R(2,12),     M(4,24),     I(3,28,8))
F5(VRR_a, V(1,8),      V(2,12),     M(5,24),     M(4,28),     M(3,32))
F5(VRR_b, V(1,8),      V(2,12),     V(3,16),     M(5,24),     M(4,32))
F6(VRR_c, V(1,8),      V(2,12),     V(3,16),     M(6,24),     M(5,28),  M(4,32))
F6(VRR_d, V(1,8),      V(2,12),     V(3,16),     M(5,20),     M(6,24),  V(4,32))
F6(VRR_e, V(1,8),      V(2,12),     V(3,16),     M(6,20),     M(5,28),  V(4,32))
F3(VRR_f, V(1,8),      R(2,12),     R(3,16))
F1(VRR_g, V(1,12))
F3(VRR_h, V(1,12),     V(2,16),     M(3,24))
F3(VRR_i, R(1,8),      V(2,12),     M(3,24))
F4(VRS_a, V(1,8),      V(3,12),     BD(2,16,20), M(4,32))
F4(VRS_b, V(1,8),      R(3,12),     BD(2,16,20), M(4,32))
F4(VRS_c, R(1,8),      V(3,12),     BD(2,16,20), M(4,32))
F3(VRS_d, R(3,12),     BD(2,16,20), V(1,32))
F4(VRV,   V(1,8),      V(2,12),     BD(2,16,20), M(3,32))
F3(VRX,   V(1,8),      BXD(2),      M(3,32))
F3(VSI,   I(3,8,8),    BD(2,16,20), V(1,32))
