#
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################
"""
The arg spec for the ios_l3_interfaces module
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


class L3_InterfacesArgs(object):
    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "ipv4": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "address": {"type": "str"},
                        "secondary": {"type": "bool"},
                    },
                },
                "ipv6": {
                    "elements": "dict",
                    "type": "list",
                    "options": {"address": {"type": "str"}},
                },
                "carrier_delay": {
                    "type": "dict",
                    "options": {
                        "up": {"type": "int"},
                        "down": {"type": "int"},
                    },
                },
                "dampening": {
                    "type": "dict",
                    "options": {
                        "enabled": {"type": "bool"},
                        "half_life": {"type": "int"},
                        "reuse_threshold": {"type": "int"},
                        "suppress_threshold": {"type": "int"},
                        "max_suppress_time": {"type": "int"},
                        "restart_penalty": {"type": "int"},
                    },
                },
                "load_interval": {"type": "int"},
                "flow_control": {
                    "type": "str",
                    "choices": ["ingress", "egress", "bidirectional"],
                },
                "flow": {
                    "type": "dict",
                    "options": {
                        "ipv4": {
                            "type": "dict",
                            "options": {
                                "monitor": {"type": "str"},
                                "sampler": {"type": "str"},
                                "direction": {"type": "str", "choices": ["ingress", "egress"]},
                            },
                        },
                        "ipv6": {
                            "type": "dict",
                            "options": {
                                "monitor": {"type": "str"},
                                "sampler": {"type": "str"},
                                "direction": {"type": "str", "choices": ["ingress", "egress"]},
                            },
                        },
                    },
                },
            },
            "type": "list",
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }
