// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/*****************************************************************************/
#ifndef SIMD_AS_HWINTRINSIC
#error Define SIMD_AS_HWINTRINSIC before including this file
#endif

#if defined(SIMD_AS_HWINTRINSIC_ID) || defined(SIMD_AS_HWINTRINSIC_NM)
#error SIMD_AS_HWINTRINSIC_ID and SIMD_AS_HWINTRINSIC_NM should not be defined before including this file
#endif
/*****************************************************************************/

// clang-format off

#ifdef FEATURE_HW_INTRINSICS

// Defines a SimdAsHWIntrinsic where the name is implicitly taken from the id
#define SIMD_AS_HWINTRINSIC_ID(classId, id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                      \
    SIMD_AS_HWINTRINSIC(classId, id, #id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

// Defines a SimdAsHWIntrinsic where the name is explicit
#define SIMD_AS_HWINTRINSIC_NM(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                \
    SIMD_AS_HWINTRINSIC(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

/* Note
    * Each intrinsic has a unique Intrinsic ID with type of `enum NamedIntrinsic`
    * Each intrinsic has a `NumArg` for number of parameters
    * Each intrinsic has 10 `NamedIntrinsic` fields that list the HWIntrinsic that should be generated based-on the base type
        * NI_Illegal is used to represent an unsupported type
        * Using the same Intrinsic ID as the represented entry is used to indicate special handling is required
    * Each intrinsic has one or more flags with type of `enum SimdAsHWIntrinsicFlag`
*/

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector<T> Intrinsics
SIMD_AS_HWINTRINSIC_ID(VectorT,     Abs,                                                    1,         {NI_VectorT_Abs,                                NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs,                                 NI_VectorT_Abs},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AndNot,                                                 2,         {NI_VectorT_AndNot,                             NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot,                              NI_VectorT_AndNot},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     As,                                                     1,         {NI_VectorT_As,                                 NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As,                                  NI_VectorT_As},                                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorByte,                                           1,         {NI_VectorT_AsVectorByte,                       NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte,                        NI_VectorT_AsVectorByte},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorDouble,                                         1,         {NI_VectorT_AsVectorDouble,                     NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble,                      NI_VectorT_AsVectorDouble},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorInt16,                                          1,         {NI_VectorT_AsVectorInt16,                      NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16,                       NI_VectorT_AsVectorInt16},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorInt32,                                          1,         {NI_VectorT_AsVectorInt32,                      NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32,                       NI_VectorT_AsVectorInt32},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorInt64,                                          1,         {NI_VectorT_AsVectorInt64,                      NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64,                       NI_VectorT_AsVectorInt64},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorNInt,                                           1,         {NI_VectorT_AsVectorNInt,                       NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt,                        NI_VectorT_AsVectorNInt},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorNUInt,                                          1,         {NI_VectorT_AsVectorNUInt,                      NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt,                       NI_VectorT_AsVectorNUInt},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorSByte,                                          1,         {NI_VectorT_AsVectorSByte,                      NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte,                       NI_VectorT_AsVectorSByte},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorSingle,                                         1,         {NI_VectorT_AsVectorSingle,                     NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle,                      NI_VectorT_AsVectorSingle},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorUInt16,                                         1,         {NI_VectorT_AsVectorUInt16,                     NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16,                      NI_VectorT_AsVectorUInt16},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorUInt32,                                         1,         {NI_VectorT_AsVectorUInt32,                     NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32,                      NI_VectorT_AsVectorUInt32},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     AsVectorUInt64,                                         1,         {NI_VectorT_AsVectorUInt64,                     NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64,                      NI_VectorT_AsVectorUInt64},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Ceiling,                                                1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_Ceiling,                             NI_VectorT_Ceiling},                            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConditionalSelect,                                      3,         {NI_VectorT_ConditionalSelect,                  NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect,                   NI_VectorT_ConditionalSelect},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToDouble,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToDouble,                     NI_VectorT_ConvertToDouble,                     NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToInt32,                                         1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToInt32,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToInt32Native,                                   1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToInt32Native,                NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToInt64,                                         1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToInt64},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToInt64Native,                                   1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToInt64Native},               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToSingle,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToSingle,                     NI_VectorT_ConvertToSingle,                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToUInt32,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToUInt32,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToUInt32Native,                                  1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToUInt32Native,               NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToUInt64,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToUInt64},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ConvertToUInt64Native,                                  1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_ConvertToUInt64Native},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Create,                                                 1,         {NI_VectorT_Create,                             NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create,                              NI_VectorT_Create},                             SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT,     CreateSequence,                                         2,         {NI_VectorT_CreateSequence,                     NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence,                      NI_VectorT_CreateSequence},                     SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Dot,                                                    2,         {NI_VectorT_Dot,                                NI_VectorT_Dot,                                 NI_VectorT_Dot,                                 NI_VectorT_Dot,                                 NI_VectorT_Dot,                                 NI_VectorT_Dot,                                 NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_Dot,                                 NI_VectorT_Dot},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Equals,                                                 2,         {NI_VectorT_Equals,                             NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals,                              NI_VectorT_Equals},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     EqualsAny,                                              2,         {NI_VectorT_EqualsAny,                          NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny,                           NI_VectorT_EqualsAny},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Floor,                                                  1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_Floor,                               NI_VectorT_Floor},                              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     FusedMultiplyAdd,                                       3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_FusedMultiplyAdd,                    NI_VectorT_FusedMultiplyAdd},                   SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::SpillSideEffectsOp2)
SIMD_AS_HWINTRINSIC_ID(VectorT,     get_AllBitsSet,                                         0,         {NI_VectorT_get_AllBitsSet,                     NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet,                      NI_VectorT_get_AllBitsSet},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     get_Indices,                                            0,         {NI_VectorT_get_Indices,                        NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices,                         NI_VectorT_get_Indices},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     get_One,                                                0,         {NI_VectorT_get_One,                            NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One,                             NI_VectorT_get_One},                            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     get_Zero,                                               0,         {NI_VectorT_get_Zero,                           NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero,                            NI_VectorT_get_Zero},                           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GetElement,                                             2,         {NI_VectorT_GetElement,                         NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement,                          NI_VectorT_GetElement},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GreaterThan,                                            2,         {NI_VectorT_GreaterThan,                        NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan,                         NI_VectorT_GreaterThan},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GreaterThanAll,                                         2,         {NI_VectorT_GreaterThanAll,                     NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll,                      NI_VectorT_GreaterThanAll},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GreaterThanAny,                                         2,         {NI_VectorT_GreaterThanAny,                     NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny,                      NI_VectorT_GreaterThanAny},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GreaterThanOrEqual,                                     2,         {NI_VectorT_GreaterThanOrEqual,                 NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual,                  NI_VectorT_GreaterThanOrEqual},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GreaterThanOrEqualAll,                                  2,         {NI_VectorT_GreaterThanOrEqualAll,              NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll,               NI_VectorT_GreaterThanOrEqualAll},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     GreaterThanOrEqualAny,                                  2,         {NI_VectorT_GreaterThanOrEqualAny,              NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny,               NI_VectorT_GreaterThanOrEqualAny},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     IsNaN,                                                  1,         {NI_VectorT_IsNaN,                              NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN,                               NI_VectorT_IsNaN},                              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     IsNegative,                                             1,         {NI_VectorT_IsNegative,                         NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative,                          NI_VectorT_IsNegative},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     IsPositive,                                             1,         {NI_VectorT_IsPositive,                         NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive,                          NI_VectorT_IsPositive},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     IsPositiveInfinity,                                     1,         {NI_VectorT_IsPositiveInfinity,                 NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity,                  NI_VectorT_IsPositiveInfinity},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     IsZero,                                                 1,         {NI_VectorT_IsZero,                             NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero,                              NI_VectorT_IsZero},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LessThan,                                               2,         {NI_VectorT_LessThan,                           NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan,                            NI_VectorT_LessThan},                           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LessThanAll,                                            2,         {NI_VectorT_LessThanAll,                        NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll,                         NI_VectorT_LessThanAll},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LessThanAny,                                            2,         {NI_VectorT_LessThanAny,                        NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny,                         NI_VectorT_LessThanAny},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LessThanOrEqual,                                        2,         {NI_VectorT_LessThanOrEqual,                    NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual,                     NI_VectorT_LessThanOrEqual},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LessThanOrEqualAll,                                     2,         {NI_VectorT_LessThanOrEqualAll,                 NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll,                  NI_VectorT_LessThanOrEqualAll},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LessThanOrEqualAny,                                     2,         {NI_VectorT_LessThanOrEqualAny,                 NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny,                  NI_VectorT_LessThanOrEqualAny},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LoadAligned,                                            1,         {NI_VectorT_LoadAligned,                        NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned,                         NI_VectorT_LoadAligned},                        SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LoadAlignedNonTemporal,                                 1,         {NI_VectorT_LoadAlignedNonTemporal,             NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal,              NI_VectorT_LoadAlignedNonTemporal},             SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT,     LoadUnsafe,                                             1,         {NI_VectorT_LoadUnsafe,                         NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe,                          NI_VectorT_LoadUnsafe},                         SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_NM(VectorT,     LoadUnsafeIndex,            "LoadUnsafe",               2,         {NI_VectorT_LoadUnsafeIndex,                    NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex,                     NI_VectorT_LoadUnsafeIndex},                    SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Max,                                                    2,         {NI_VectorT_Max,                                NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max,                                 NI_VectorT_Max},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     MaxNative,                                              2,         {NI_VectorT_MaxNative,                          NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative,                           NI_VectorT_MaxNative},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Min,                                                    2,         {NI_VectorT_Min,                                NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min,                                 NI_VectorT_Min},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     MinNative,                                              2,         {NI_VectorT_MinNative,                          NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative,                           NI_VectorT_MinNative},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     MultiplyAddEstimate,                                    3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_MultiplyAddEstimate,                 NI_VectorT_MultiplyAddEstimate},                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Narrow,                                                 2,         {NI_VectorT_Narrow,                             NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow,                              NI_VectorT_Narrow},                             SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Addition,                                            2,         {NI_VectorT_op_Addition,                        NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition,                         NI_VectorT_op_Addition},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_BitwiseAnd,                                          2,         {NI_VectorT_op_BitwiseAnd,                      NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd,                       NI_VectorT_op_BitwiseAnd},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_BitwiseOr,                                           2,         {NI_VectorT_op_BitwiseOr,                       NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr,                        NI_VectorT_op_BitwiseOr},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_op_Division,                         NI_VectorT_op_Division},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Equality,                                            2,         {NI_VectorT_op_Equality,                        NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality,                         NI_VectorT_op_Equality},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_ExclusiveOr,                                         2,         {NI_VectorT_op_ExclusiveOr,                     NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr,                      NI_VectorT_op_ExclusiveOr},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Explicit,                                            1,         {NI_VectorT_op_Explicit,                        NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit,                         NI_VectorT_op_Explicit},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Inequality,                                          2,         {NI_VectorT_op_Inequality,                      NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality,                       NI_VectorT_op_Inequality},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_LeftShift,                                           2,         {NI_VectorT_op_LeftShift,                       NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift,                        NI_VectorT_op_LeftShift},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Multiply,                                            2,         {NI_VectorT_op_Multiply,                        NI_VectorT_op_Multiply,                         NI_VectorT_op_Multiply,                         NI_VectorT_op_Multiply,                         NI_VectorT_op_Multiply,                         NI_VectorT_op_Multiply,                         NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_op_Multiply,                         NI_VectorT_op_Multiply},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_OnesComplement,                                      1,         {NI_VectorT_op_OnesComplement,                  NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement,                   NI_VectorT_op_OnesComplement},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_RightShift,                                          2,         {NI_VectorT_op_RightShift,                      NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift,                       NI_VectorT_op_RightShift},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_Subtraction,                                         2,         {NI_VectorT_op_Subtraction,                     NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction,                      NI_VectorT_op_Subtraction},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_UnaryNegation,                                       1,         {NI_VectorT_op_UnaryNegation,                   NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation,                    NI_VectorT_op_UnaryNegation},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_UnaryPlus,                                           1,         {NI_VectorT_op_UnaryPlus,                       NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus,                        NI_VectorT_op_UnaryPlus},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     op_UnsignedRightShift,                                  2,         {NI_VectorT_op_UnsignedRightShift,              NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift,               NI_VectorT_op_UnsignedRightShift},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT,     Sqrt,                       "SquareRoot",               1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT_Sqrt,                                NI_VectorT_Sqrt},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     StoreAligned,                                           2,         {NI_VectorT_StoreAligned,                       NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned,                        NI_VectorT_StoreAligned},                       SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT,     StoreAlignedNonTemporal,                                2,         {NI_VectorT_StoreAlignedNonTemporal,            NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal,             NI_VectorT_StoreAlignedNonTemporal},            SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT,     StoreUnsafe,                                            2,         {NI_VectorT_StoreUnsafe,                        NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe,                         NI_VectorT_StoreUnsafe},                        SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(VectorT,     StoreUnsafeIndex,           "StoreUnsafe",              3,         {NI_VectorT_StoreUnsafeIndex,                   NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex,                    NI_VectorT_StoreUnsafeIndex},                   SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT,     Sum,                                                    1,         {NI_VectorT_Sum,                                NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum,                                 NI_VectorT_Sum},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     ToScalar,                                               1,         {NI_VectorT_ToScalar,                           NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar,                            NI_VectorT_ToScalar},                           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     WidenLower,                                             1,         {NI_VectorT_WidenLower,                         NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower,                          NI_VectorT_WidenLower},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     WidenUpper,                                             1,         {NI_VectorT_WidenUpper,                         NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper,                          NI_VectorT_WidenUpper},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT,     WithElement,                                            3,         {NI_VectorT_WithElement,                        NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement,                         NI_VectorT_WithElement},                        SimdAsHWIntrinsicFlag::None)

#undef SIMD_AS_HWINTRINSIC_NM
#undef SIMD_AS_HWINTRINSIC_ID

#endif // FEATURE_HW_INTRINSICS

#undef SIMD_AS_HWINTRINSIC

// clang-format on
