/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.core.Cacher;
import org.chefproject.core.Event;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.MemoryService;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.StringUtil;

public class Cache
implements Runnable,
Cacher,
Observer {
    protected Map m_map = null;
    protected CacheRefresher m_refresher = null;
    protected String m_resourcePattern = null;
    protected long m_refresherSleep = 60L;
    protected boolean m_disabled = false;
    protected boolean m_complete = false;
    protected Set m_partiallyComplete = new HashSet();
    protected boolean m_holdEventProcessing = false;
    protected List m_heldEvents = new Vector();
    protected Thread m_thread = null;
    protected boolean m_threadStop = false;

    public Cache() {
        this.m_map = new HashMap();
        MemoryService.registerCacher(this);
    }

    public Cache(CacheRefresher refresher, String pattern) {
        this();
        this.m_refresher = refresher;
        this.m_resourcePattern = pattern;
        if (pattern != null) {
            EventTrackingService.addPriorityObserver(this);
        }
    }

    public Cache(CacheRefresher refresher, long sleep) {
        this();
        this.m_refresherSleep = sleep;
        if (refresher != null) {
            this.m_refresher = refresher;
            this.start();
        }
    }

    protected void finalize() {
        MemoryService.unregisterCacher(this);
        EventTrackingService.deleteObserver(this);
        this.stop();
    }

    public synchronized void put(Object key, Object payload, int duration) {
        if (this.disabled()) {
            return;
        }
        this.m_map.put(key, new CacheEntry(payload, duration));
    }

    public synchronized void put(Object key, Object payload) {
        this.put(key, payload, 0);
    }

    public synchronized boolean containsKeyExpiredOrNot(Object key) {
        if (this.disabled()) {
            return false;
        }
        return this.m_map.containsKey(key);
    }

    public synchronized boolean containsKey(Object key) {
        if (this.disabled()) {
            return false;
        }
        if (this.m_map.containsKey(key)) {
            CacheEntry entry = (CacheEntry)this.m_map.get(key);
            if (entry.hasExpired()) {
                this.m_map.remove(key);
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized void expire(Object key) {
        if (this.disabled()) {
            return;
        }
        if (this.m_map.containsKey(key)) {
            this.m_map.remove(key);
        }
    }

    public synchronized Object getExpiredOrNot(Object key) {
        if (this.disabled()) {
            return null;
        }
        if (this.m_map.containsKey(key)) {
            CacheEntry entry = (CacheEntry)this.m_map.get(key);
            return entry.getPayload();
        }
        return null;
    }

    public synchronized Object get(Object key) {
        if (this.disabled()) {
            return null;
        }
        if (this.m_map.containsKey(key)) {
            CacheEntry entry = (CacheEntry)this.m_map.get(key);
            if (entry.hasExpired()) {
                this.m_map.remove(key);
                return null;
            }
            return entry.getPayload();
        }
        return null;
    }

    public synchronized List getAll() {
        Vector<Object> rv = new Vector<Object>();
        if (this.disabled()) {
            return rv;
        }
        if (this.m_map.isEmpty()) {
            return rv;
        }
        Object[] keys = this.m_map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Object payload;
            CacheEntry entry = (CacheEntry)this.m_map.get(keys[i]);
            if (!entry.hasExpired() && (payload = entry.getPayload()) != null) {
                rv.add(payload);
            }
            ++i;
        }
        return rv;
    }

    public synchronized List getAll(String path) {
        Vector<Object> rv = new Vector<Object>();
        if (this.disabled()) {
            return rv;
        }
        if (this.m_map.isEmpty()) {
            return rv;
        }
        Object[] keys = this.m_map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String keyPath;
            Object payload;
            CacheEntry entry = (CacheEntry)this.m_map.get(keys[i]);
            if (!entry.hasExpired() && (payload = entry.getPayload()) != null && (keyPath = StringUtil.referencePath((String)keys[i])).equals(path)) {
                rv.add(payload);
            }
            ++i;
        }
        return rv;
    }

    public List getKeys() {
        Vector rv = new Vector();
        rv.addAll(this.m_map.keySet());
        return rv;
    }

    public List getIds() {
        Vector<String> rv = new Vector<String>();
        Vector keys = new Vector();
        keys.addAll(this.m_map.keySet());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int i = key.indexOf(this.m_resourcePattern);
            if (i != -1) {
                key = key.substring(i + this.m_resourcePattern.length());
            }
            rv.add(key);
        }
        return rv;
    }

    public synchronized void clear() {
        this.m_map.clear();
        this.m_complete = false;
        this.m_partiallyComplete.clear();
    }

    public synchronized void remove(Object key) {
        if (this.disabled()) {
            return;
        }
        this.m_map.remove(key);
    }

    public void disable() {
        this.m_disabled = true;
        EventTrackingService.deleteObserver(this);
        this.clear();
    }

    public void enable() {
        this.m_disabled = false;
        if (this.m_resourcePattern != null) {
            EventTrackingService.addPriorityObserver(this);
        }
    }

    public boolean disabled() {
        return this.m_disabled;
    }

    public boolean isComplete() {
        if (this.disabled()) {
            return false;
        }
        return this.m_complete;
    }

    public void setComplete() {
        if (this.disabled()) {
            return;
        }
        this.m_complete = true;
    }

    public boolean isComplete(String path) {
        return this.m_partiallyComplete.contains(path);
    }

    public void setComplete(String path) {
        this.m_partiallyComplete.add(path);
    }

    public synchronized void holdEvents() {
        this.m_holdEventProcessing = true;
    }

    public synchronized void processEvents() {
        this.m_holdEventProcessing = false;
        int i = 0;
        while (i < this.m_heldEvents.size()) {
            Event event = (Event)this.m_heldEvents.get(i);
            this.continueUpdate(event);
            ++i;
        }
        this.m_heldEvents.clear();
    }

    public void resetCache() {
        this.clear();
    }

    protected void start() {
        this.m_threadStop = false;
        this.m_thread = new Thread((Runnable)this, this.getClass().getName());
        this.m_thread.setDaemon(true);
        this.m_thread.setPriority(3);
        this.m_thread.start();
    }

    protected void stop() {
        if (this.m_thread == null) {
            return;
        }
        this.m_threadStop = true;
        this.m_thread.interrupt();
        this.m_thread = null;
    }

    public void run() {
        while (!this.m_threadStop && !Thread.currentThread().isInterrupted()) {
            long startTime = 0L;
            try {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    Log.debug("chef", this + ".checking ...");
                }
                if (!this.m_map.isEmpty()) {
                    Object[] keys = this.m_map.keySet().toArray();
                    int i = 0;
                    while (i < keys.length) {
                        CacheEntry entry = (CacheEntry)this.m_map.get(keys[i]);
                        if (entry.hasExpired()) {
                            Object newValue = this.m_refresher.refresh(keys[i], entry.getPayload(), null);
                            if (newValue != null) {
                                this.put(keys[i], newValue, entry.getDuration());
                            } else {
                                this.remove(keys[i]);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".done. Time: " + (System.currentTimeMillis() - startTime));
            }
            try {
                Thread.sleep(this.m_refresherSleep * 1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void update(Observable o, Object arg) {
        if (this.disabled()) {
            return;
        }
        if (!(arg instanceof Event)) {
            return;
        }
        Event event = (Event)arg;
        if (!event.getModify()) {
            return;
        }
        String key = event.getResource();
        if (!key.startsWith(this.m_resourcePattern)) {
            return;
        }
        if (this.m_holdEventProcessing) {
            this.m_heldEvents.add(event);
            return;
        }
        this.continueUpdate(event);
    }

    protected void continueUpdate(Event event) {
        String path;
        String key = event.getResource();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".update() [" + this.m_resourcePattern + "] resource: " + key + " event: " + event.getEvent());
        }
        Object oldValue = this.get(key);
        if (this.m_map.containsKey(key)) {
            this.remove(key);
        }
        if (this.m_complete) {
            if (this.m_refresher != null) {
                Object value = this.m_refresher.refresh(key, oldValue, event);
                if (value != null) {
                    this.put(key, value);
                }
            } else {
                this.m_complete = false;
            }
        } else if (!this.m_partiallyComplete.isEmpty() && this.m_partiallyComplete.contains(path = StringUtil.referencePath(key))) {
            if (this.m_refresher != null) {
                Object value = this.m_refresher.refresh(key, oldValue, event);
                if (value != null) {
                    this.put(key, value);
                }
            } else {
                this.m_partiallyComplete.remove(path);
            }
        }
    }

    protected class CacheEntry {
        protected long m_expires = 0L;
        protected Object m_payload = null;
        protected int m_duration = 0;

        public CacheEntry(Object payload, int duration) {
            this.m_payload = payload;
            this.m_duration = duration;
            if (this.m_duration > 0) {
                this.m_expires = System.currentTimeMillis() + (long)(duration * 1000);
            }
        }

        public Object getPayload() {
            return this.m_payload;
        }

        public boolean hasExpired() {
            return this.m_duration > 0 ? System.currentTimeMillis() > this.m_expires : false;
        }

        public int getDuration() {
            return this.m_duration;
        }
    }
}

