/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.ivy.core.cache.ModuleDescriptorMemoryCache$CacheEntry;
import org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.Message;

final class ModuleDescriptorMemoryCache {
    private final int maxSize;
    private final LinkedHashMap valueMap = new LinkedHashMap(150);

    public ModuleDescriptorMemoryCache() {
        this.maxSize = 150;
    }

    public final ModuleDescriptor get(File file2, ParserSettings parserSettings, boolean bl, ModuleDescriptorProvider moduleDescriptorProvider) {
        ModuleDescriptor moduleDescriptor;
        ModuleDescriptor moduleDescriptor2;
        ParserSettings parserSettings2 = parserSettings;
        File file3 = file2;
        ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = this;
        if (moduleDescriptorMemoryCache.maxSize <= 0) {
            moduleDescriptor2 = null;
        } else {
            ModuleDescriptorMemoryCache$CacheEntry moduleDescriptorMemoryCache$CacheEntry = (ModuleDescriptorMemoryCache$CacheEntry)moduleDescriptorMemoryCache.valueMap.get(file3);
            if (moduleDescriptorMemoryCache$CacheEntry != null) {
                if (moduleDescriptorMemoryCache$CacheEntry.isStale(bl, parserSettings2)) {
                    Message.debug("Entry is found in the ModuleDescriptorCache but entry should be reevaluated : " + file3);
                    moduleDescriptorMemoryCache.valueMap.remove(file3);
                    moduleDescriptor2 = null;
                } else {
                    moduleDescriptorMemoryCache.valueMap.remove(file3);
                    moduleDescriptorMemoryCache.valueMap.put(file3, moduleDescriptorMemoryCache$CacheEntry);
                    Message.debug("Entry is found in the ModuleDescriptorCache : " + file3);
                    moduleDescriptor2 = ModuleDescriptorMemoryCache$CacheEntry.access$000(moduleDescriptorMemoryCache$CacheEntry);
                }
            } else {
                Message.debug("No entry is found in the ModuleDescriptorCache : " + file3);
                moduleDescriptor2 = moduleDescriptor = null;
            }
        }
        if (moduleDescriptor2 == null) {
            moduleDescriptor = this.getStale(file2, parserSettings, bl, moduleDescriptorProvider);
        }
        return moduleDescriptor;
    }

    public final ModuleDescriptor getStale(File file2, ParserSettings parserSettings, boolean bl, ModuleDescriptorProvider moduleDescriptorProvider) {
        ParserSettingsMonitor parserSettingsMonitor = new ParserSettingsMonitor(parserSettings);
        ModuleDescriptor moduleDescriptor = moduleDescriptorProvider.provideModule$6172736d(file2, bl);
        this.putInCache(file2, parserSettingsMonitor, bl, moduleDescriptor);
        return moduleDescriptor;
    }

    final void putInCache(File file2, ParserSettingsMonitor parserSettingsMonitor, boolean bl, ModuleDescriptor moduleDescriptor) {
        if (this.maxSize <= 0) {
            return;
        }
        if (this.valueMap.size() >= this.maxSize) {
            Message.debug("ModuleDescriptorCache is full, remove one entry");
            Iterator iterator = this.valueMap.values().iterator();
            iterator.next();
            iterator.remove();
        }
        this.valueMap.put(file2, new ModuleDescriptorMemoryCache$CacheEntry(moduleDescriptor, bl, parserSettingsMonitor));
    }
}

