## TFSA-2021-173: Segfault due to negative splits in `SplitV`

### CVE Number
CVE-2021-41222

### Impact
The [implementation](https://github.com/tensorflow/tensorflow/blob/e71b86d47f8bc1816bf54d7bddc4170e47670b97/tensorflow/core/kernels/split_v_op.cc#L49-L205) of `SplitV` can trigger a segfault is an attacker supplies negative arguments:

```python
import tensorflow as tf

tf.raw_ops.SplitV(
  value=tf.constant([]),
  size_splits=[-1, -2]
  ,axis=0,
  num_split=2)
```

This occurs whenever `size_splits` contains more than one value and at least one value is negative.

### Patches
We have patched the issue in GitHub commit [25d622ffc432acc736b14ca3904177579e733cc6](https://github.com/tensorflow/tensorflow/commit/25d622ffc432acc736b14ca3904177579e733cc6).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
