; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs -tail-predication=enabled -o - %s | FileCheck %s

define arm_aapcs_vfpcc void @uadd_sat(ptr noalias nocapture readonly %pSrcA, ptr noalias nocapture readonly %pSrcB, ptr noalias nocapture %pDst, i32 %blockSize) {
; CHECK-LABEL: uadd_sat:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    it eq
; CHECK-NEXT:    popeq {r7, pc}
; CHECK-NEXT:  .LBB0_1: @ %vector.ph
; CHECK-NEXT:    dlstp.16 lr, r3
; CHECK-NEXT:  .LBB0_2: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrh.u16 q0, [r1], #16
; CHECK-NEXT:    vldrh.u16 q1, [r0], #16
; CHECK-NEXT:    vqadd.u16 q0, q1, q0
; CHECK-NEXT:    vstrh.16 q0, [r2], #16
; CHECK-NEXT:    letp lr, .LBB0_2
; CHECK-NEXT:  @ %bb.3: @ %while.end
; CHECK-NEXT:    pop {r7, pc}
entry:
  %cmp7 = icmp eq i32 %blockSize, 0
  br i1 %cmp7, label %while.end, label %vector.ph

vector.ph:                                        ; preds = %entry
  %n.rnd.up = add i32 %blockSize, 7
  %n.vec = and i32 %n.rnd.up, -8
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %vector.ph
  %index = phi i32 [ 0, %vector.ph ], [ %index.next, %vector.body ]
  %next.gep = getelementptr i16, ptr %pSrcA, i32 %index
  %next.gep20 = getelementptr i16, ptr %pDst, i32 %index
  %next.gep21 = getelementptr i16, ptr %pSrcB, i32 %index
  %active.lane.mask = call <8 x i1> @llvm.get.active.lane.mask.v8i1.i32(i32 %index, i32 %blockSize)
  %wide.masked.load = call <8 x i16> @llvm.masked.load.v8i16.p0(ptr %next.gep, i32 2, <8 x i1> %active.lane.mask, <8 x i16> undef)
  %wide.masked.load24 = call <8 x i16> @llvm.masked.load.v8i16.p0(ptr %next.gep21, i32 2, <8 x i1> %active.lane.mask, <8 x i16> undef)
  %0 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %wide.masked.load, <8 x i16> %wide.masked.load24)
  call void @llvm.masked.store.v8i16.p0(<8 x i16> %0, ptr %next.gep20, i32 2, <8 x i1> %active.lane.mask)
  %index.next = add i32 %index, 8
  %1 = icmp eq i32 %index.next, %n.vec
  br i1 %1, label %while.end, label %vector.body

while.end:                                        ; preds = %vector.body, %entry
  ret void
}

define arm_aapcs_vfpcc void @sadd_sat(ptr noalias nocapture readonly %pSrcA, ptr noalias nocapture readonly %pSrcB, ptr noalias nocapture %pDst, i32 %blockSize) {
; CHECK-LABEL: sadd_sat:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    it eq
; CHECK-NEXT:    popeq {r7, pc}
; CHECK-NEXT:  .LBB1_1: @ %vector.ph
; CHECK-NEXT:    dlstp.16 lr, r3
; CHECK-NEXT:  .LBB1_2: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrh.u16 q0, [r1], #16
; CHECK-NEXT:    vldrh.u16 q1, [r0], #16
; CHECK-NEXT:    vqadd.s16 q0, q1, q0
; CHECK-NEXT:    vstrh.16 q0, [r2], #16
; CHECK-NEXT:    letp lr, .LBB1_2
; CHECK-NEXT:  @ %bb.3: @ %while.end
; CHECK-NEXT:    pop {r7, pc}
entry:
  %cmp7 = icmp eq i32 %blockSize, 0
  br i1 %cmp7, label %while.end, label %vector.ph

vector.ph:                                        ; preds = %entry
  %n.rnd.up = add i32 %blockSize, 7
  %n.vec = and i32 %n.rnd.up, -8
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %vector.ph
  %index = phi i32 [ 0, %vector.ph ], [ %index.next, %vector.body ]
  %next.gep = getelementptr i16, ptr %pSrcA, i32 %index
  %next.gep20 = getelementptr i16, ptr %pDst, i32 %index
  %next.gep21 = getelementptr i16, ptr %pSrcB, i32 %index
  %active.lane.mask = call <8 x i1> @llvm.get.active.lane.mask.v8i1.i32(i32 %index, i32 %blockSize)
  %wide.masked.load = call <8 x i16> @llvm.masked.load.v8i16.p0(ptr %next.gep, i32 2, <8 x i1> %active.lane.mask, <8 x i16> undef)
  %wide.masked.load24 = call <8 x i16> @llvm.masked.load.v8i16.p0(ptr %next.gep21, i32 2, <8 x i1> %active.lane.mask, <8 x i16> undef)
  %0 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %wide.masked.load, <8 x i16> %wide.masked.load24)
  call void @llvm.masked.store.v8i16.p0(<8 x i16> %0, ptr %next.gep20, i32 2, <8 x i1> %active.lane.mask)
  %index.next = add i32 %index, 8
  %1 = icmp eq i32 %index.next, %n.vec
  br i1 %1, label %while.end, label %vector.body

while.end:                                        ; preds = %vector.body, %entry
  ret void
}

declare <8 x i1> @llvm.get.active.lane.mask.v8i1.i32(i32, i32)

declare <8 x i16> @llvm.masked.load.v8i16.p0(ptr, i32 immarg, <8 x i1>, <8 x i16>)

declare <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16>, <8 x i16>)

declare <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16>, <8 x i16>)

declare void @llvm.masked.store.v8i16.p0(<8 x i16>, ptr, i32 immarg, <8 x i1>)
