; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --force-dwarf-frame-section %s -o - | FileCheck %s
; RUN: llc --filetype=obj %s -o - | llvm-readelf -s --unwind - | FileCheck %s --check-prefix=UNWIND
target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "thumbv7m-arm-none-eabi"

; C++, -Oz
; __attribute__((noinline)) int h(int a, int b) {
;   if (a < 0)
;     throw 1;
;   return a + b;
; }
;
; int f(int a, int b, int c, int d) {
;   if (a < 0)
;     return -1;
;   a = h(a, b);
;   return 2 + a * (a + b) / (c + d);
; }
;
; int g(int a, int b, int c, int d) {
;   if (a < 0)
;     return -1;
;   a = h(a, b);
;   return 1 + a * (a + b) / (c + d);
; }

@_ZTIi = external dso_local constant ptr

define hidden i32 @_Z1hii(i32 %a, i32 %b) local_unnamed_addr #0 {
; CHECK-LABEL: _Z1hii:
; CHECK:         .cfi_sections .debug_frame
; CHECK-NEXT:    .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pac r12, lr, sp
; CHECK-NEXT:    .save {r7, ra_auth_code, lr}
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    push.w {r6, r7, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset lr, -4
; CHECK-NEXT:    .cfi_offset ra_auth_code, -8
; CHECK-NEXT:    .cfi_offset r7, -12
; CHECK-NEXT:    cmp.w r0, #-1
; CHECK-NEXT:    ble .LBB0_2
; CHECK-NEXT:  @ %bb.1: @ %if.end
; CHECK-NEXT:    add r0, r1
; CHECK-NEXT:    pop.w {r3, r7, r12, lr}
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    bx lr
; CHECK-NEXT:  .LBB0_2: @ %if.then
; CHECK-NEXT:    movs r0, #4
; CHECK-NEXT:    bl __cxa_allocate_exception
; CHECK-NEXT:    movs r1, #1
; CHECK-NEXT:    movs r2, #0
; CHECK-NEXT:    str r1, [r0]
; CHECK-NEXT:    ldr r1, .LCPI0_0
; CHECK-NEXT:    bl __cxa_throw
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.3:
; CHECK-NEXT:  .LCPI0_0:
; CHECK-NEXT:    .long _ZTIi
entry:
  %cmp = icmp slt i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %exception = tail call ptr @__cxa_allocate_exception(i32 4) #1
  store i32 1, ptr %exception, align 8
  tail call void @__cxa_throw(ptr %exception, ptr @_ZTIi, ptr null) #2
  unreachable

if.end:                                           ; preds = %entry
  %add = add nsw i32 %b, %a
  ret i32 %add
}

declare dso_local ptr @__cxa_allocate_exception(i32) local_unnamed_addr

declare dso_local void @__cxa_throw(ptr, ptr, ptr) local_unnamed_addr

define hidden i32 @_Z1fiiii(i32 %a, i32 %b, i32 %c, i32 %d) local_unnamed_addr #0 {
; CHECK-LABEL: _Z1fiiii:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pac r12, lr, sp
; CHECK-NEXT:    .save {r4, r5, r6, ra_auth_code, lr}
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    push.w {r3, r4, r5, r6, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    .cfi_offset lr, -4
; CHECK-NEXT:    .cfi_offset ra_auth_code, -8
; CHECK-NEXT:    .cfi_offset r6, -12
; CHECK-NEXT:    .cfi_offset r5, -16
; CHECK-NEXT:    .cfi_offset r4, -20
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    bmi .LBB1_2
; CHECK-NEXT:  @ %bb.1: @ %if.end
; CHECK-NEXT:    bl OUTLINED_FUNCTION_0
; CHECK-NEXT:    adds r1, r0, r6
; CHECK-NEXT:    muls r0, r1, r0
; CHECK-NEXT:    adds r1, r4, r5
; CHECK-NEXT:    sdiv r0, r0, r1
; CHECK-NEXT:    adds r0, #2
; CHECK-NEXT:    b .LBB1_3
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    mov.w r0, #-1
; CHECK-NEXT:  .LBB1_3: @ %return
; CHECK-NEXT:    pop.w {r3, r4, r5, r6, r12, lr}
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp slt i32 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %call = tail call i32 @_Z1hii(i32 %a, i32 %b)
  %add = add nsw i32 %call, %b
  %mul = mul nsw i32 %add, %call
  %add1 = add nsw i32 %d, %c
  %div = sdiv i32 %mul, %add1
  %add2 = add nsw i32 %div, 2
  br label %return

return:                                           ; preds = %entry, %if.end
  %retval.0 = phi i32 [ %add2, %if.end ], [ -1, %entry ]
  ret i32 %retval.0
}

define hidden i32 @_Z1giiii(i32 %a, i32 %b, i32 %c, i32 %d) local_unnamed_addr #0 {
; CHECK-LABEL: _Z1giiii:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pac r12, lr, sp
; CHECK-NEXT:    .save {r4, r5, r6, ra_auth_code, lr}
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    push.w {r3, r4, r5, r6, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    .cfi_offset lr, -4
; CHECK-NEXT:    .cfi_offset ra_auth_code, -8
; CHECK-NEXT:    .cfi_offset r6, -12
; CHECK-NEXT:    .cfi_offset r5, -16
; CHECK-NEXT:    .cfi_offset r4, -20
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    bmi .LBB2_2
; CHECK-NEXT:  @ %bb.1: @ %if.end
; CHECK-NEXT:    bl OUTLINED_FUNCTION_0
; CHECK-NEXT:    adds r1, r0, r6
; CHECK-NEXT:    muls r0, r1, r0
; CHECK-NEXT:    adds r1, r4, r5
; CHECK-NEXT:    sdiv r0, r0, r1
; CHECK-NEXT:    adds r0, #1
; CHECK-NEXT:    b .LBB2_3
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    mov.w r0, #-1
; CHECK-NEXT:  .LBB2_3: @ %return
; CHECK-NEXT:    pop.w {r3, r4, r5, r6, r12, lr}
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp slt i32 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %call = tail call i32 @_Z1hii(i32 %a, i32 %b)
  %add = add nsw i32 %call, %b
  %mul = mul nsw i32 %add, %call
  %add1 = add nsw i32 %d, %c
  %div = sdiv i32 %mul, %add1
  %add2 = add nsw i32 %div, 1
  br label %return

return:                                           ; preds = %entry, %if.end
  %retval.0 = phi i32 [ %add2, %if.end ], [ -1, %entry ]
  ret i32 %retval.0
}

; CHEK-LABEL: OUTLINED_FUNCTION_0:
; CHECK-NOT: pac
; CHECK-NOT: aut
; CHECK:        b    _Z1hii

attributes #0 = { minsize noinline optsize "sign-return-address"="non-leaf" "denormal-fp-math"="preserve-sign,preserve-sign" "denormal-fp-math-f32"="ieee,ieee" "disable-tail-calls"="false" "frame-pointer"="none" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="true" "no-jump-tables"="false" "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="cortex-m3" "target-features"="+armv7-m,+hwdiv,+thumb-mode" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #1 = { nounwind "sign-return-address"="non-leaf" }
attributes #2 = { noreturn "sign-return-address"="non-leaf" }


!llvm.module.flags = !{!0, !1, !2}

!0 = !{i32 8, !"branch-target-enforcement", i32 0}
!1 = !{i32 8, !"sign-return-address", i32 1}
!2 = !{i32 8, !"sign-return-address-all", i32 0}


; UNWIND-LABEL: FunctionAddress: 0x0
; UNWIND: Opcodes [
; UNWIND-NEXT:  0x00      ; vsp = vsp + 4
; UNWIND-NEXT:  0x80 0x08 ; pop {r7}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}

; UNWIND-LABEL: FunctionAddress: 0x30
; UNWIND: Opcodes [
; UNWIND-NEXT:  0x00      ; vsp = vsp + 4
; UNWIND-NEXT:  0xA2      ; pop {r4, r5, r6}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}

; UNWIND-LABEL: FunctionAddress: 0x5C
; UNWIND: Opcodes [
; UNWIND-NEXT:  0x00      ; vsp = vsp + 4
; UNWIND-NEXT:  0xA2      ; pop {r4, r5, r6}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}

; UNWIND-LABEL: FunctionAddress: 0x88
; UNWIND: Opcodes [
; UNWIND-NEXT:  0xB0      ; finish

; UNWIND: 00000089 {{.*}} OUTLINED_FUNCTION_0
; UWNIND: 00000001 {{.*}} _Z1hii
; UWNIND: 00000031 {{.*}} _Z1fiiii
; UWNIND: 0000005d {{.*}} _Z1giiii
