; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=msan -S | FileCheck %s
;
; Forked from llvm/test/CodeGen/X86/f16c-intrinsics.ll
;
; Handled by handleSSEVectorConvertIntrinsicByProp:
; - llvm.x86.vcvtps2ph.128/256

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define <8 x i16> @test_x86_vcvtps2ph_128(<4 x float> %a0) #0 {
; CHECK-LABEL: define <8 x i16> @test_x86_vcvtps2ph_128(
; CHECK-SAME: <4 x float> [[A0:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = shufflevector <4 x i16> [[TMP3]], <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> [[A0]], i32 0)
; CHECK-NEXT:    store <8 x i16> [[TMP11]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i16> [[RES]]
;
  %res = call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> %a0, i32 0) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float>, i32) nounwind readonly

define <8 x i16> @test_x86_vcvtps2ph_256(<8 x float> %a0) #0 {
; CHECK-LABEL: define <8 x i16> @test_x86_vcvtps2ph_256(
; CHECK-SAME: <8 x float> [[A0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <8 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <8 x i1> [[TMP2]] to <8 x i16>
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float> [[A0]], i32 0)
; CHECK-NEXT:    store <8 x i16> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i16> [[RES]]
;
  %res = call <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float> %a0, i32 0) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float>, i32) nounwind readonly


define void @test_x86_vcvtps2ph_256_m(ptr nocapture %d, <8 x float> %a) nounwind #0 {
; CHECK-LABEL: define void @test_x86_vcvtps2ph_256_m(
; CHECK-SAME: ptr captures(none) [[D:%.*]], <8 x float> [[A:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP17:%.*]] = load <8 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP20:%.*]] = icmp ne <8 x i32> [[TMP17]], zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = sext <8 x i1> [[TMP20]] to <8 x i16>
; CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float> [[A]], i32 3)
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP18]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1:![0-9]+]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[D]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 87960930222080
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    store <8 x i16> [[TMP21]], ptr [[TMP3]], align 16
; CHECK-NEXT:    store <8 x i16> [[TMP0]], ptr [[D]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %0 = tail call <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float> %a, i32 3)
  store <8 x i16> %0, ptr %d, align 16
  ret void
}

define void @test_x86_vcvtps2ph_128_m(ptr nocapture %d, <4 x float> %a) nounwind #0 {
; CHECK-LABEL: define void @test_x86_vcvtps2ph_128_m(
; CHECK-SAME: ptr captures(none) [[D:%.*]], <4 x float> [[A:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP9:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ne <4 x i32> [[TMP9]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = sext <4 x i1> [[TMP12]] to <4 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = shufflevector <4 x i16> [[TMP13]], <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> [[A]], i32 3)
; CHECK-NEXT:    [[_MSPROP:%.*]] = shufflevector <8 x i16> [[TMP11]], <8 x i16> splat (i16 -1), <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <8 x i16> [[TMP0]], <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP10]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[D]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = xor i64 [[TMP2]], 87960930222080
; CHECK-NEXT:    [[TMP4:%.*]] = inttoptr i64 [[TMP3]] to ptr
; CHECK-NEXT:    store <4 x i16> [[_MSPROP]], ptr [[TMP4]], align 8
; CHECK-NEXT:    store <4 x i16> [[TMP1]], ptr [[D]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %0 = tail call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> %a, i32 3)
  %1 = shufflevector <8 x i16> %0, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  store <4 x i16> %1, ptr %d, align 8
  ret void
}

define void @test_x86_vcvtps2ph_128_m2(ptr nocapture %hf4x16, <4 x float> %f4X86) #0 {
; CHECK-LABEL: define void @test_x86_vcvtps2ph_128_m2(
; CHECK-SAME: ptr captures(none) [[HF4X16:%.*]], <4 x float> [[F4X86:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP0]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = shufflevector <4 x i16> [[TMP3]], <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP11:%.*]] = tail call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> [[F4X86]], i32 3)
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <8 x i16> [[TMP14]] to <2 x i64>
; CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x i16> [[TMP11]] to <2 x double>
; CHECK-NEXT:    [[_MSPROP:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <2 x double> [[TMP12]], i32 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[HF4X16]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = xor i64 [[TMP15]], 87960930222080
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr [[TMP17]], align 8
; CHECK-NEXT:    store double [[VECEXT]], ptr [[HF4X16]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %0 = tail call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> %f4X86, i32 3)
  %1 = bitcast <8 x i16> %0 to <2 x double>
  %vecext = extractelement <2 x double> %1, i32 0
  store double %vecext, ptr %hf4x16, align 8
  ret void
}

define void @test_x86_vcvtps2ph_128_m3(ptr nocapture %hf4x16, <4 x float> %f4X86) #0 {
; CHECK-LABEL: define void @test_x86_vcvtps2ph_128_m3(
; CHECK-SAME: ptr captures(none) [[HF4X16:%.*]], <4 x float> [[F4X86:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP0]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i16>
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <4 x i16> [[TMP3]], <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP11:%.*]] = tail call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> [[F4X86]], i32 3)
; CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x i16> [[TMP13]] to <2 x i64>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x i16> [[TMP11]] to <2 x i64>
; CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; CHECK-NEXT:    [[VECEXT1:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[HF4X16]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = xor i64 [[TMP15]], 87960930222080
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    store i64 [[VECEXT]], ptr [[TMP17]], align 8
; CHECK-NEXT:    store i64 [[VECEXT1]], ptr [[HF4X16]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %0 = tail call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> %f4X86, i32 3)
  %1 = bitcast <8 x i16> %0 to <2 x i64>
  %vecext = extractelement <2 x i64> %1, i32 0
  store i64 %vecext, ptr %hf4x16, align 8
  ret void
}

attributes #0 = { sanitize_memory }
