; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfhmin,+zvfhmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfhmin,+zvfhmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFHMIN

define half @vreduce_fmin_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fmin_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fmin_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vector.reduce.fmin.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fmax_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fmax_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fmax_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vector.reduce.fmax.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fmin_nnan_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fmin_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fmin_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vector.reduce.fmin.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fmax_nnan_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fmax_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fmax_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vector.reduce.fmax.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fminimum_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fminimum_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vv v9, v8, v8
; ZVFH-NEXT:    vcpop.m a0, v9
; ZVFH-NEXT:    beqz a0, .LBB4_2
; ZVFH-NEXT:  # %bb.1:
; ZVFH-NEXT:    lui a0, %hi(.LCPI4_0)
; ZVFH-NEXT:    flh fa0, %lo(.LCPI4_0)(a0)
; ZVFH-NEXT:    ret
; ZVFH-NEXT:  .LBB4_2:
; ZVFH-NEXT:    vfredmin.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fminimum_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10
; ZVFHMIN-NEXT:    vcpop.m a0, v8
; ZVFHMIN-NEXT:    beqz a0, .LBB4_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    lui a0, 523264
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
; ZVFHMIN-NEXT:  .LBB4_2:
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vector.reduce.fminimum.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fmaximum_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fmaximum_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vv v9, v8, v8
; ZVFH-NEXT:    vcpop.m a0, v9
; ZVFH-NEXT:    beqz a0, .LBB5_2
; ZVFH-NEXT:  # %bb.1:
; ZVFH-NEXT:    lui a0, %hi(.LCPI5_0)
; ZVFH-NEXT:    flh fa0, %lo(.LCPI5_0)(a0)
; ZVFH-NEXT:    ret
; ZVFH-NEXT:  .LBB5_2:
; ZVFH-NEXT:    vfredmax.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fmaximum_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10
; ZVFHMIN-NEXT:    vcpop.m a0, v8
; ZVFHMIN-NEXT:    beqz a0, .LBB5_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    lui a0, 523264
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
; ZVFHMIN-NEXT:  .LBB5_2:
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vector.reduce.fmaximum.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fminimum_nnan_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fminimum_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fminimum_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vector.reduce.fminimum.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

define half @vreduce_fmaximum_nnan_nxv4f16(<vscale x 4 x half> %val) {
; ZVFH-LABEL: vreduce_fmaximum_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v8, v8, v8
; ZVFH-NEXT:    vfmv.f.s fa0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vreduce_fmaximum_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v10
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vector.reduce.fmaximum.nxv4f16(<vscale x 4 x half> %val)
  ret half %s
}

