; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+d --target-abi=ilp32d --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA32 %s
; RUN: llc --mtriple=loongarch64 --mattr=+d --target-abi=lp64d --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA64 %s

;; Check that callee-saved registers clobbered by inlineasm are correctly saved.
;;
;; $r23: $s0 (callee-saved register under all ABIs)
;; $r24: $s1 (callee-saved register under all ABIs)
;; $f24: $fs0 (callee-saved register under *d/*f ABIs)
;; $f25: $fs1 (callee-saved register under *d/*f ABIs)

;; TODO: test other ABIs.

define void @test() nounwind {
; LA32-LABEL: test:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -32
; LA32-NEXT:    st.w $s0, $sp, 28 # 4-byte Folded Spill
; LA32-NEXT:    st.w $s1, $sp, 24 # 4-byte Folded Spill
; LA32-NEXT:    fst.d $fs0, $sp, 16 # 8-byte Folded Spill
; LA32-NEXT:    fst.d $fs1, $sp, 8 # 8-byte Folded Spill
; LA32-NEXT:    #APP
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    fld.d $fs1, $sp, 8 # 8-byte Folded Reload
; LA32-NEXT:    fld.d $fs0, $sp, 16 # 8-byte Folded Reload
; LA32-NEXT:    ld.w $s1, $sp, 24 # 4-byte Folded Reload
; LA32-NEXT:    ld.w $s0, $sp, 28 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 32
; LA32-NEXT:    ret
;
; LA64-LABEL: test:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -32
; LA64-NEXT:    st.d $s0, $sp, 24 # 8-byte Folded Spill
; LA64-NEXT:    st.d $s1, $sp, 16 # 8-byte Folded Spill
; LA64-NEXT:    fst.d $fs0, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    fst.d $fs1, $sp, 0 # 8-byte Folded Spill
; LA64-NEXT:    #APP
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    fld.d $fs1, $sp, 0 # 8-byte Folded Reload
; LA64-NEXT:    fld.d $fs0, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    ld.d $s1, $sp, 16 # 8-byte Folded Reload
; LA64-NEXT:    ld.d $s0, $sp, 24 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 32
; LA64-NEXT:    ret
  tail call void asm sideeffect "", "~{$f24},~{$f25},~{$r23},~{$r24}"()
  ret void
}
