; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s

define i8 @ror8m1(ptr %ptr) {
; CHECK-LABEL: ror8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorb (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd0,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, 1
  %1 = shl i8 %a, 7
  %ror = or i8 %0, %1
  ret i8 %ror
}

define i16 @ror16m1(ptr %ptr) {
; CHECK-LABEL: ror16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorw (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd1,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, 1
  %1 = shl i16 %a, 15
  %ror = or i16 %0, %1
  ret i16 %ror
}

define i32 @ror32m1(ptr %ptr) {
; CHECK-LABEL: ror32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorl (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd1,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, 1
  %1 = shl i32 %a, 31
  %ror = or i32 %0, %1
  ret i32 %ror
}

define i64 @ror64m1(ptr %ptr) {
; CHECK-LABEL: ror64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorq (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd1,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, 1
  %1 = shl i64 %a, 63
  %ror = or i64 %0, %1
  ret i64 %ror
}

define i8 @ror8mcl(ptr %ptr, i8 %cl) {
; CHECK-LABEL: ror8mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, %cl
  %1 = sub i8 8, %cl
  %2 = shl i8 %a, %1
  %ror = or i8 %0, %2
  ret i8 %ror
}

define i8 @ror8mcl_mask(ptr %ptr, i8 %cl) {
; CHECK-LABEL: ror8mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i8 %cl, 31
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, %shamt
  %1 = sub i8 8, %shamt
  %2 = shl i8 %a, %1
  %ror = or i8 %0, %2
  ret i8 %ror
}

define i16 @ror16mcl(ptr %ptr, i16 %cl) {
; CHECK-LABEL: ror16mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, %cl
  %1 = sub i16 16, %cl
  %2 = shl i16 %a, %1
  %ror = or i16 %0, %2
  ret i16 %ror
}

define i16 @ror16mcl_mask(ptr %ptr, i16 %cl) {
; CHECK-LABEL: ror16mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i16 %cl, 31
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, %shamt
  %1 = sub i16 16, %shamt
  %2 = shl i16 %a, %1
  %ror = or i16 %0, %2
  ret i16 %ror
}

define i32 @ror32mcl(ptr %ptr, i32 %cl) {
; CHECK-LABEL: ror32mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorl %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, %cl
  %1 = sub i32 32, %cl
  %2 = shl i32 %a, %1
  %ror = or i32 %0, %2
  ret i32 %ror
}

define i32 @ror32mcl_mask(ptr %ptr, i32 %cl) {
; CHECK-LABEL: ror32mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorl %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i32 %cl, 31
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, %shamt
  %1 = sub i32 32, %shamt
  %2 = shl i32 %a, %1
  %ror = or i32 %0, %2
  ret i32 %ror
}

define i64 @ror64mcl(ptr %ptr, i64 %cl) {
; CHECK-LABEL: ror64mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    rorq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, %cl
  %1 = sub i64 64, %cl
  %2 = shl i64 %a, %1
  %ror = or i64 %0, %2
  ret i64 %ror
}

define i64 @ror64mcl_mask(ptr %ptr, i64 %cl) {
; CHECK-LABEL: ror64mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    rorq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i64 %cl, 63
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, %shamt
  %1 = sub i64 64, %shamt
  %2 = shl i64 %a, %1
  %ror = or i64 %0, %2
  ret i64 %ror
}

define i8 @ror8mi(ptr %ptr) {
; CHECK-LABEL: ror8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolb $5, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0x07,0x05]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, 3
  %1 = shl i8 %a, 5
  %ror = or i8 %0, %1
  ret i8 %ror
}

define i16 @ror16mi(ptr %ptr) {
; CHECK-LABEL: ror16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolw $13, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xc1,0x07,0x0d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, 3
  %1 = shl i16 %a, 13
  %ror = or i16 %0, %1
  ret i16 %ror
}

define i32 @ror32mi(ptr %ptr) {
; CHECK-LABEL: ror32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    roll $29, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0x07,0x1d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, 3
  %1 = shl i32 %a, 29
  %ror = or i32 %0, %1
  ret i32 %ror
}

define i64 @ror64mi(ptr %ptr) {
; CHECK-LABEL: ror64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolq $61, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0x07,0x3d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, 3
  %1 = shl i64 %a, 61
  %ror = or i64 %0, %1
  ret i64 %ror
}

define i8 @ror8r1(i8 noundef %a) {
; CHECK-LABEL: ror8r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorb %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd0,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i8 %a, 1
  %1 = shl i8 %a, 7
  %ror = or i8 %0, %1
  ret i8 %ror
}

define i16 @ror16r1(i16 noundef %a) {
; CHECK-LABEL: ror16r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorw %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd1,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i16 %a, 1
  %1 = shl i16 %a, 15
  %ror = or i16 %0, %1
  ret i16 %ror
}

define i32 @ror32r1(i32 noundef %a) {
; CHECK-LABEL: ror32r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorl %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd1,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i32 %a, 1
  %1 = shl i32 %a, 31
  %ror = or i32 %0, %1
  ret i32 %ror
}

define i64 @ror64r1(i64 noundef %a) {
; CHECK-LABEL: ror64r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorq %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd1,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i64 %a, 1
  %1 = shl i64 %a, 63
  %ror = or i64 %0, %1
  ret i64 %ror
}

define i8 @ror8rcl(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: ror8rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i8 %a, %cl
  %1 = sub i8 8, %cl
  %2 = shl i8 %a, %1
  %ror = or i8 %0, %2
  ret i8 %ror
}

define i8 @ror8rcl_mask(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: ror8rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i8 %cl, 31
  %0 = lshr i8 %a, %shamt
  %1 = sub i8 8, %shamt
  %2 = shl i8 %a, %1
  %ror = or i8 %0, %2
  ret i8 %ror
}

define i16 @ror16rcl(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: ror16rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i16 %a, %cl
  %1 = sub i16 16, %cl
  %2 = shl i16 %a, %1
  %ror = or i16 %0, %2
  ret i16 %ror
}

define i16 @ror16rcl_mask(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: ror16rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i16 %cl, 31
  %0 = lshr i16 %a, %shamt
  %1 = sub i16 16, %shamt
  %2 = shl i16 %a, %1
  %ror = or i16 %0, %2
  ret i16 %ror
}

define i32 @ror32rcl(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: ror32rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorl %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i32 %a, %cl
  %1 = sub i32 32, %cl
  %2 = shl i32 %a, %1
  %ror = or i32 %0, %2
  ret i32 %ror
}

define i32 @ror32rcl_mask(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: ror32rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorl %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i32 %cl, 31
  %0 = lshr i32 %a, %shamt
  %1 = sub i32 32, %shamt
  %2 = shl i32 %a, %1
  %ror = or i32 %0, %2
  ret i32 %ror
}

define i64 @ror64rcl(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: ror64rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    rorq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i64 %a, %cl
  %1 = sub i64 64, %cl
  %2 = shl i64 %a, %1
  %ror = or i64 %0, %2
  ret i64 %ror
}

define i64 @ror64rcl_mask(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: ror64rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    rorq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xcf]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i64 %cl, 63
  %0 = lshr i64 %a, %shamt
  %1 = sub i64 64, %shamt
  %2 = shl i64 %a, %1
  %ror = or i64 %0, %2
  ret i64 %ror
}

define i8 @ror8ri(i8 noundef %a) {
; CHECK-LABEL: ror8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolb $5, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0xc7,0x05]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i8 %a, 3
  %1 = shl i8 %a, 5
  %ror = or i8 %0, %1
  ret i8 %ror
}

define i16 @ror16ri(i16 noundef %a) {
; CHECK-LABEL: ror16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolw $13, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xc1,0xc7,0x0d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i16 %a, 3
  %1 = shl i16 %a, 13
  %ror = or i16 %0, %1
  ret i16 %ror
}

define i32 @ror32ri(i32 noundef %a) {
; CHECK-LABEL: ror32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    roll $29, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0xc7,0x1d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i32 %a, 3
  %1 = shl i32 %a, 29
  %ror = or i32 %0, %1
  ret i32 %ror
}

define i64 @ror64ri(i64 noundef %a) {
; CHECK-LABEL: ror64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolq $61, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0xc7,0x3d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = lshr i64 %a, 3
  %1 = shl i64 %a, 61
  %ror = or i64 %0, %1
  ret i64 %ror
}

define void @ror8m1_legacy(ptr %ptr) {
; CHECK-LABEL: ror8m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorb (%rdi) # encoding: [0xd0,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, 1
  %1 = shl i8 %a, 7
  %ror = or i8 %0, %1
  store i8 %ror, ptr %ptr
  ret void
}

define void @ror16m1_legacy(ptr %ptr) {
; CHECK-LABEL: ror16m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorw (%rdi) # encoding: [0x66,0xd1,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, 1
  %1 = shl i16 %a, 15
  %ror = or i16 %0, %1
  store i16 %ror, ptr %ptr
  ret void
}

define void @ror32m1_legacy(ptr %ptr) {
; CHECK-LABEL: ror32m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorl (%rdi) # encoding: [0xd1,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, 1
  %1 = shl i32 %a, 31
  %ror = or i32 %0, %1
  store i32 %ror, ptr %ptr
  ret void
}

define void @ror64m1_legacy(ptr %ptr) {
; CHECK-LABEL: ror64m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rorq (%rdi) # encoding: [0x48,0xd1,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, 1
  %1 = shl i64 %a, 63
  %ror = or i64 %0, %1
  store i64 %ror, ptr %ptr
  ret void
}

define void @ror8mcl_legacy(ptr %ptr, i8 %cl) {
; CHECK-LABEL: ror8mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorb %cl, (%rdi) # encoding: [0xd2,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, %cl
  %1 = sub i8 8, %cl
  %2 = shl i8 %a, %1
  %ror = or i8 %0, %2
  store i8 %ror, ptr %ptr
  ret void
}

define void @ror16mcl_legacy(ptr %ptr, i16 %cl) {
; CHECK-LABEL: ror16mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, (%rdi) # encoding: [0x66,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, %cl
  %1 = sub i16 16, %cl
  %2 = shl i16 %a, %1
  %ror = or i16 %0, %2
  store i16 %ror, ptr %ptr
  ret void
}

define void @ror32mcl_legacy(ptr %ptr, i32 %cl) {
; CHECK-LABEL: ror32mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorl %cl, (%rdi) # encoding: [0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, %cl
  %1 = sub i32 32, %cl
  %2 = shl i32 %a, %1
  %ror = or i32 %0, %2
  store i32 %ror, ptr %ptr
  ret void
}

define void @ror64mcl_legacy(ptr %ptr, i64 %cl) {
; CHECK-LABEL: ror64mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    rorq %cl, (%rdi) # encoding: [0x48,0xd3,0x0f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, %cl
  %1 = sub i64 64, %cl
  %2 = shl i64 %a, %1
  %ror = or i64 %0, %2
  store i64 %ror, ptr %ptr
  ret void
}

define void @ror8mi_legacy(ptr %ptr) {
; CHECK-LABEL: ror8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolb $5, (%rdi) # encoding: [0xc0,0x07,0x05]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %0 = lshr i8 %a, 3
  %1 = shl i8 %a, 5
  %ror = or i8 %0, %1
  store i8 %ror, ptr %ptr
  ret void
}

define void @ror16mi_legacy(ptr %ptr) {
; CHECK-LABEL: ror16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolw $13, (%rdi) # encoding: [0x66,0xc1,0x07,0x0d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %0 = lshr i16 %a, 3
  %1 = shl i16 %a, 13
  %ror = or i16 %0, %1
  store i16 %ror, ptr %ptr
  ret void
}

define void @ror32mi_legacy(ptr %ptr) {
; CHECK-LABEL: ror32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    roll $29, (%rdi) # encoding: [0xc1,0x07,0x1d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %0 = lshr i32 %a, 3
  %1 = shl i32 %a, 29
  %ror = or i32 %0, %1
  store i32 %ror, ptr %ptr
  ret void
}

define void @ror64mi_legacy(ptr %ptr) {
; CHECK-LABEL: ror64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rolq $61, (%rdi) # encoding: [0x48,0xc1,0x07,0x3d]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %0 = lshr i64 %a, 3
  %1 = shl i64 %a, 61
  %ror = or i64 %0, %1
  store i64 %ror, ptr %ptr
  ret void
}
