; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X64

define double @f1(double %a) {
; X86-LABEL: f1:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    mulsd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-NEXT:    movsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    retl
;
; X64-LABEL: f1:
; X64:       # %bb.0:
; X64-NEXT:    mulsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
  %1 = fadd fast double %a, %a
  %2 = fadd fast double %a, %a
  %3 = fadd fast double %1, %2
  ret double %3
}

define double @f2(double %a) {
; X86-LABEL: f2:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    addsd %xmm0, %xmm0
; X86-NEXT:    movapd %xmm0, %xmm1
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    addsd %xmm0, %xmm1
; X86-NEXT:    movsd %xmm1, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    retl
;
; X64-LABEL: f2:
; X64:       # %bb.0:
; X64-NEXT:    addsd %xmm0, %xmm0
; X64-NEXT:    movapd %xmm0, %xmm1
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    addsd %xmm1, %xmm0
; X64-NEXT:    retq
  %1 = fadd fast double %a, %a
  %t = call double @llvm.arithmetic.fence.f64(double %1)
  %2 = fadd fast double %a, %a
  %3 = fadd fast double %t, %2
  ret double %3
}

define <2 x float> @f3(<2 x float> %a) {
; X86-LABEL: f3:
; X86:       # %bb.0:
; X86-NEXT:    mulps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: f3:
; X64:       # %bb.0:
; X64-NEXT:    mulps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
  %1 = fadd fast <2 x float> %a, %a
  %2 = fadd fast <2 x float> %a, %a
  %3 = fadd fast <2 x float> %1, %2
  ret <2 x float> %3
}

define <2 x float> @f4(<2 x float> %a) {
; X86-LABEL: f4:
; X86:       # %bb.0:
; X86-NEXT:    addps %xmm0, %xmm0
; X86-NEXT:    movaps %xmm0, %xmm1
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    addps %xmm1, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: f4:
; X64:       # %bb.0:
; X64-NEXT:    addps %xmm0, %xmm0
; X64-NEXT:    movaps %xmm0, %xmm1
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    addps %xmm1, %xmm0
; X64-NEXT:    retq
  %1 = fadd fast <2 x float> %a, %a
  %t = call <2 x float> @llvm.arithmetic.fence.v2f32(<2 x float> %1)
  %2 = fadd fast <2 x float> %a, %a
  %3 = fadd fast <2 x float> %t, %2
  ret <2 x float> %3
}

define <8 x float> @f5(<8 x float> %a) {
; X86-LABEL: f5:
; X86:       # %bb.0:
; X86-NEXT:    movaps {{.*#+}} xmm2 = [4.0E+0,4.0E+0,4.0E+0,4.0E+0]
; X86-NEXT:    mulps %xmm2, %xmm0
; X86-NEXT:    mulps %xmm2, %xmm1
; X86-NEXT:    retl
;
; X64-LABEL: f5:
; X64:       # %bb.0:
; X64-NEXT:    movaps {{.*#+}} xmm2 = [4.0E+0,4.0E+0,4.0E+0,4.0E+0]
; X64-NEXT:    mulps %xmm2, %xmm0
; X64-NEXT:    mulps %xmm2, %xmm1
; X64-NEXT:    retq
  %1 = fadd fast <8 x float> %a, %a
  %2 = fadd fast <8 x float> %a, %a
  %3 = fadd fast <8 x float> %1, %2
  ret <8 x float> %3
}

define <8 x float> @f6(<8 x float> %a) {
; X86-LABEL: f6:
; X86:       # %bb.0:
; X86-NEXT:    addps %xmm0, %xmm0
; X86-NEXT:    addps %xmm1, %xmm1
; X86-NEXT:    movaps %xmm1, %xmm2
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    movaps %xmm0, %xmm3
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    addps %xmm3, %xmm0
; X86-NEXT:    addps %xmm2, %xmm1
; X86-NEXT:    retl
;
; X64-LABEL: f6:
; X64:       # %bb.0:
; X64-NEXT:    addps %xmm0, %xmm0
; X64-NEXT:    addps %xmm1, %xmm1
; X64-NEXT:    movaps %xmm1, %xmm2
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    movaps %xmm0, %xmm3
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    addps %xmm3, %xmm0
; X64-NEXT:    addps %xmm2, %xmm1
; X64-NEXT:    retq
  %1 = fadd fast <8 x float> %a, %a
  %t = call <8 x float> @llvm.arithmetic.fence.v8f32(<8 x float> %1)
  %2 = fadd fast <8 x float> %a, %a
  %3 = fadd fast <8 x float> %t, %2
  ret <8 x float> %3
}

define half @f7(half %a) nounwind {
; X86-LABEL: f7:
; X86:       # %bb.0:
; X86-NEXT:    pinsrw $0, {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    retl
;
; X64-LABEL: f7:
; X64:       # %bb.0:
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    retq
  %b = call half @llvm.arithmetic.fence.f16(half %a)
  ret half %b
}

define bfloat @f8(bfloat %a) nounwind {
; X86-LABEL: f8:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    pinsrw $0, %eax, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: f8:
; X64:       # %bb.0:
; X64-NEXT:    pextrw $0, %xmm0, %eax
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    pinsrw $0, %eax, %xmm0
; X64-NEXT:    retq
  %b = call bfloat @llvm.arithmetic.fence.bf16(bfloat %a)
  ret bfloat %b
}

define <2 x half> @f9(<2 x half> %a) nounwind {
; X86-LABEL: f9:
; X86:       # %bb.0:
; X86-NEXT:    movdqa %xmm0, %xmm1
; X86-NEXT:    psrld $16, %xmm1
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-NEXT:    retl
;
; X64-LABEL: f9:
; X64:       # %bb.0:
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrld $16, %xmm1
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X64-NEXT:    retq
  %b = call <2 x half> @llvm.arithmetic.fence.v2f16(<2 x half> %a)
  ret <2 x half> %b
}

define <3 x bfloat> @f10(<3 x bfloat> %a) nounwind {
; X86-LABEL: f10:
; X86:       # %bb.0:
; X86-NEXT:    pextrw $0, %xmm0, %eax
; X86-NEXT:    movdqa %xmm0, %xmm1
; X86-NEXT:    psrld $16, %xmm1
; X86-NEXT:    pextrw $0, %xmm1, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X86-NEXT:    pextrw $0, %xmm0, %edx
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    pinsrw $0, %eax, %xmm0
; X86-NEXT:    pinsrw $0, %ecx, %xmm1
; X86-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-NEXT:    pinsrw $0, %edx, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    retl
;
; X64-LABEL: f10:
; X64:       # %bb.0:
; X64-NEXT:    pextrw $0, %xmm0, %eax
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrld $16, %xmm1
; X64-NEXT:    pextrw $0, %xmm1, %ecx
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    pextrw $0, %xmm0, %edx
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    pinsrw $0, %eax, %xmm0
; X64-NEXT:    pinsrw $0, %ecx, %xmm1
; X64-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X64-NEXT:    pinsrw $0, %edx, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    retq
  %b = call <3 x bfloat> @llvm.arithmetic.fence.v3bf16(<3 x bfloat> %a)
  ret <3 x bfloat> %b
}

define <4 x bfloat> @f11(<4 x bfloat> %a) nounwind {
; X86-LABEL: f11:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movdqa %xmm0, %xmm1
; X86-NEXT:    psrlq $48, %xmm1
; X86-NEXT:    pextrw $0, %xmm1, %eax
; X86-NEXT:    movdqa %xmm0, %xmm1
; X86-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; X86-NEXT:    pextrw $0, %xmm1, %edx
; X86-NEXT:    pextrw $0, %xmm0, %ecx
; X86-NEXT:    psrld $16, %xmm0
; X86-NEXT:    pextrw $0, %xmm0, %esi
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    #ARITH_FENCE
; X86-NEXT:    pinsrw $0, %eax, %xmm0
; X86-NEXT:    pinsrw $0, %edx, %xmm1
; X86-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-NEXT:    pinsrw $0, %ecx, %xmm0
; X86-NEXT:    pinsrw $0, %esi, %xmm2
; X86-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; X64-LABEL: f11:
; X64:       # %bb.0:
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrlq $48, %xmm1
; X64-NEXT:    pextrw $0, %xmm1, %eax
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; X64-NEXT:    pextrw $0, %xmm1, %ecx
; X64-NEXT:    pextrw $0, %xmm0, %edx
; X64-NEXT:    psrld $16, %xmm0
; X64-NEXT:    pextrw $0, %xmm0, %esi
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    #ARITH_FENCE
; X64-NEXT:    pinsrw $0, %eax, %xmm0
; X64-NEXT:    pinsrw $0, %ecx, %xmm1
; X64-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X64-NEXT:    pinsrw $0, %edx, %xmm0
; X64-NEXT:    pinsrw $0, %esi, %xmm2
; X64-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    retq
  %b = call <4 x bfloat> @llvm.arithmetic.fence.v4bf16(<4 x bfloat> %a)
  ret <4 x bfloat> %b
}

declare half @llvm.arithmetic.fence.f16(half)
declare bfloat @llvm.arithmetic.fence.bf16(bfloat)
declare <2 x half> @llvm.arithmetic.fence.v2f16(<2 x half>)
declare <3 x bfloat> @llvm.arithmetic.fence.v3bf16(<3 x bfloat>)
declare <4 x bfloat> @llvm.arithmetic.fence.v4bf16(<4 x bfloat>)
declare float @llvm.arithmetic.fence.f32(float)
declare double @llvm.arithmetic.fence.f64(double)
declare <2 x float> @llvm.arithmetic.fence.v2f32(<2 x float>)
declare <8 x float> @llvm.arithmetic.fence.v8f32(<8 x float>)
