; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=inline < %s | FileCheck %s

; Make sure the loop condition is not incorrectly simplified during inlinig.
define internal i32 @pow(i32 %Base, i32 %Power) {
entry:
  %IsZero = icmp eq i32 %Power, 0
  br i1 %IsZero, label %while.end, label %while.body

while.body:
  %Val = phi i32 [ %mul, %while.body ], [ 1, %entry ]
  %Power.Phi = phi i32 [ %dec, %while.body ], [ %Power, %entry ]
  %dec = add i32 %Power.Phi, -1
  %mul = mul i32 %Val, %Base
  %tobool.not = icmp eq i32 %dec, 0
  br i1 %tobool.not, label %while.end, label %while.body

while.end:
  %Res = phi i32 [ 1, %entry ], [ %mul, %while.body ]
  ret i32 %Res
}

define i32 @caller(i32 %Base, i32 %Power) {
; CHECK-LABEL: define i32 @caller
; CHECK-SAME: (i32 [[BASE:%.*]], i32 [[POWER:%.*]]) {
; CHECK-NEXT:    [[ISZERO_I:%.*]] = icmp eq i32 [[POWER]], 0
; CHECK-NEXT:    br i1 [[ISZERO_I]], label [[POW_EXIT:%.*]], label [[WHILE_BODY_I:%.*]]
; CHECK:       while.body.i:
; CHECK-NEXT:    [[VAL_I:%.*]] = phi i32 [ [[MUL_I:%.*]], [[WHILE_BODY_I]] ], [ 1, [[TMP0:%.*]] ]
; CHECK-NEXT:    [[POWER_PHI_I:%.*]] = phi i32 [ [[DEC_I:%.*]], [[WHILE_BODY_I]] ], [ [[POWER]], [[TMP0]] ]
; CHECK-NEXT:    [[DEC_I]] = add i32 [[POWER_PHI_I]], -1
; CHECK-NEXT:    [[MUL_I]] = mul i32 [[VAL_I]], [[BASE]]
; CHECK-NEXT:    [[TOBOOL_NOT_I:%.*]] = icmp eq i32 [[DEC_I]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT_I]], label [[POW_EXIT]], label [[WHILE_BODY_I]]
; CHECK:       pow.exit:
; CHECK-NEXT:    [[RES_I:%.*]] = phi i32 [ 1, [[TMP0]] ], [ [[MUL_I]], [[WHILE_BODY_I]] ]
; CHECK-NEXT:    ret i32 [[RES_I]]
;
  %res = call i32 @pow(i32 %Base, i32 %Power)
  ret i32 %res
}
